/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.model;

import com.arm.streamline.analysis.database.EventsChart;
import com.arm.streamline.common.model.counters.CounterClass;
import com.arm.streamline.common.model.counters.CounterDisplay;
import com.arm.streamline.common.model.counters.CounterMode;
import com.arm.streamline.common.model.counters.CounterRecord;
import com.arm.streamline.common.model.counters.GraphRenderingType;
import com.arm.streamline.common.model.counters.SeriesComposition;
import com.arm.streamline.common.model.topology.DeviceType;
import com.arm.streamline.common.utility.Ternary;
import com.arm.streamline.utility.RGBUtils;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.graphics.RGB;

public final class CounterRecordUtils {
    public static @NonNull CounterRecord createCPUActivityCounterRecord(String name, String description, int cores, RGB color, int key) {
        CounterRecord userRecord = new CounterRecord();
        userRecord.setCores(cores);
        userRecord.setTitle("CPU Activity");
        userRecord.setName(name);
        userRecord.setDescription(description);
        CounterRecordUtils.setColor(userRecord, color);
        userRecord.setMultiplier(1.0E-4);
        userRecord.setMode(CounterMode.PER_CORE);
        userRecord.setAverageSelection(true);
        userRecord.setAverageCores(true);
        userRecord.setPercentage(true);
        userRecord.setUnits("");
        userRecord.setSeriesComposition(SeriesComposition.STACKED);
        userRecord.setRenderingType(GraphRenderingType.BAR);
        userRecord.setDisplay(CounterDisplay.AVERAGE);
        userRecord.setCounterClass(CounterClass.ACTIVITY);
        userRecord.setDeviceType(DeviceType.CPU);
        userRecord.setKey(key);
        return userRecord;
    }

    public static @NonNull CounterRecord createEventsChartCounterRecord(@NonNull EventsChart eventsChart, int index, Integer clusterIndex, List<CounterRecord> counterRecordsList, boolean alwaysSelected) {
        CounterRecord cr = new CounterRecord();
        cr.setTitle(eventsChart.getTitle());
        cr.setName(eventsChart.getNames()[index]);
        cr.setCores(eventsChart.getCores());
        cr.setDeviceType(eventsChart.getDeviceType());
        cr.setDescription(eventsChart.getDescriptions()[index]);
        CounterRecordUtils.setColor(cr, RGBUtils.create(eventsChart.getColors()[index]));
        cr.setAverageCores(true);
        cr.setAverageSelection(true);
        cr.setCounterClass(CounterClass.ACTIVITY);
        cr.setDisplay(CounterDisplay.AVERAGE);
        cr.setRenderingType(GraphRenderingType.BAR);
        cr.setSeriesComposition(SeriesComposition.STACKED);
        cr.setPercentage(true);
        cr.setMultiplier(1.0E-4);
        cr.setMode(eventsChart.getPerCore() ? CounterMode.PER_CORE : CounterMode.SYSTEM_WIDE);
        cr.setChannelDescriptions(eventsChart.getChannelDescriptors());
        cr.setProc(eventsChart.isProc() ? Ternary.TRUE : Ternary.FALSE);
        cr.setOrder(index);
        if (eventsChart.getDeviceType().isCPU()) {
            cr.setCluster(clusterIndex);
            @NonNull String crAlias = cr.getAlias();
            if (!alwaysSelected) {
                boolean itemSelectedByUserFromCounterConfiguration = false;
                for (CounterRecord record : counterRecordsList) {
                    boolean ignoreCluster;
                    @NonNull String recordAlias = record.getAlias(ignoreCluster = clusterIndex == null);
                    if (!recordAlias.contentEquals(crAlias)) continue;
                    itemSelectedByUserFromCounterConfiguration = true;
                    break;
                }
                if (!itemSelectedByUserFromCounterConfiguration) {
                    cr.setSelected(false);
                }
            } else {
                cr.setSelected(true);
            }
        }
        return cr;
    }

    public static @Nullable RGB getColorRGB(@NonNull CounterRecord cr) {
        @Nullable Integer color = cr.getColor();
        if (color == null) {
            return null;
        }
        return RGBUtils.create(color);
    }

    public static void setColor(@NonNull CounterRecord cr, @Nullable RGB color) {
        if (color == null) {
            cr.setColor(null);
        } else {
            cr.setColor(Integer.valueOf(RGBUtils.toInt(color)));
        }
    }
}

