/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.live;

import com.arm.streamline.analysis.database.api.profiling.IBacktraceSource;
import com.arm.streamline.analysis.gator.GatorProtocolVersion;
import com.arm.streamline.analysis.gator.ICaptureDetails;
import com.arm.streamline.analysis.gator.ProtocolInfo;
import com.arm.streamline.analysis.live.LiveProtocolEventStream;
import com.arm.streamline.capture.apc.APCDatabaseGenerator;
import com.arm.streamline.common.model.counters.CounterRecord;
import com.arm.streamline.common.model.counters.SpeCaptureRecord;
import com.arm.streamline.protocol.capture.apc.io.IAPCCaptureFrameStream;
import com.arm.streamline.protocol.capture.apc.live.ILiveOutputStreamFactory;
import com.arm.streamline.protocol.capture.apc.live.LiveAPCPassOne;
import com.arm.streamline.protocol.capture.apc.pass_one.IAPCPassOne;
import com.arm.streamline.protocol.capture.apc.pass_one.IPassOneGlobalStateNotificationCallbacks;
import com.arm.streamline.report.model.topology.IClustersInfo;
import com.arm.utils.function.ICloseableThrowingRunnable;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;

public final class LiveOnlyFrameProcessorPass
implements ICloseableThrowingRunnable<IOException> {
    private final @NonNull IClustersInfo clusterInfo;
    private final @NonNull List<@NonNull CounterRecord> counterRecords;
    private final @NonNull Set<@NonNull SpeCaptureRecord> speCaptureRecords;
    private final @NonNull IAPCCaptureFrameStream frameStream;
    private final @NonNull LiveProtocolEventStream liveProtocolEventStream;
    private final int numberOfCores;
    private final @NonNull ProtocolInfo protocolInfo;
    private final @NonNull IPassOneGlobalStateNotificationCallbacks callbacks;
    private final boolean isMultiGpu;
    private final boolean isAtraceEnabled;
    private final @NonNull IBacktraceSource backtraceSource;

    public LiveOnlyFrameProcessorPass(@NonNull ICaptureDetails captureDetails, @NonNull IAPCCaptureFrameStream frameStream, @NonNull IClustersInfo clusterInfo, @NonNull LiveProtocolEventStream liveProtocolEventStream, @NonNull IPassOneGlobalStateNotificationCallbacks callbacks) {
        this.frameStream = frameStream;
        this.clusterInfo = clusterInfo;
        this.liveProtocolEventStream = liveProtocolEventStream;
        this.callbacks = callbacks;
        this.counterRecords = captureDetails.getCounterList();
        this.speCaptureRecords = captureDetails.getSpes();
        this.isMultiGpu = captureDetails.hasMutiGpu();
        this.protocolInfo = captureDetails.getProtocolInfo();
        this.numberOfCores = captureDetails.getNumberOfCores();
        this.isAtraceEnabled = captureDetails.isAtraceEnabled();
        this.backtraceSource = APCDatabaseGenerator.findBacktraceSource(this.counterRecords);
    }

    public @NonNull LiveAPCPassOne createPassOne() {
        switch (this.protocolInfo.getType()) {
            case PERF: {
                boolean useModernSyncThread = GatorProtocolVersion.isStreamline690OrLater(this.protocolInfo.getRawProtocolVersion());
                return LiveAPCPassOne.forPerfProtocolV22((IBacktraceSource)this.backtraceSource, (boolean)useModernSyncThread, (int)this.numberOfCores, this.speCaptureRecords, this.counterRecords, (IClustersInfo)this.clusterInfo, (ILiveOutputStreamFactory)this.liveProtocolEventStream, (IPassOneGlobalStateNotificationCallbacks)this.callbacks, (boolean)this.isMultiGpu, (boolean)this.isAtraceEnabled, (int)this.protocolInfo.getRawProtocolVersion());
            }
        }
        throw new AssertionError(this.protocolInfo.getType());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run() throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try {
            LiveAPCPassOne apcPassOne = this.createPassOne();
            try {
                try (IAPCCaptureFrameStream frameStream = this.frameStream;){
                    IAPCPassOne.process((IAPCCaptureFrameStream)frameStream, (IAPCPassOne)apcPassOne);
                }
                if (apcPassOne == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (apcPassOne == null) throw throwable;
                apcPassOne.close();
                throw throwable;
            }
            apcPassOne.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    public void close() throws IOException {
    }
}

