/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.live;

import com.arm.streamline.analysis.gator.ICaptureDetails;
import com.arm.streamline.analysis.gator.ILiveAgentCapabilities;
import com.arm.streamline.analysis.live.ILiveGator;
import com.arm.streamline.analysis.live.LiveActivity;
import com.arm.streamline.analysis.live.LiveCPUActivity;
import com.arm.streamline.analysis.live.LiveCPUWaitCounters;
import com.arm.streamline.analysis.live.LiveCounter;
import com.arm.streamline.analysis.live.LiveHeatMap;
import com.arm.streamline.analysis.model.CounterRecordUtils;
import com.arm.streamline.analysis.model.DeviceTypeCalculator;
import com.arm.streamline.analysis.model.threads.IUniqueThread;
import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.common.CommonPlugin;
import com.arm.streamline.common.model.counters.CounterDisplay;
import com.arm.streamline.common.model.counters.CounterRecord;
import com.arm.streamline.common.model.topology.DeviceType;
import com.arm.streamline.common.model.topology.ProcessingElementReference;
import com.arm.streamline.common.utility.Ternary;
import com.arm.streamline.common.utility.io.StdLog;
import com.arm.streamline.model.chart.ColorPalette;
import com.arm.streamline.model.live.ILiveAllBinDataProvider;
import com.arm.streamline.model.live.ILiveProcessDataProvider;
import com.arm.streamline.model.live.LiveBinDataProvider;
import com.arm.streamline.model.session.ICaptureInputSettings;
import com.arm.streamline.protocol.capture.apc.pass_two.IUniqueThreadTracker;
import com.arm.streamline.report.model.topology.IClustersInfo;
import com.arm.streamline.utility.RGBUtils;
import com.arm.utils.NullChecking;
import com.arm.utils.collections.Pair;
import gnu.trove.iterator.TIntLongIterator;
import gnu.trove.iterator.TIntObjectIterator;
import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.map.hash.TIntLongHashMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.set.TIntSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.graphics.RGB;

public class LiveGator
implements ILiveGator {
    public static final int LIVE_RATE_IN_NS = 100000000;
    public static final int COMMIT_THRESHOLD = 300000000;
    public static final int LIVE_RATE_IN_MS = 100;
    public static final int LIVE_BINS_PER_S = 10;
    private static final int CPU_ACTIVITY_USER_KEY = -1;
    private static final int CPU_ACTIVITY_SYSTEM_KEY = -2;
    public static final int ACTIVITY_SCALE = 10000;
    public static final double ACTIVITY_MULTIPLIER = 1.0E-4;
    public static final int ACTIVITY_KEY_BASE = 0x30000000;
    private static final int ACTIVITY_KEY_OFFSET = 100;
    public static final int DYNAMIC_KEY_BASE = 0x40000000;
    private LiveActivity mActivity = new LiveActivity();
    private TIntArrayList mActivityCores = new TIntArrayList();
    private TIntArrayList mActivityKeys = new TIntArrayList();
    private ILiveAllBinDataProvider mAllBinDataProvider;
    private ICaptureInputSettings mCaptureSettings;
    private final @NonNull IClustersInfo mClustersInfo;
    private ColorPalette mColorPalette = new ColorPalette();
    private TIntIntHashMap mCoreToSystemKeyMap = new TIntIntHashMap();
    private TIntIntHashMap mCoreToUserKeyMap = new TIntIntHashMap();
    private boolean mCounterCommitOccurred = false;
    private LiveCounter mCounters;
    private LiveCPUActivity mCPUActivity;
    private LiveCPUWaitCounters mDerived;
    private DeviceTypeCalculator mDTCalc;
    private LiveHeatMap mHeatMap;
    private TIntArrayList mKeys = new TIntArrayList();
    private TIntArrayList mNumActivities = new TIntArrayList();
    private int mNumCores;
    private final TIntObjectMap<IUniqueThread> mProcCounterKeyToUniqueThreadMap = new TIntObjectHashMap();
    private ILiveProcessDataProvider mProcessDataProvider;
    private long mThreshold;
    private final @NonNull TIntSet warnedMissingchartKeys;
    private @NonNull Map<@NonNull Integer, @NonNull Pair<@NonNull Long, @NonNull Long>> recordBuffer = new HashMap<Integer, Pair<Long, Long>>();

    private static int mapProcessingElementReference(@NonNull ProcessingElementReference processingElementReference) {
        if (processingElementReference.deviceType.isSystemWide()) {
            return 0;
        }
        assert (processingElementReference.vmUID == 0L);
        return processingElementReference.deviceNumber;
    }

    public LiveGator(@NonNull ILiveAllBinDataProvider allBinDataProvider, @NonNull ILiveProcessDataProvider liveModelProc, @NonNull List<@NonNull CounterRecord> counterRecordList, @NonNull ICaptureDetails captureDetails, ICaptureInputSettings captureSettings, @NonNull ILiveAgentCapabilities agentCapabilities, @NonNull IClustersInfo clustersInfo, @NonNull TIntSet warnedMissingchartKeys) {
        this.mAllBinDataProvider = allBinDataProvider;
        this.mProcessDataProvider = liveModelProc;
        this.mCaptureSettings = captureSettings;
        this.mClustersInfo = clustersInfo;
        this.mNumCores = captureDetails.getNumberOfCores();
        this.mThreshold = Long.MAX_VALUE;
        this.warnedMissingchartKeys = warnedMissingchartKeys;
        IUniqueThread idleThread = this.mProcessDataProvider.getIdleThread();
        this.mCPUActivity = new LiveCPUActivity(this.mNumCores);
        this.mHeatMap = new LiveHeatMap(this.mNumCores, idleThread);
        this.mDerived = new LiveCPUWaitCounters(this.mNumCores, idleThread);
        if (!agentCapabilities.supportsSelectableCPUActivity()) {
            RGB userColor = RGBUtils.create(-2143625405);
            RGB systemColor = RGBUtils.create(-2132850878);
            CounterRecord userRecord = CounterRecordUtils.createCPUActivityCounterRecord("User", "User activity", this.mNumCores, userColor, -1);
            CounterRecord systemRecord = CounterRecordUtils.createCPUActivityCounterRecord("System", "System activity", this.mNumCores, systemColor, -2);
            allBinDataProvider.addCounterSource(userRecord);
            allBinDataProvider.addCounterSource(systemRecord);
        }
        int core = 0;
        while (core < this.mNumCores) {
            this.mCoreToUserKeyMap.put(core, -1);
            this.mCoreToSystemKeyMap.put(core, -2);
            ++core;
        }
        Collections.sort(counterRecordList);
        this.mDTCalc = captureDetails.createDeviceTypeCalculator();
        this.mCounters = new LiveCounter(this.mNumCores);
        for (CounterRecord record : counterRecordList) {
            int key = record.getKey();
            @Nullable Integer gpuCoresCount = captureDetails.getGpuCoresCount();
            @NonNull DeviceType device = this.mDTCalc.calcDeviceType(record, this.mNumCores, gpuCoresCount);
            if (record.isMemoryUsed() && record.isProc() == Ternary.TRUE) {
                liveModelProc.setProcessMemoryDataAvailable();
            }
            @Nullable CounterRecord counterForKey = captureDetails.getCounter(key);
            assert (counterForKey != null);
            if (counterForKey.isMetric()) continue;
            if (counterForKey.isDerived()) {
                int activityKey;
                if (record.isCPUActivityUser()) {
                    activityKey = -1;
                    if (agentCapabilities.supportsSelectableCPUActivityPerCluster()) {
                        int[] cores;
                        var21_36 = cores = this.getCores(record);
                        int n = cores.length;
                        int n2 = 0;
                        while (n2 < n) {
                            int core2 = var21_36[n2];
                            this.mCoreToUserKeyMap.put(core2, key);
                            activityKey = key;
                            ++n2;
                        }
                    }
                } else if (record.isCPUActivitySystem()) {
                    activityKey = -2;
                    if (agentCapabilities.supportsSelectableCPUActivityPerCluster()) {
                        int[] cores;
                        var21_36 = cores = this.getCores(record);
                        int n = cores.length;
                        int n3 = 0;
                        while (n3 < n) {
                            int core3 = var21_36[n3];
                            this.mCoreToSystemKeyMap.put(core3, key);
                            activityKey = key;
                            ++n3;
                        }
                    }
                } else {
                    activityKey = key;
                    this.mDerived.initialize(record.getCounter(), activityKey);
                }
                CounterRecord derivedCounter = new CounterRecord(record);
                derivedCounter.setCores(record.isPerCPU() ? this.mNumCores : 1);
                derivedCounter.setKey(activityKey);
                allBinDataProvider.addCounterSource(derivedCounter);
                continue;
            }
            if (counterForKey.getCounterClass().isActivity()) {
                int index = 1;
                List activityStrings = counterForKey.getActivity();
                for (String name : activityStrings) {
                    CounterRecord activityRecord = new CounterRecord(record);
                    TIntArrayList colors = counterForKey.getActivityColor();
                    RGB rgb = CounterRecordUtils.getColorRGB(record);
                    if (index - 1 < colors.size()) {
                        rgb = RGBUtils.create(colors.get(index - 1));
                    }
                    CounterRecordUtils.setColor(activityRecord, rgb);
                    activityRecord.setName(name);
                    activityRecord.setMultiplier(1.0E-4);
                    activityRecord.setDeviceType(device);
                    activityRecord.setOrder(index);
                    int newKey = 0x30000000 + this.mActivityKeys.size() * 100 + index++;
                    activityRecord.setKey(newKey);
                    activityRecord.setCores(record.isPerCPU() ? record.getCores() : 1);
                    allBinDataProvider.addCounterSource(activityRecord);
                }
                this.mActivityKeys.add(key);
                this.mActivityCores.add(record.isPerCPU() ? record.getCores() : 1);
                this.mNumActivities.add(activityStrings.size());
                continue;
            }
            CounterRecord liveCounter = new CounterRecord(record);
            liveCounter.setCores(record.isPerCPU() ? record.getCores() : 1);
            liveCounter.setDeviceType(device);
            allBinDataProvider.addCounterSource(liveCounter);
            int core4 = 0;
            while (core4 < this.mNumCores) {
                this.mCounters.initialize(core4, key, this.mThreshold, counterForKey.getCounterClass(), counterForKey.isPerCPU());
                ++core4;
            }
            this.mKeys.add(key);
        }
        int index = 0;
        while (index < this.mActivityKeys.size()) {
            this.mActivity.initialize(this.mActivityCores.get(index), this.mActivityKeys.get(index));
            ++index;
        }
    }

    @Override
    public void activitySwitch(@NonNull ProcessingElementReference processingElementReference, long time, int key, int activity) {
        long startOfBin = this.mThreshold - 100000000L;
        if (time < startOfBin) {
            return;
        }
        if (time >= this.mThreshold + 300000000L) {
            this.commit(time);
        }
        if (this.mActivity != null) {
            this.mActivity.add(LiveGator.mapProcessingElementReference(processingElementReference), time, key, activity);
        }
    }

    public void addCoreName(@NonNull ProcessingElementReference processingElementReference, String label) {
        this.mAllBinDataProvider.addCoreName(LiveGator.mapProcessingElementReference(processingElementReference), label);
    }

    @Override
    public void addCounterDuringCapture(CounterRecord counter) {
        if (counter.getCounterClass().isActivity()) {
            this.dynamicActivityCounter(counter);
        } else {
            this.dynamicCounter(counter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public void addCounterSample(long time, int key, long value, @Nullable IUniqueThread uniqueThread) {
        if (time < 0L) {
            return;
        }
        if (!this.recordBuffer.containsKey(key)) {
            this.recordBuffer.put(key, (Pair<Long, Long>)new Pair((Object)time, (Object)value));
        }
        @NonNull @NonNull @NonNull Pair record = (Pair)NullChecking.neverNull(this.recordBuffer.get(key));
        LiveBinDataProvider provider = this.mAllBinDataProvider.getProvider(key);
        if (provider != null) {
            if (time != (Long)record.first) {
                boolean isMemoryUsed;
                this.commit((Long)record.first);
                if (uniqueThread != null) {
                    this.mProcCounterKeyToUniqueThreadMap.put(key, (Object)uniqueThread);
                }
                if ((isMemoryUsed = provider.getCounterRecord().isMemoryUsed()) && uniqueThread != null) {
                    this.mProcessDataProvider.setMemoryUsedValue(uniqueThread, (Long)record.second);
                } else {
                    this.addCounterSample((long)((Long)record.first), null, key, (Long)record.second);
                }
            }
            this.recordBuffer.replace(key, (Pair<Long, Long>)new Pair((Object)time, (Object)value));
        } else {
            TIntSet tIntSet = this.warnedMissingchartKeys;
            synchronized (tIntSet) {
                if (this.warnedMissingchartKeys.add(key)) {
                    StdLog.warning((Plugin)StreamlinePlugin.getInstance(), (String)("Missing chart for key " + key), null);
                }
            }
        }
    }

    @Override
    public void addCounterSample(long time, @Nullable ProcessingElementReference processingElementReference, int key, long value) {
        if (!this.mCounters.exists(key) || time < 0L) {
            return;
        }
        this.commit(time);
        int core = this.mCounters.isSystemWideCounter(key) || processingElementReference == null ? 0 : LiveGator.mapProcessingElementReference(processingElementReference);
        long carryOver = this.mCounters.addCounter(core, key, time, value);
        while (carryOver >= 0L) {
            this.mCounters.commit(core, key).forEach((display, displayValue) -> this.mAllBinDataProvider.addData((CounterDisplay)display, core, key, (long)displayValue));
            carryOver = this.mCounters.addCounter(core, key, time, carryOver);
            this.mCounterCommitOccurred = true;
        }
    }

    @Override
    public void addVisualChart(@NonNull IUniqueThread uniqueThread) {
        this.mAllBinDataProvider.addVisualChart(uniqueThread);
    }

    @Override
    public void schedSwitch(@NonNull ProcessingElementReference processingElementReference, long time, @NonNull IUniqueThread uniqueThread, int state) {
        long startOfBin = this.mThreshold - 100000000L;
        if (time < startOfBin) {
            return;
        }
        this.commit(time);
        int core = LiveGator.mapProcessingElementReference(processingElementReference);
        this.mProcessDataProvider.schedSwitch(time, uniqueThread);
        this.mCPUActivity.add(core, time, uniqueThread);
        this.mHeatMap.add(core, time, uniqueThread);
        this.mDerived.add(core, time, uniqueThread, state);
    }

    public void setEndTime(long time) {
        if (this.mThreshold != Long.MAX_VALUE) {
            this.commit(time + 300000000L);
        }
        if (!this.mCaptureSettings.isEfficientFtraceEnabled() && this.mCounters.getTotalValues() > 0L && this.mCounters.getDroppedValues() * 100L / this.mCounters.getTotalValues() >= 1L) {
            CommonPlugin.error((String)"More than 1% of the Live data was dropped", (Throwable)new Throwable());
        }
    }

    @Override
    public void setStartTime(long time) {
        if (!this.mCounterCommitOccurred) {
            this.mThreshold = time + 100000000L;
            int core = 0;
            while (core < this.mNumCores) {
                int[] keys;
                int[] nArray = keys = this.mKeys.toArray();
                int n = keys.length;
                int n2 = 0;
                while (n2 < n) {
                    int key = nArray[n2];
                    this.mCounters.setThreshold(core, key, this.mThreshold);
                    ++n2;
                }
                ++core;
            }
            this.mHeatMap.setStartTime(time);
            this.mCPUActivity.setStartTime(time);
            if (this.mActivity != null) {
                this.mActivity.setStartTime(time);
            }
        }
        this.mAllBinDataProvider.gatorDataReceived();
    }

    @Override
    public void threadExit(long timestamp, @NonNull IUniqueThread uniqueThread) {
        this.mProcessDataProvider.threadExit(uniqueThread);
        this.mDerived.free(timestamp, uniqueThread);
        TIntObjectIterator itr = this.mProcCounterKeyToUniqueThreadMap.iterator();
        while (itr.hasNext()) {
            itr.advance();
            if (!uniqueThread.equals(itr.value())) continue;
            this.addCounterSample(timestamp, itr.key(), 0L, uniqueThread);
            itr.remove();
        }
        if (timestamp < 0L) {
            return;
        }
        this.commit(timestamp);
    }

    @Override
    public void threadFork(long timestamp, @NonNull IUniqueThread uniqueThread) {
        this.mProcessDataProvider.threadFork(uniqueThread);
    }

    @Override
    public void threadUpdate(long timestamp, @NonNull IUniqueThread uniqueThread) {
        this.mProcessDataProvider.threadUpdate(uniqueThread);
    }

    private void commit(long time) {
        boolean commitOccurred = false;
        while (time >= this.mThreshold + 300000000L) {
            commitOccurred = true;
            if (this.mActivity != null) {
                TIntObjectHashMap<ArrayList<TIntLongHashMap>> result = this.mActivity.commit(this.mThreshold);
                int keyIndex = 0;
                while (keyIndex < this.mActivityKeys.size()) {
                    int key = this.mActivityKeys.get(keyIndex);
                    int numCores = this.mActivityCores.get(keyIndex);
                    int numActivities = this.mNumActivities.get(keyIndex);
                    int core = 0;
                    while (core < numCores) {
                        int activity = 0;
                        while (activity++ < numActivities) {
                            int newKey = 0x30000000 + keyIndex * 100 + activity;
                            long value = ((TIntLongHashMap)((ArrayList)result.get(key)).get(core)).get(activity);
                            this.mAllBinDataProvider.addData(CounterDisplay.AVERAGE, core, newKey, value * 10000L / 100000000L);
                        }
                        ++core;
                    }
                    ++keyIndex;
                }
            }
            List<LiveCPUActivity.UserAndSystem> states = this.mCPUActivity.commit(this.mThreshold);
            int core = 0;
            while (core < this.mNumCores) {
                this.mAllBinDataProvider.addData(CounterDisplay.AVERAGE, core, this.mCoreToUserKeyMap.get(core), states.get((int)core).user * 10000L / 100000000L);
                this.mAllBinDataProvider.addData(CounterDisplay.AVERAGE, core, this.mCoreToSystemKeyMap.get(core), states.get((int)core).system * 10000L / 100000000L);
                ++core;
            }
            this.mProcessDataProvider.clearCPUActivity();
            for (Map.Entry<IUniqueThread, TIntArrayList> entry : this.mHeatMap.commit(this.mThreshold).entrySet()) {
                IUniqueThread uniqueThread = entry.getKey();
                TIntArrayList list = entry.getValue();
                int percentage = 0;
                int core2 = 0;
                while (core2 < this.mNumCores) {
                    percentage += list.get(core2);
                    ++core2;
                }
                this.mProcessDataProvider.setCPUActivityValue(uniqueThread, percentage / this.mNumCores);
            }
            this.mProcessDataProvider.nextBin();
            TIntLongHashMap values = this.mDerived.commit(this.mThreshold);
            TIntLongIterator valuesItr = values.iterator();
            while (valuesItr.hasNext()) {
                valuesItr.advance();
                int key = valuesItr.key();
                this.mAllBinDataProvider.addData(CounterDisplay.AVERAGE, key, valuesItr.value() * 10000L / 100000000L);
            }
            this.mAllBinDataProvider.incrementBin();
            this.mThreshold += 100000000L;
        }
        if (commitOccurred) {
            this.mAllBinDataProvider.commitOccurred();
        }
    }

    private void dynamicActivityCounter(CounterRecord counter) {
        RGB color = null;
        int key = counter.getKey();
        int numBins = this.mAllBinDataProvider.getBinCount();
        int index = 1;
        List activityStrings = counter.getActivity();
        for (String name : activityStrings) {
            TIntArrayList colors = counter.getActivityColor();
            if (index - 1 < colors.size()) {
                color = RGBUtils.create(colors.get(index - 1));
            } else {
                color = this.mColorPalette.nextColor();
                this.mColorPalette.nextPalette();
            }
            CounterRecord activityRecord = new CounterRecord(counter);
            activityRecord.setName(name);
            CounterRecordUtils.setColor(activityRecord, color);
            activityRecord.setMultiplier(1.0E-4);
            activityRecord.setCores(counter.isPerCPU() ? counter.getCores() : 1);
            activityRecord.setDeviceType(this.mDTCalc.calcDeviceType(counter));
            int newKey = 0x30000000 + this.mActivityKeys.size() * 100 + index++;
            activityRecord.setKey(newKey);
            this.mAllBinDataProvider.addCounterSource(activityRecord);
            this.mAllBinDataProvider.initializeData(newKey, numBins);
        }
        this.mActivityKeys.add(key);
        this.mActivityCores.add(counter.getCores());
        this.mNumActivities.add(activityStrings.size());
        this.mActivity.initialize(counter.getCores(), key);
    }

    private void dynamicCounter(CounterRecord counter) {
        int key = counter.getKey();
        if (this.mAllBinDataProvider.getProvider(key) != null) {
            return;
        }
        RGB color = CounterRecordUtils.getColorRGB(counter);
        if (color == null) {
            color = this.mColorPalette.nextColor();
            this.mColorPalette.nextPalette();
        }
        int numBins = this.mAllBinDataProvider.getBinCount();
        CounterRecord dynamicCounter = new CounterRecord(counter);
        CounterRecordUtils.setColor(dynamicCounter, color);
        dynamicCounter.setCores(counter.isPerCPU() ? counter.getCores() : 1);
        dynamicCounter.setDeviceType(this.mDTCalc.calcDeviceType(counter));
        this.mAllBinDataProvider.addCounterSource(dynamicCounter);
        int core = 0;
        while (core < this.mNumCores) {
            this.mCounters.initialize(core, key, this.mThreshold, counter.getCounterClass(), counter.isPerCPU());
            ++core;
        }
        this.mKeys.add(key);
        this.mAllBinDataProvider.initializeData(key, numBins);
    }

    private int[] getCores(CounterRecord record) {
        Integer cluster = this.mClustersInfo.getClusterIndex(record);
        if (cluster == null) {
            int[] cores = new int[this.mNumCores];
            int core = 0;
            while (core < this.mNumCores) {
                cores[core] = core;
                ++core;
            }
            return cores;
        }
        return ((TIntList)NullChecking.neverNull((Object)this.mClustersInfo.getCores(cluster.intValue()))).toArray();
    }

    @Override
    public @NonNull IUniqueThreadTracker createUniqueThreadTracker(long vmUID, boolean appTracingMode) {
        assert (vmUID == 0L);
        return this.mProcessDataProvider.getUniqueThreadTracker();
    }
}

