/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.live;

import com.arm.streamline.analysis.live.CPUActivity;
import com.arm.streamline.analysis.model.threads.IUniqueThread;
import com.arm.streamline.application.StreamlinePlugin;
import gnu.trove.iterator.TIntObjectIterator;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntLongHashMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;

public class LiveCPUWaitCounters {
    private final @NonNull TIntObjectMap<PerCounterData> mCountersByKey = new TIntObjectHashMap();
    private final @NonNull IUniqueThread @NonNull [] mCurrentActiveThread;
    private final @NonNull List<@NonNull CPUActivity> mActivity = new ArrayList<CPUActivity>();
    private int mContentionKey;
    private int mIOKey;
    private final int mNumCores;
    private final @NonNull IUniqueThread mIdleThread;

    LiveCPUWaitCounters(int numCores, @NonNull IUniqueThread idleThread) {
        this.mNumCores = numCores;
        this.mCurrentActiveThread = new IUniqueThread[this.mNumCores];
        this.mIdleThread = idleThread;
        Arrays.fill(this.mCurrentActiveThread, idleThread);
    }

    public void add(int core, long time, @NonNull IUniqueThread uniqueThread, int state) {
        this.mActivity.add(new CPUActivity(core, time, uniqueThread, state, false));
    }

    public TIntLongHashMap commit(long threshold) {
        TIntLongHashMap returnValue = new TIntLongHashMap();
        Collections.sort(this.mActivity);
        while (!this.mActivity.isEmpty() && this.mActivity.get((int)0).timestamp < threshold) {
            this.handleActivity(this.mActivity.get(0));
            this.mActivity.remove(0);
        }
        long contention = this.commitActivity(this.mContentionKey, threshold);
        long io = this.commitActivity(this.mIOKey, threshold);
        returnValue.adjustOrPutValue(this.mContentionKey, 0L, contention);
        returnValue.adjustOrPutValue(this.mIOKey, 0L, io);
        return returnValue;
    }

    public void free(long timestamp, @NonNull IUniqueThread uniqueThread) {
        int i = 0;
        while (i < this.mNumCores) {
            this.mActivity.add(new CPUActivity(i, timestamp, uniqueThread, 0, true));
            ++i;
        }
    }

    public void initialize(String name, int key) {
        if ("Linux_cpu_wait_contention".contentEquals(name)) {
            this.mContentionKey = key;
        } else if ("Linux_cpu_wait_io".contentEquals(name)) {
            this.mIOKey = key;
        } else {
            StreamlinePlugin.warning("Derived counter name mismatch.");
            return;
        }
        PerCounterData counter = (PerCounterData)this.mCountersByKey.get(key);
        if (counter == null) {
            counter = new PerCounterData();
            this.mCountersByKey.put(key, (Object)counter);
        }
    }

    private long commitActivity(int key, long threshold) {
        boolean stillWaiting;
        if (key == 0) {
            return 0L;
        }
        PerCounterData data = (PerCounterData)this.mCountersByKey.get(key);
        boolean bl = stillWaiting = !data.mWaiting.isEmpty();
        if (stillWaiting) {
            data.mTimeWaiting += threshold - data.mLastTime;
            data.mLastTime = threshold;
        }
        if (data.mTimeWaiting > 100000000L) {
            StreamlinePlugin.warning("Incorrect calculation of CPU wait time.");
            data.mTimeWaiting = 100000000L;
        }
        long returnValue = data.mTimeWaiting;
        data.mTimeWaiting = 0L;
        return returnValue;
    }

    private void handleActivity(@NonNull CPUActivity activity) {
        int key = 0;
        if (this.mContentionKey > 0 && activity.state == 1) {
            key = this.mContentionKey;
        } else if (this.mIOKey > 0 && activity.state == 2) {
            key = this.mIOKey;
        }
        if (key != 0 && !this.mCurrentActiveThread[activity.core].isIdle()) {
            PerCounterData data = (PerCounterData)this.mCountersByKey.get(key);
            if (data.mWaiting.isEmpty()) {
                data.mLastTime = activity.timestamp;
            }
            data.mWaiting.add(this.mCurrentActiveThread[activity.core]);
        }
        if (activity.free) {
            if (activity.uniqueThread.equals(this.mCurrentActiveThread[activity.core])) {
                this.mCurrentActiveThread[activity.core] = this.mIdleThread;
            }
        } else {
            this.mCurrentActiveThread[activity.core] = activity.uniqueThread;
        }
        this.noLongerWaiting(activity.uniqueThread, activity.timestamp);
    }

    private void noLongerWaiting(@NonNull IUniqueThread uniqueThread, long time) {
        TIntObjectIterator itr = this.mCountersByKey.iterator();
        while (itr.hasNext()) {
            itr.advance();
            PerCounterData data = (PerCounterData)itr.value();
            if (!data.mWaiting.remove(uniqueThread) || !data.mWaiting.isEmpty()) continue;
            assert (data.mLastTime != -1L);
            data.mTimeWaiting += time - data.mLastTime;
            data.mLastTime = -1L;
        }
    }

    private static class PerCounterData {
        public long mLastTime = -1L;
        public long mTimeWaiting;
        public final @NonNull Set<@NonNull IUniqueThread> mWaiting = new HashSet<IUniqueThread>();
    }
}

