/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.live;

import com.arm.streamline.analysis.live.CPUActivity;
import com.arm.streamline.analysis.model.threads.IUniqueThread;
import gnu.trove.map.hash.TLongObjectHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;

public class LiveCPUActivity {
    private static final int IDLE = 0;
    private static final int SYSTEM = 1;
    private static final int USER = 2;
    private TLongObjectHashMap<ActivityState> mState = new TLongObjectHashMap();
    private List<@NonNull CPUActivity> mActivity = new ArrayList<CPUActivity>();
    private int mNumCores;

    LiveCPUActivity(int numCores) {
        this.mNumCores = numCores;
    }

    public void add(int core, long time, @NonNull IUniqueThread uniqueThread) {
        this.mActivity.add(new CPUActivity(core, time, uniqueThread, 0, false));
    }

    public List<UserAndSystem> commit(long threshold) {
        ArrayList<UserAndSystem> returnValue = new ArrayList<UserAndSystem>();
        Collections.sort(this.mActivity);
        while (!this.mActivity.isEmpty() && this.mActivity.get((int)0).timestamp < threshold) {
            this.handleActivity(this.mActivity.get(0));
            this.mActivity.remove(0);
        }
        int core = 0;
        while (core < this.mNumCores) {
            UserAndSystem state = this.commitActivity(core, threshold);
            returnValue.add(state);
            ++core;
        }
        return returnValue;
    }

    public void setStartTime(long time) {
        int i = 0;
        while (i < this.mNumCores) {
            ActivityState initState = new ActivityState();
            this.mState.put((long)i, (Object)initState);
            initState.mPreviousType = 0;
            initState.mPreviousTime = time;
            ++i;
        }
    }

    private UserAndSystem commitActivity(int core, long threshold) {
        ActivityState state = (ActivityState)this.mState.get((long)core);
        long total = state.mIdle + state.mUser + state.mSystem;
        long missing = 100000000L - total;
        if (missing < 0L) {
            state.mIdle = state.mIdle * 100000000L / total;
            state.mSystem = state.mSystem * 100000000L / total;
            state.mUser = 100000000L - state.mIdle - state.mSystem;
        } else if (missing != 0L) {
            switch (state.mPreviousType) {
                case 0: {
                    state.mIdle += missing;
                    break;
                }
                case 1: {
                    state.mSystem += missing;
                    break;
                }
                case 2: {
                    state.mUser += missing;
                    break;
                }
            }
        }
        UserAndSystem us = new UserAndSystem(state.mUser, state.mSystem);
        state.mPreviousTime = threshold;
        state.mIdle = 0L;
        state.mSystem = 0L;
        state.mUser = 0L;
        return us;
    }

    private void handleActivity(@NonNull CPUActivity activity) {
        ActivityState state = (ActivityState)this.mState.get((long)activity.core);
        long delta = activity.timestamp - state.mPreviousTime;
        switch (state.mPreviousType) {
            case 0: {
                state.mIdle += delta;
                break;
            }
            case 1: {
                state.mSystem += delta;
                break;
            }
            case 2: {
                state.mUser += delta;
                break;
            }
        }
        state.mPreviousTime = activity.timestamp;
        state.mPreviousType = activity.uniqueThread.isIdle() ? 0 : (activity.uniqueThread.isKernel() ? 1 : 2);
    }

    private static class ActivityState {
        protected long mIdle;
        protected long mSystem;
        protected long mUser;
        protected int mPreviousType;
        protected long mPreviousTime;

        protected ActivityState() {
        }
    }

    protected static class UserAndSystem {
        public long user;
        public long system;

        protected UserAndSystem(long u, long s) {
            this.user = u;
            this.system = s;
        }
    }
}

