/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.gator;

import com.arm.streamline.analysis.gator.GatorProtocolVersionConstants;
import org.eclipse.jdt.annotation.NonNull;

public class GatorProtocolVersion
implements Comparable<GatorProtocolVersion> {
    private static final int DEV_VERSION_NUMBER_BASE = 100000;
    private static final int DEV_VERSION_TAG_MAX = 21474;
    private static final int EARLIEST_DEVTAG_RELEASE_VERSION = 750;
    private static final int MAX_SUPPORTED_SPLIT_PROTOCOL_VERSION = 950;
    private static final int MIN_SUPPORTED_SPLIT_PROTOCOL_VERSION = 950;
    public final int devTag;
    public final int major;
    public final int minor;
    public final int rawVersion;
    public final int revision;
    public final @NonNull Type type;

    public static @NonNull GatorProtocolVersion getMaxSupportedSplitProtocolVersion() {
        return new GatorProtocolVersion(950);
    }

    public static @NonNull GatorProtocolVersion getMinSupportedLiveProductVersion() {
        return GatorProtocolVersionConstants.CURRENT_RELEASED_VERSION;
    }

    public static @NonNull GatorProtocolVersion getMinSupportedReleasedProductVersion() {
        return GatorProtocolVersionConstants.MIN_SUPPORTED_RELEASED_VERSION;
    }

    public static @NonNull GatorProtocolVersion getMinSupportedSplitProtocolVersion() {
        return new GatorProtocolVersion(950);
    }

    public static boolean isStreamline690OrLater(int versionNumber) {
        return versionNumber >= 690 && versionNumber < 100000 || versionNumber >= 20190401 || versionNumber < 0 && Math.abs(versionNumber % 100000) > 750;
    }

    private static boolean sameVersionNos(@NonNull GatorProtocolVersion a, @NonNull GatorProtocolVersion b) {
        return a.major == b.major && a.minor == b.minor && a.revision == b.revision;
    }

    public GatorProtocolVersion(int rawVersion) {
        this.rawVersion = rawVersion;
        if (rawVersion >= 0 && rawVersion <= 23) {
            this.type = Type.LEGACY_DS5;
            this.major = 5;
            this.minor = rawVersion;
            this.revision = 0;
            this.devTag = 0;
        } else if (rawVersion >= 230 && rawVersion <= 250) {
            this.type = Type.LEGACY_DS5;
            this.major = 5;
            this.minor = rawVersion / 10;
            this.revision = rawVersion % 10;
            this.devTag = 0;
        } else if (rawVersion == 260) {
            this.type = Type.LEGACY_DS5;
            this.major = 5;
            this.minor = 25;
            this.revision = 2;
            this.devTag = 0;
        } else if (rawVersion >= 600 && rawVersion < 100000) {
            this.type = Type.RELEASE;
            this.major = rawVersion / 100;
            this.minor = rawVersion / 10 % 10;
            this.revision = rawVersion % 10;
            this.devTag = 0;
        } else if (rawVersion >= 100000) {
            this.type = Type.LEGACY_DEVTAG;
            this.major = 0;
            this.minor = 0;
            this.revision = 0;
            this.devTag = rawVersion;
        } else if (rawVersion < 0) {
            int productVersion = Math.abs(rawVersion % 100000);
            if (productVersion >= 750) {
                this.type = Type.DEVTAG;
                this.major = productVersion / 100;
                this.minor = productVersion / 10 % 10;
                this.revision = productVersion % 10;
                this.devTag = Math.abs(rawVersion / 100000);
            } else {
                this.type = Type.INVALID;
                this.major = 0;
                this.minor = 0;
                this.revision = 0;
                this.devTag = 0;
            }
        } else {
            this.type = Type.INVALID;
            this.major = 0;
            this.minor = 0;
            this.revision = 0;
            this.devTag = 0;
        }
    }

    public int compareMajorMinor(GatorProtocolVersion o) {
        if (o == null) {
            throw new NullPointerException("o is null");
        }
        int result = Integer.compare(this.major, o.major);
        result = result != 0 ? result : Integer.compare(this.minor, o.minor);
        return result;
    }

    @Override
    public int compareTo(GatorProtocolVersion o) {
        if (o == null) {
            throw new NullPointerException("o is null");
        }
        int result = Integer.compare(this.major, o.major);
        result = result != 0 ? result : Integer.compare(this.minor, o.minor);
        result = result != 0 ? result : Integer.compare(this.revision, o.revision);
        result = result != 0 ? result : Integer.compare(this.devTag, o.devTag);
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof GatorProtocolVersion) {
            GatorProtocolVersion that = (GatorProtocolVersion)obj;
            return this.rawVersion == that.rawVersion;
        }
        return false;
    }

    public int getDevVersionNumber(int devTag) {
        if (devTag < 0 || devTag > 21474) {
            throw new IllegalArgumentException();
        }
        switch (this.type) {
            case DEVTAG: 
            case RELEASE: {
                return -(this.major * 100 + this.minor * 10 + this.revision + 100000 * devTag);
            }
        }
        throw new AssertionError((Object)this.type);
    }

    public @NonNull String getProductVersionString() throws IllegalArgumentException {
        switch (this.type) {
            case LEGACY_DS5: {
                return String.format("DS5 %s", this.getVersionString());
            }
            case DEVTAG: 
            case LEGACY_DEVTAG: 
            case RELEASE: {
                return String.format("Streamline %s", this.getVersionString());
            }
            case INVALID: {
                assert (!this.isValidEncoding());
                throw new IllegalArgumentException(String.format("Unrecognized protocol version %s", this.rawVersion));
            }
        }
        throw new AssertionError((Object)this.type);
    }

    public int getVersionNumber() {
        return this.rawVersion;
    }

    public @NonNull String getVersionString() throws IllegalArgumentException {
        switch (this.type) {
            case DEVTAG: {
                if (this.revision == 0) {
                    return String.format("v%s.%s-dev-%s", this.major, this.minor, this.devTag);
                }
                return String.format("v%s.%s.%s-dev-%s", this.major, this.minor, this.revision, this.devTag);
            }
            case LEGACY_DEVTAG: {
                return String.format("v%s-dev", this.devTag);
            }
            case LEGACY_DS5: 
            case RELEASE: {
                if (this.revision == 0) {
                    return String.format("v%s.%s", this.major, this.minor);
                }
                return String.format("v%s.%s.%s", this.major, this.minor, this.revision);
            }
            case INVALID: {
                assert (!this.isValidEncoding());
                throw new IllegalArgumentException(String.format("Unrecognized protocol version %s", this.rawVersion));
            }
        }
        throw new AssertionError((Object)this.type);
    }

    public int hashCode() {
        return Integer.hashCode(this.rawVersion);
    }

    public boolean isCompatibleProductVersion() {
        if (!this.isValidEncoding()) {
            return false;
        }
        @NonNull GatorProtocolVersion minimumVersion = GatorProtocolVersion.getMinSupportedReleasedProductVersion();
        switch (this.type) {
            case RELEASE: {
                if (this.compareTo(minimumVersion) < 0) {
                    return false;
                }
                return this.compareMajorMinor(GatorProtocolVersionConstants.CURRENT_RELEASED_VERSION) <= 0;
            }
            case DEVTAG: {
                return this.compatibleDevTagVersionNumbers();
            }
            case INVALID: 
            case LEGACY_DEVTAG: 
            case LEGACY_DS5: {
                return false;
            }
        }
        throw new AssertionError((Object)this.type);
    }

    public boolean isCompatibleProtocolVersion() {
        if (!this.isValidEncoding()) {
            return false;
        }
        if (!this.isProtocolAndProductVersionDistinct()) {
            return this.isCompatibleProductVersion();
        }
        @NonNull GatorProtocolVersion minimumVersion = GatorProtocolVersion.getMinSupportedSplitProtocolVersion();
        @NonNull GatorProtocolVersion maximumVersion = GatorProtocolVersion.getMaxSupportedSplitProtocolVersion();
        switch (this.type) {
            case RELEASE: {
                if (this.compareTo(minimumVersion) < 0) {
                    return false;
                }
                return this.compareMajorMinor(maximumVersion) <= 0;
            }
            case DEVTAG: {
                return this.major == GatorProtocolVersionConstants.NEXT_DEVELOPMENT_VERSION.major && this.minor == GatorProtocolVersionConstants.NEXT_DEVELOPMENT_VERSION.minor && this.revision == GatorProtocolVersionConstants.NEXT_DEVELOPMENT_VERSION.revision;
            }
            case INVALID: 
            case LEGACY_DEVTAG: 
            case LEGACY_DS5: {
                assert (false);
                return false;
            }
        }
        throw new AssertionError((Object)this.type);
    }

    public boolean isCurrentDevBuild() {
        return this.type == Type.DEVTAG && this.compatibleDevTagVersionNumbers();
    }

    public boolean isCurrentProductVersion() {
        return this.equals(GatorProtocolVersionConstants.CURRENT_RELEASED_VERSION);
    }

    public boolean isCurrentProtocolVersion() {
        return this.compareMajorMinor(GatorProtocolVersion.getMaxSupportedSplitProtocolVersion()) == 0;
    }

    public boolean isDevBuild() {
        switch (this.type) {
            case DEVTAG: 
            case LEGACY_DEVTAG: {
                return true;
            }
            case INVALID: 
            case LEGACY_DS5: 
            case RELEASE: {
                return false;
            }
        }
        throw new AssertionError((Object)this.type);
    }

    public boolean isPatchRelease() {
        return this.revision != 0;
    }

    public boolean isProtocolAndProductVersionDistinct() {
        return this.major > 9 || this.major == 9 && this.minor >= 5;
    }

    public boolean isValidEncoding() {
        switch (this.type) {
            case DEVTAG: 
            case LEGACY_DEVTAG: 
            case LEGACY_DS5: 
            case RELEASE: {
                return true;
            }
            case INVALID: {
                return false;
            }
        }
        throw new AssertionError((Object)this.type);
    }

    public @NonNull GatorProtocolVersion nextMinorVersion() {
        switch (this.type) {
            case RELEASE: {
                return new GatorProtocolVersion(this.minor < 9 ? (this.major * 10 + (this.minor + 1)) * 10 : (this.major + 1) * 100);
            }
        }
        throw new AssertionError((Object)this.type);
    }

    public boolean supportsExitOk() {
        switch (this.type) {
            case DEVTAG: 
            case RELEASE: {
                return this.major > 7 || this.major == 7 && this.minor >= 5;
            }
            case INVALID: 
            case LEGACY_DEVTAG: 
            case LEGACY_DS5: {
                return false;
            }
        }
        throw new AssertionError((Object)this.type);
    }

    public String toString() {
        return String.valueOf(this.rawVersion);
    }

    private boolean compatibleDevTagVersionNumbers() {
        return GatorProtocolVersion.sameVersionNos(this, GatorProtocolVersionConstants.CURRENT_RELEASED_VERSION) || GatorProtocolVersion.sameVersionNos(this, GatorProtocolVersionConstants.NEXT_DEVELOPMENT_VERSION);
    }

    public static enum Type {
        DEVTAG,
        INVALID,
        LEGACY_DEVTAG,
        LEGACY_DS5,
        RELEASE;

    }
}

