/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis;

import com.arm.streamline.analysis.AnalysisMessages;
import com.arm.streamline.analysis.IInterruptible;
import com.arm.streamline.common.analysis.IAnalysisHandler;
import com.arm.streamline.common.utility.Task;
import com.arm.streamline.jni.common.WarningItem;
import java.io.File;
import java.nio.channels.ClosedByInterruptException;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.NonNull;

public abstract class AnalysisBase
implements Runnable,
IInterruptible {
    private Task mTask;
    private boolean mIsInterrupted;
    private String mName;
    private int mProgress = -1;
    private @NonNull IAnalysisHandler mHandler;

    public static void checkInterrupted() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
    }

    public AnalysisBase(@NonNull IAnalysisHandler handler) {
        this.mHandler = handler;
    }

    public void close() {
    }

    public @NonNull IAnalysisHandler getHandler() {
        return this.mHandler;
    }

    @Override
    public void interrupt() {
        Task task = this.mTask;
        this.mIsInterrupted = true;
        if (task != null) {
            task.cancel();
        }
    }

    public void join() {
        Task task = this.mTask;
        if (task != null) {
            task.join();
            this.mTask = null;
        }
    }

    @Override
    public final void run() {
        try {
            this.process();
        }
        catch (OutOfMemoryError exception) {
            this.mHandler.error((Throwable)new Exception(AnalysisMessages.OUT_OF_MEMORY_MESSAGE));
            exception.printStackTrace();
        }
        catch (Throwable exception) {
            this.mHandler.error(exception);
            exception.printStackTrace();
        }
    }

    public void start() {
        this.mTask = Task.scheduleOnAnotherThread((Runnable)this, (String)this.mName, (long)0L, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    protected void cancel() {
        this.mHandler.cancel();
    }

    protected void error(Exception exception) {
        if (!(exception instanceof ClosedByInterruptException) && !(exception instanceof InterruptedException)) {
            this.mHandler.error((Throwable)exception);
        }
    }

    protected boolean isInterrupted() {
        if (Thread.interrupted()) {
            this.mIsInterrupted = true;
        }
        return this.mIsInterrupted;
    }

    protected abstract void process();

    protected void progress(int progress) {
        if (progress > 100) {
            progress = 100;
        }
        if (progress > this.mProgress) {
            this.mProgress = progress;
            this.mHandler.progress((Object)this, progress);
        }
    }

    protected void setName(String name, String input) {
        this.setName(name, input, null);
    }

    protected void setName(String name, String input, String output) {
        if (input != null && !input.isEmpty()) {
            name = String.format("%s '%s'", name, new File(input).getName());
        }
        if (output != null && !output.isEmpty()) {
            name = String.format("%s '%s'", name, new File(output).getName());
        }
        this.mName = name;
    }

    protected void setPriorityHigher() {
    }

    protected void setPriorityHighest() {
    }

    protected void setPriorityLower() {
    }

    protected void setPriorityLowest() {
    }

    protected void setPriorityNormal() {
    }

    protected void throwInterrupted() throws InterruptedException {
        if (this.isInterrupted()) {
            throw new InterruptedException();
        }
    }

    protected void warning(@NonNull WarningItem item) {
        this.mHandler.warning(item);
    }

    public String toString() {
        return "AnalysisBase [mFuture=" + String.valueOf(this.mTask) + ", mIsInterrupted=" + this.mIsInterrupted + ", mName=" + this.mName + ", mProgress=" + this.mProgress + ", mHandler=" + String.valueOf(this.mHandler) + "]";
    }
}

