/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.misc.event_queue;

import com.arm.streamline.protocol.capture.apc.time.ITimestampMapper;
import com.arm.streamline.protocol.misc.event_queue.IEventQueueItem;
import com.arm.streamline.protocol.misc.event_queue.IEventQueueSink;
import com.arm.streamline.protocol.misc.event_queue.IFlushableEventQueue;
import com.arm.utils.numbers.UnsignedLong;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public abstract class AbstractEventQueue<T extends IEventQueueItem<? extends T>>
implements IFlushableEventQueue,
IEventQueueSink<T> {
    private final @NonNull List<@NonNull T> eventQueue = new ArrayList<T>();
    private boolean eventQueueNeedsSorting = false;
    private final int flushSize;
    private @Nullable T lastConsumedItem = null;
    private long lastFlushedTimestamp = -1L;

    private static <T extends IEventQueueItem<? extends T>> int compareEvents(@NonNull T a, @NonNull T b) {
        int tsResult = ITimestampMapper.compareTimestamps(a.getTimestamp(), b.getTimestamp());
        if (tsResult != 0) {
            return tsResult;
        }
        return UnsignedLong.compare((long)a.getOrdinal(), (long)b.getOrdinal());
    }

    protected AbstractEventQueue(int flushSize) {
        this.flushSize = flushSize;
    }

    @Override
    public long clampTimestamp(long timestamp) {
        return timestamp;
    }

    @Override
    public boolean enqueue(T event) throws IOException {
        @Nullable T lastConsumedItem = this.lastConsumedItem;
        if (lastConsumedItem != null && AbstractEventQueue.compareEvents(lastConsumedItem, event) > 0 && !this.handleOutOfOrderEvent(event)) {
            return false;
        }
        int eventQueueSize = this.eventQueue.size();
        IEventQueueItem lastEventInQueue = eventQueueSize > 0 ? (IEventQueueItem)this.eventQueue.get(eventQueueSize - 1) : null;
        this.eventQueue.add(event);
        if (lastEventInQueue != null && AbstractEventQueue.compareEvents(lastEventInQueue, event) > 0) {
            this.eventQueueNeedsSorting = true;
        }
        return true;
    }

    @Override
    public void flushAll() throws IOException {
        this.flush(event -> true);
        @Nullable T lastConsumedItem = this.lastConsumedItem;
        if (lastConsumedItem != null && ITimestampMapper.compareTimestamps(lastConsumedItem.getTimestamp(), this.lastFlushedTimestamp) > 0) {
            this.lastFlushedTimestamp = lastConsumedItem.getTimestamp();
        }
    }

    @Override
    public long flushUpTo(long timestamp) throws IOException {
        if (!(timestamp <= this.lastFlushedTimestamp || this.eventQueue.size() <= this.flushSize && this.eventQueueNeedsSorting)) {
            this.lastFlushedTimestamp = timestamp;
            this.flush(event -> ITimestampMapper.compareTimestamps(event.getTimestamp(), timestamp) <= 0);
        }
        return this.lastFlushedTimestamp;
    }

    public boolean isQueueInOrder() {
        return !this.eventQueueNeedsSorting;
    }

    public int size() {
        return this.eventQueue.size();
    }

    protected abstract void consume(@NonNull T var1) throws IOException;

    protected boolean handleOutOfOrderEvent(@NonNull T event) {
        assert (false) : "Out of order event received";
        return true;
    }

    private void flush(@NonNull Predicate<@NonNull T> predicate) throws IOException {
        this.sort();
        int eventQueueSize = this.eventQueue.size();
        int pos = 0;
        while (pos < eventQueueSize) {
            @NonNull IEventQueueItem event = (IEventQueueItem)this.eventQueue.get(pos);
            if (!predicate.test(event)) break;
            this.consume(event);
            @Nullable T lastConsumedItem = this.lastConsumedItem;
            if (lastConsumedItem == null || AbstractEventQueue.compareEvents(lastConsumedItem, event) <= 0) {
                this.lastConsumedItem = event;
            }
            ++pos;
        }
        this.eventQueue.subList(0, pos).clear();
    }

    private void sort() {
        if (this.eventQueueNeedsSorting) {
            this.eventQueueNeedsSorting = false;
            this.eventQueue.sort(AbstractEventQueue::compareEvents);
        }
    }
}

