/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.misc;

import com.arm.streamline.protocol.misc.ApkEntry;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ApkEntries {
    private final @NonNull Map<@NonNull String, @NonNull ApkEntry> entries;

    public ApkEntries(@NonNull Map<@NonNull String, @NonNull ApkEntry> entries) {
        this.entries = entries;
    }

    public @Nullable ApkEntry findEntryByOffset(long fileOffset, long length) {
        List result = this.entries.values().stream().filter(apkEntry -> {
            boolean isSizeMatched;
            boolean isOffsetMatched = apkEntry.baseOffset <= fileOffset;
            boolean bl = isSizeMatched = apkEntry.baseOffset + apkEntry.length >= fileOffset + length;
            return isOffsetMatched && isSizeMatched;
        }).collect(Collectors.toList());
        assert (result.size() <= 1) : "cannot have more than one offset matching for zip entry";
        return result.size() == 1 ? (ApkEntry)result.get(0) : null;
    }

    public boolean hasEntries() {
        return !this.entries.isEmpty();
    }
}

