/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.gator.v22.perf;

import com.arm.streamline.protocol.gator.io.IAPCByteReader;
import com.arm.streamline.protocol.gator.io.IAPCByteWriter;
import com.arm.streamline.protocol.gator.messages.ByteBlobProperty;
import com.arm.streamline.protocol.gator.messages.IIntProperty;
import com.arm.streamline.protocol.gator.messages.ILongProperty;
import com.arm.streamline.protocol.gator.messages.IMessage;
import com.arm.streamline.protocol.gator.messages.IMessageCodec;
import com.arm.streamline.protocol.gator.messages.PackedIntProperty;
import com.arm.streamline.protocol.gator.messages.PackedLongProperty;
import com.arm.streamline.protocol.gator.v22.perf.IMessageCodecContextPerfV22;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;

public final class PerfAuxFrame
implements IMessage<Codec> {
    public static final @NonNull IIntProperty PROPERTY_CPU = new PackedIntProperty("cpu");
    public static final @NonNull ByteBlobProperty PROPERTY_DATA = new ByteBlobProperty("data");
    public static final @NonNull ILongProperty PROPERTY_OFFSET = new PackedLongProperty("offset");
    public final int cpu;
    public final byte @NonNull [] data;
    public final long offset;

    public PerfAuxFrame(int cpu, long offset, byte @NonNull [] data) {
        this.cpu = cpu;
        this.offset = offset;
        this.data = data;
    }

    @Override
    public @NonNull Codec getCodec() {
        return Codec.INSTANCE;
    }

    public @NonNull String toString() {
        return String.format("PerfAuxFrame(%d)", this.cpu);
    }

    public static final class Codec
    extends Enum<Codec>
    implements IMessageCodec<PerfAuxFrame, IPerfAuxFrameConsumer, IMessageCodecContextPerfV22> {
        public static final /* enum */ Codec INSTANCE = new Codec();
        private static final /* synthetic */ Codec[] ENUM$VALUES;

        static {
            ENUM$VALUES = new Codec[]{INSTANCE};
        }

        @Override
        public void decode(int token, @NonNull IMessageCodecContextPerfV22 context, @NonNull IAPCByteReader stream, @NonNull IPerfAuxFrameConsumer consumer) throws IOException {
            assert (token == this.token());
            int cpu = PROPERTY_CPU.read(stream);
            long offset = PROPERTY_OFFSET.read(stream);
            byte @NonNull [] data = PROPERTY_DATA.read(stream);
            consumer.consumePerfAuxFrame(new PerfAuxFrame(cpu, offset, data));
        }

        @Override
        public int encode(@NonNull PerfAuxFrame message, @NonNull IMessageCodecContextPerfV22 context, @NonNull IAPCByteWriter stream) throws IOException {
            PROPERTY_CPU.write(stream, message.cpu);
            PROPERTY_OFFSET.write(stream, message.offset);
            PROPERTY_DATA.write(stream, message.data);
            return this.token();
        }

        @Override
        public int token() {
            return 14;
        }

        public static Codec[] values() {
            Codec[] codecArray = ENUM$VALUES;
            int n = codecArray.length;
            Codec[] codecArray2 = new Codec[n];
            System.arraycopy(ENUM$VALUES, 0, codecArray2, 0, n);
            return codecArray2;
        }

        public static Codec valueOf(String string) {
            return Enum.valueOf(Codec.class, string);
        }
    }

    public static interface IPerfAuxFrameConsumer {
        public void consumePerfAuxFrame(@NonNull PerfAuxFrame var1) throws IOException;
    }
}

