/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.gator.v22;

import com.arm.streamline.protocol.gator.io.IAPCByteReader;
import com.arm.streamline.protocol.gator.io.IAPCByteWriter;
import com.arm.streamline.protocol.gator.messages.IIntProperty;
import com.arm.streamline.protocol.gator.messages.ILongProperty;
import com.arm.streamline.protocol.gator.messages.IMessage;
import com.arm.streamline.protocol.gator.messages.IMessageCodec;
import com.arm.streamline.protocol.gator.messages.IMessageRecord;
import com.arm.streamline.protocol.gator.messages.IMessageRecordCodec;
import com.arm.streamline.protocol.gator.messages.IRecordListProperty;
import com.arm.streamline.protocol.gator.messages.PackedIntProperty;
import com.arm.streamline.protocol.gator.messages.PackedLongProperty;
import com.arm.streamline.protocol.gator.messages.SingleRecordListProperty;
import com.arm.streamline.protocol.gator.v22.AbstractFrameWithCore;
import com.arm.streamline.protocol.gator.v22.IMessageCodecContextV22;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;

public final class BlockCounterFrame
extends AbstractFrameWithCore
implements IMessage<Codec> {
    public static final int MAGIC_KEY_CPU = 2;
    public static final int MAGIC_KEY_TID = 1;
    public static final int MAGIC_KEY_TIMESTAMP = 0;
    public static final int MAGIC_KEY_TIMESTAMP_FIXTIME = -1;
    public static final int SYSTEM_WIDE_TID = -1;
    public final @NonNull List<@NonNull BlockCounterRecord> records;

    public BlockCounterFrame(int cpu, @NonNull List<@NonNull BlockCounterRecord> records) {
        super(cpu);
        this.records = Collections.unmodifiableList(records);
    }

    @Override
    public @NonNull Codec getCodec() {
        return Codec.INSTANCE;
    }

    @Override
    public @NonNull String toString() {
        return String.format("BlockCounterMessage(%d, %d)", this.cpu, this.records.size());
    }

    public static final class BlockCounterRecord
    implements IMessageRecord<BlockCounterRecord, IMessageCodecContextV22> {
        public final int key;
        public final long value;

        public BlockCounterRecord(int key, long value) {
            this.key = key;
            this.value = value;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof BlockCounterRecord) {
                BlockCounterRecord that = (BlockCounterRecord)obj;
                return this.key == that.key && this.value == that.value;
            }
            return false;
        }

        @Override
        public @NonNull IMessageRecordCodec<BlockCounterRecord, @NonNull IMessageCodecContextV22> getCodec() {
            return Codec.INSTANCE;
        }

        public int hashCode() {
            return this.key * 31 + Long.hashCode(this.value);
        }

        public String toString() {
            return String.format("{%d, %d}", this.key, this.value);
        }

        public static enum Codec implements IMessageRecordCodec<BlockCounterRecord, IMessageCodecContextV22>
        {
            INSTANCE;

            public static final @NonNull IIntProperty PROPERTY_KEY;
            public static final @NonNull ILongProperty PROPERTY_VALUE;

            static {
                PROPERTY_KEY = new PackedIntProperty("key");
                PROPERTY_VALUE = new PackedLongProperty("value");
            }

            @Override
            public @NonNull BlockCounterRecord decode(@NonNull IMessageCodecContextV22 context, @NonNull IAPCByteReader stream) throws IOException {
                int key = PROPERTY_KEY.read(stream);
                long value = PROPERTY_VALUE.read(stream);
                return new BlockCounterRecord(key, value);
            }

            @Override
            public void encode(@NonNull BlockCounterRecord message, @NonNull IMessageCodecContextV22 context, @NonNull IAPCByteWriter stream) throws IOException {
                PROPERTY_KEY.write(stream, message.key);
                PROPERTY_VALUE.write(stream, message.value);
            }
        }
    }

    public static final class Codec
    extends Enum<Codec>
    implements IMessageCodec<BlockCounterFrame, IBlockCounterFrameConsumer, IMessageCodecContextV22> {
        public static final /* enum */ Codec INSTANCE = new Codec();
        public static final @NonNull IRecordListProperty<BlockCounterRecord, @NonNull IMessageCodecContextV22> PROPERTY_RECORDS;
        private static final /* synthetic */ Codec[] ENUM$VALUES;

        static {
            ENUM$VALUES = new Codec[]{INSTANCE};
            PROPERTY_RECORDS = new SingleRecordListProperty<BlockCounterRecord, IMessageCodecContextV22>("records", BlockCounterRecord.Codec.INSTANCE);
        }

        @Override
        public void decode(int token, @NonNull IMessageCodecContextV22 context, @NonNull IAPCByteReader stream, @NonNull IBlockCounterFrameConsumer consumer) throws IOException {
            assert (token == this.token());
            int cpu = PROPERTY_CPU.read(stream);
            Throwable throwable = null;
            Object var7_8 = null;
            try (IBlockCounterFrameMessageConsumer recordConsumer = consumer.consume(cpu);){
                PROPERTY_RECORDS.stream(context, stream, recordConsumer::consume);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }

        @Override
        public int encode(@NonNull BlockCounterFrame message, @NonNull IMessageCodecContextV22 context, @NonNull IAPCByteWriter stream) throws IOException {
            PROPERTY_CPU.write(stream, message.cpu);
            PROPERTY_RECORDS.write(context, stream, message.records);
            return this.token();
        }

        @Override
        public int token() {
            return 5;
        }

        public static Codec[] values() {
            Codec[] codecArray = ENUM$VALUES;
            int n = codecArray.length;
            Codec[] codecArray2 = new Codec[n];
            System.arraycopy(ENUM$VALUES, 0, codecArray2, 0, n);
            return codecArray2;
        }

        public static Codec valueOf(String string) {
            return Enum.valueOf(Codec.class, string);
        }
    }

    public static interface IBlockCounterFrameConsumer {
        public @NonNull IBlockCounterFrameMessageConsumer consume(int var1) throws IOException;
    }

    public static interface IBlockCounterFrameMessageConsumer
    extends Closeable {
        public void consume(@NonNull BlockCounterRecord var1) throws IOException;
    }
}

