/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.gator.messages;

import com.arm.streamline.protocol.gator.io.IAPCByteReader;
import com.arm.streamline.protocol.gator.io.IAPCByteWriter;
import com.arm.streamline.protocol.gator.messages.IIntProperty;
import com.arm.streamline.protocol.gator.messages.ITaggedMessageRecord;
import com.arm.streamline.protocol.gator.messages.ITaggedMessageRecordCodec;
import com.arm.streamline.protocol.gator.messages.ITaggedRecordListProperty;
import com.arm.streamline.protocol.gator.messages.PackedIntProperty;
import com.arm.utils.function.IThrowingConsumer;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class TaggedRecordListProperty<T extends ITaggedMessageRecord<? extends T, C>, C>
implements ITaggedRecordListProperty<T, C> {
    private final @NonNull TIntObjectMap<ITaggedMessageRecordCodec<? extends T, ? super C>> codecs = new TIntObjectHashMap();
    private final @NonNull String name;
    private final @NonNull IIntProperty tokenProperty;

    @SafeVarargs
    public TaggedRecordListProperty(@NonNull String name, ITaggedMessageRecordCodec<? extends T, ? super C> ... codecs) {
        assert (codecs.length > 0);
        this.name = name;
        this.tokenProperty = new PackedIntProperty("token");
        ITaggedMessageRecordCodec<? extends T, ? super C>[] iTaggedMessageRecordCodecArray = codecs;
        int n = codecs.length;
        int n2 = 0;
        while (n2 < n) {
            ITaggedMessageRecordCodec<T, C> codec = iTaggedMessageRecordCodecArray[n2];
            this.codecs.put(codec.token(), codec);
            ++n2;
        }
    }

    @Override
    public @NonNull String getName() {
        return this.name;
    }

    @Override
    public @NonNull T readOne(C context, @NonNull IAPCByteReader stream) throws IOException {
        int token = this.tokenProperty.read(stream);
        @Nullable ITaggedMessageRecordCodec codec = (ITaggedMessageRecordCodec)this.codecs.get(token);
        if (codec == null) {
            throw new IOException(String.format("Failed to decode record with token %d for property %s", token, this.name));
        }
        return (T)((ITaggedMessageRecord)codec.decode(token, context, stream));
    }

    @Override
    public <E extends Throwable> void stream(C context, @NonNull IAPCByteReader stream, @NonNull IThrowingConsumer<@NonNull T, E> consumer) throws IOException, E {
        while (stream.hasRemaining()) {
            @NonNull T record = this.readOne(context, stream);
            consumer.accept(record);
        }
    }

    @Override
    public void write(C context, @NonNull IAPCByteWriter stream, @NonNull Iterable<@NonNull T> values) throws IOException {
        for (ITaggedMessageRecord value : values) {
            this.writeOne(context, stream, value);
        }
    }

    private void writeOne(C context, @NonNull IAPCByteWriter stream, @NonNull T value) throws IOException {
        @NonNull ITaggedMessageRecordCodec<T, C> codec = value.getCodec();
        assert (this.codecs.containsValue(codec));
        this.tokenProperty.write(stream, codec.token());
        codec.encode(value, context, stream);
    }
}

