/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.gator.messages;

import com.arm.streamline.protocol.gator.io.IAPCByteReader;
import com.arm.streamline.protocol.gator.io.IAPCByteWriter;
import com.arm.streamline.protocol.gator.messages.IObjectProperty;
import com.arm.streamline.protocol.gator.messages.IOptionalObjectProperty;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class OptionalObjectProperty<T>
implements IOptionalObjectProperty<T> {
    private final @NonNull IObjectProperty<T> property;

    public OptionalObjectProperty(@NonNull IObjectProperty<T> property) {
        this.property = property;
    }

    @Override
    public @NonNull String getName() {
        return this.property.getName();
    }

    @Override
    public @Nullable T readOptional(@NonNull IAPCByteReader stream) throws IOException {
        if (!IOptionalObjectProperty.test(stream)) {
            return null;
        }
        return this.property.read(stream);
    }

    @Override
    public void writeOptional(@NonNull IAPCByteWriter stream, @Nullable T value) throws IOException {
        if (IOptionalObjectProperty.set(stream, value)) {
            assert (value != null);
            this.property.write(stream, value);
        }
    }
}

