/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.gator.messages;

import com.arm.streamline.protocol.gator.io.IAPCByteReader;
import com.arm.streamline.protocol.gator.io.IAPCByteWriter;
import com.arm.streamline.protocol.gator.messages.IEnumProperty;
import com.arm.streamline.protocol.gator.messages.IIntProperty;
import java.io.IOException;
import java.util.function.IntFunction;
import java.util.function.ToIntFunction;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class EnumProperty<T extends Enum<T>>
implements IEnumProperty<T> {
    private final @NonNull IIntProperty intProperty;
    private final @NonNull IntFunction<@Nullable T> mapper;
    private final @NonNull ToIntFunction<@NonNull T> unmapper;

    public EnumProperty(@NonNull IntFunction<@Nullable T> mapper, @NonNull ToIntFunction<@NonNull T> unmapper, @NonNull IIntProperty intProperty) {
        this.mapper = mapper;
        this.unmapper = unmapper;
        this.intProperty = intProperty;
    }

    @Override
    public @NonNull String getName() {
        return this.intProperty.getName();
    }

    @Override
    public @NonNull T read(@NonNull IAPCByteReader stream) throws IOException {
        int i = this.intProperty.read(stream);
        @Nullable Enum result = (Enum)this.mapper.apply(i);
        if (result == null) {
            throw new IOException(String.format("Invalid protocol value %d for enum on property %s", i, this.intProperty.getName()));
        }
        return (T)result;
    }

    @Override
    public void write(@NonNull IAPCByteWriter stream, @NonNull T value) throws IOException {
        int i = this.unmapper.applyAsInt(value);
        this.intProperty.write(stream, i);
    }
}

