/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.gator.io;

import com.arm.streamline.protocol.gator.io.IAPCFrameReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.eclipse.jdt.annotation.NonNull;

public class InputStreamAPCFrameReader
implements IAPCFrameReader {
    private final @NonNull ByteBuffer lengthBuffer = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
    private final @NonNull InputStream stream;

    public InputStreamAPCFrameReader(@NonNull InputStream stream) {
        this.stream = stream;
    }

    @Override
    public byte @NonNull [] decode() throws IOException {
        int result = this.stream.read(this.lengthBuffer.array());
        if (result < 0) {
            throw new EOFException();
        }
        if (result != this.lengthBuffer.capacity()) {
            throw new IOException("Could not read frame length");
        }
        int length = this.lengthBuffer.getInt(0);
        byte @NonNull [] data = new byte[length];
        int result2 = this.stream.read(data);
        if (result2 != data.length) {
            throw new IOException("Could not read frame data");
        }
        return data;
    }
}

