/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.capture.apc.time;

import com.arm.streamline.protocol.capture.apc.time.ITimestampMapper;
import com.arm.utils.numbers.UnsignedLong;
import java.util.function.LongUnaryOperator;
import org.eclipse.jdt.annotation.Nullable;

public class TimesyncInformation
implements ITimestampMapper {
    public final long duration;
    public final long earliestMonotonicDelta;
    public final long localClockBase;
    public final long monotonicRawBase;
    public final boolean nosync;
    public final @Nullable LongUnaryOperator speClockMapper;
    public final boolean useMonotonicRawAsLocalClockBase;

    public TimesyncInformation(boolean nosync, boolean useMonotonicRawAsLocalClockBase, long monotonicRawBase, long localClockBase, long earliestMonotonicDelta, long duration, @Nullable LongUnaryOperator speClockMapper) {
        assert (earliestMonotonicDelta >= 0L);
        this.nosync = nosync;
        this.useMonotonicRawAsLocalClockBase = useMonotonicRawAsLocalClockBase;
        this.monotonicRawBase = monotonicRawBase;
        this.localClockBase = localClockBase;
        this.earliestMonotonicDelta = earliestMonotonicDelta;
        this.duration = duration;
        this.speClockMapper = speClockMapper;
    }

    @Override
    public long mapLocalClock(long time) {
        if (this.useMonotonicRawAsLocalClockBase) {
            return this.mapMonotonicRaw(time);
        }
        if (UnsignedLong.compare((long)this.localClockBase, (long)time) > 0) {
            return -1L;
        }
        return this.mapMonotonicDelta(time - this.localClockBase);
    }

    @Override
    public long mapLocalClockOrMonotonicRaw(long value) {
        if (this.nosync) {
            return this.mapMonotonicRaw(value);
        }
        return this.mapLocalClock(value);
    }

    @Override
    public long mapMonotonicDelta(long value) {
        if (Long.compare(this.earliestMonotonicDelta, value) > 0) {
            return -1L;
        }
        return value - this.earliestMonotonicDelta;
    }

    @Override
    public long mapMonotonicRaw(long time) {
        if (UnsignedLong.compare((long)this.monotonicRawBase, (long)time) > 0) {
            return -1L;
        }
        return this.mapMonotonicDelta(time - this.monotonicRawBase);
    }

    @Override
    public long mapSpeClock(int deviceNumber, long clock) {
        @Nullable LongUnaryOperator speClockMapper = this.speClockMapper;
        if (speClockMapper == null) {
            throw new IllegalStateException("No SPE timesync data received");
        }
        long clockMonotonicRaw = speClockMapper.applyAsLong(clock);
        return this.mapMonotonicRaw(clockMonotonicRaw);
    }

    public long preferredLocalClockBase() {
        return this.useMonotonicRawAsLocalClockBase ? this.monotonicRawBase : this.localClockBase;
    }
}

