/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.capture.apc.time;

import com.arm.streamline.protocol.capture.apc.time.ClockSource;
import com.arm.utils.numbers.UnsignedLong;
import org.eclipse.jdt.annotation.NonNull;

public final class Timestamp
implements Comparable<Timestamp> {
    public static final @NonNull Timestamp BEFORE_START = new Timestamp(ClockSource.BEFORE_START, 0L);
    public final @NonNull ClockSource clockSource;
    public final long timestamp;

    public static @NonNull Timestamp min(@NonNull Timestamp a, @NonNull Timestamp b) {
        return a.compareTo(b) <= 0 ? a : b;
    }

    public Timestamp(@NonNull ClockSource clockSource, long timestamp) {
        this.clockSource = clockSource;
        this.timestamp = timestamp;
    }

    @Override
    public int compareTo(Timestamp o) {
        if (this.clockSource == ClockSource.BEFORE_START) {
            if (o.clockSource == ClockSource.BEFORE_START) {
                return 0;
            }
            return -1;
        }
        if (o.clockSource == ClockSource.BEFORE_START) {
            return 1;
        }
        if (this.clockSource != o.clockSource) {
            throw new AssertionError((Object)(String.valueOf((Object)this.clockSource) + " vs " + String.valueOf((Object)o.clockSource)));
        }
        if (this.clockSource == ClockSource.MONOTONIC_DELTA) {
            return Long.compare(this.timestamp, o.timestamp);
        }
        return UnsignedLong.compare((long)this.timestamp, (long)o.timestamp);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Timestamp) {
            Timestamp that = (Timestamp)obj;
            return this.clockSource == that.clockSource && this.timestamp == that.timestamp;
        }
        return false;
    }

    public int hashCode() {
        return Long.hashCode(this.timestamp) * 31 + this.clockSource.hashCode();
    }

    public String toString() {
        return String.format("Timestamp [clockSource=%s, timestamp=%s]", new Object[]{this.clockSource, this.timestamp});
    }
}

