/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.capture.apc.protocol.v22;

import com.arm.streamline.analysis.database.api.profiling.IBacktraceSource;
import com.arm.streamline.protocol.capture.apc.io.APCFrameAddress;
import com.arm.streamline.protocol.capture.apc.protocol.IAPCProtocolVersionPassAdapter;
import com.arm.streamline.protocol.capture.apc.protocol.IGatorPerVirtualMachineProtocolEventConsumer;
import com.arm.streamline.protocol.capture.apc.protocol.IGatorProtocolEventConsumer;
import com.arm.streamline.protocol.capture.apc.protocol.v22.GatorPassStreamingMessageConsumerV22;
import com.arm.streamline.protocol.capture.apc.protocol.v22.MessageCodecContextV22;
import com.arm.streamline.protocol.gator.io.IAPCByteReader;
import com.arm.streamline.protocol.gator.v22.perf.FrameCodecPerfV22;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;

public final class APCProtocolPerfV22PassAdapter
implements IAPCProtocolVersionPassAdapter {
    private final @NonNull FrameCodecPerfV22 codec;
    private final @NonNull IBacktraceSource ebsBacktraceSource;
    private final int protocolVersionNo;

    public APCProtocolPerfV22PassAdapter(@NonNull IBacktraceSource ebsBacktraceSource, int protocolVersionNo) {
        this.ebsBacktraceSource = ebsBacktraceSource;
        this.protocolVersionNo = protocolVersionNo;
        this.codec = new FrameCodecPerfV22();
    }

    @Override
    public boolean hasMixedCpuPerfFrames() {
        return true;
    }

    @Override
    public void process(@NonNull IGatorProtocolEventConsumer globalEventConsumer, @NonNull APCFrameAddress frameAddress, @NonNull IAPCByteReader reader) throws IOException {
        @NonNull IGatorPerVirtualMachineProtocolEventConsumer eventConsumer = globalEventConsumer.getVm(0L);
        @NonNull GatorPassStreamingMessageConsumerV22 consumer = new GatorPassStreamingMessageConsumerV22(frameAddress, this.ebsBacktraceSource, eventConsumer);
        @NonNull MessageCodecContextV22 context = new MessageCodecContextV22(eventConsumer, this.protocolVersionNo);
        this.codec.decode(context, reader, consumer);
    }
}

