/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.capture.apc.protocol.perf;

import com.arm.streamline.perf.InvalidPerfDataException;
import com.arm.streamline.perf.records.EventAttribute;
import com.arm.streamline.perf.records.EventHeader;
import com.arm.streamline.perf.records.ReadFormat;
import com.arm.streamline.perf.records.RecordBlob;
import com.arm.streamline.perf.records.RegisterValues;
import com.arm.streamline.protocol.capture.apc.protocol.perf.IPerfDataBufferEventConsumer;
import com.arm.streamline.protocol.capture.apc.protocol.perf.IPerfDataBufferPassProcessor;
import com.arm.streamline.protocol.capture.apc.protocol.perf.IPerfDataBufferRecordTimestampTracker;
import com.arm.streamline.protocol.capture.apc.protocol.perf.IPerfProtocolState;
import com.arm.streamline.protocol.capture.apc.protocol.perf.PerfDataBufferRecordTimestampTracker;
import com.arm.streamline.protocol.capture.apc.time.Timestamp;
import com.arm.streamline.protocol.misc.TaskId;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class PerfDataBufferPassProcessor
implements IPerfDataBufferPassProcessor {
    private final @NonNull ByteOrder byteOrder;
    private final @NonNull IPerfProtocolState perfAttributesTracker;
    private final @NonNull IPerfDataBufferRecordTimestampTracker timestampTracker;

    public PerfDataBufferPassProcessor(@NonNull ByteOrder byteOrder, @NonNull IPerfProtocolState perfAttributesTracker) {
        this(byteOrder, perfAttributesTracker, new PerfDataBufferRecordTimestampTracker());
    }

    protected PerfDataBufferPassProcessor(@NonNull ByteOrder byteOrder, @NonNull IPerfProtocolState perfAttributesTracker, @NonNull IPerfDataBufferRecordTimestampTracker timestampTracker) {
        this.byteOrder = byteOrder;
        this.perfAttributesTracker = perfAttributesTracker;
        this.timestampTracker = timestampTracker;
    }

    @Override
    public <T> void processRecords(T userData, int protocolDeviceNumber, byte @NonNull [] data, @NonNull IPerfDataBufferEventConsumer<T> consumer) throws IOException {
        @Nullable Long attributeSampleTypeSharedIdBits = this.perfAttributesTracker.getAttributeSampleTypeSharedIdBits();
        if (attributeSampleTypeSharedIdBits == null) {
            throw new InvalidPerfDataException(InvalidPerfDataException.Reason.MISSING_ID);
        }
        @NonNull ByteBuffer byteBuffer = ByteBuffer.wrap(data).order(this.byteOrder);
        @NonNull PerfDataBufferPassProcessorRecordBlobVisitor<T> recordVisitor = new PerfDataBufferPassProcessorRecordBlobVisitor<T>(protocolDeviceNumber, this.timestampTracker, userData, consumer);
        while (byteBuffer.hasRemaining()) {
            @NonNull RecordBlob recordBlob = new RecordBlob(byteBuffer);
            @NonNull RecordBlob.SampleId sampleId = recordBlob.parseSampleId(this.byteOrder, attributeSampleTypeSharedIdBits, this.perfAttributesTracker);
            recordBlob.accept(recordVisitor, sampleId, this.byteOrder, null);
        }
    }

    public static @Nullable TaskId makeTaskId(@Nullable Integer pid, @Nullable Integer tid) {
        if (tid != null && tid < 0) {
            return new TaskId(0, 0);
        }
        return tid != null ? new TaskId(pid, (int)tid) : null;
    }

    public static final class PerfDataBufferPassProcessorRecordBlobVisitor<T>
    implements RecordBlob.IRecordBlobVisitor<Void, Void, IOException> {
        private final @NonNull IPerfDataBufferEventConsumer<T> consumer;
        private final int protocolDeviceNumber;
        private final @NonNull IPerfDataBufferRecordTimestampTracker timestampTracker;
        private final T userData;

        private static @Nullable TaskId getTaskId(@NonNull RecordBlob.SampleId sampleId) {
            @Nullable Integer pid = sampleId.pid;
            @Nullable Integer tid = sampleId.tid;
            return PerfDataBufferPassProcessor.makeTaskId(pid, tid);
        }

        private static int selectDeviceNumber(int protocolDeviceNumber, @Nullable Integer cpu) {
            if (cpu != null) {
                return cpu;
            }
            return protocolDeviceNumber;
        }

        public PerfDataBufferPassProcessorRecordBlobVisitor(int protocolDeviceNumber, @NonNull IPerfDataBufferRecordTimestampTracker timestampTracker, T userData, @NonNull IPerfDataBufferEventConsumer<T> consumer) {
            this.protocolDeviceNumber = protocolDeviceNumber;
            this.timestampTracker = timestampTracker;
            this.userData = userData;
            this.consumer = consumer;
        }

        @Override
        public Void aux(@NonNull EventHeader header, @NonNull RecordBlob.SampleId sampleId, long offset, long size, long flags, Void ignored) throws IOException {
            int deviceNumber = PerfDataBufferPassProcessorRecordBlobVisitor.selectDeviceNumber(this.protocolDeviceNumber, sampleId.cpu);
            @NonNull Timestamp timestamp = this.timestampTracker.fromSampleId(deviceNumber, sampleId);
            @Nullable TaskId taskId = PerfDataBufferPassProcessorRecordBlobVisitor.getTaskId(sampleId);
            this.consumer.aux(this.userData, timestamp.clockSource, timestamp.timestamp, deviceNumber, sampleId.getAttributeId(), taskId, offset, size, flags);
            return null;
        }

        @Override
        public Void comm(@NonNull EventHeader header, @NonNull RecordBlob.SampleId sampleId, int pid, int tid, @NonNull String comm, Void ignored) throws IOException {
            int deviceNumber = PerfDataBufferPassProcessorRecordBlobVisitor.selectDeviceNumber(this.protocolDeviceNumber, sampleId.cpu);
            @NonNull Timestamp timestamp = this.timestampTracker.fromSampleId(deviceNumber, sampleId);
            boolean exec = (header.getMisc() & 0x2000) != 0;
            @Nullable EventAttribute attribute = sampleId.attribute;
            Long time = attribute != null && !attribute.isFlagSet(EventAttribute.Flags.USE_CLOCKID) ? sampleId.time : null;
            this.consumer.comm(this.userData, timestamp.clockSource, timestamp.timestamp, deviceNumber, new TaskId(pid, tid), comm, exec, time);
            return null;
        }

        @Override
        public Void exit(@NonNull EventHeader header, @NonNull RecordBlob.SampleId sampleId, int ppid, int ptid, int pid, int tid, long time, Void ignored) throws IOException {
            int deviceNumber = PerfDataBufferPassProcessorRecordBlobVisitor.selectDeviceNumber(this.protocolDeviceNumber, sampleId.cpu);
            @NonNull Timestamp timestamp = this.timestampTracker.fromTimestamp(deviceNumber, sampleId, time);
            this.consumer.exit(this.userData, timestamp.clockSource, timestamp.timestamp, deviceNumber, new TaskId(pid, tid));
            return null;
        }

        @Override
        public Void fork(@NonNull EventHeader header, @NonNull RecordBlob.SampleId sampleId, int ppid, int ptid, int pid, int tid, long time, Void ignored) throws IOException {
            int deviceNumber = PerfDataBufferPassProcessorRecordBlobVisitor.selectDeviceNumber(this.protocolDeviceNumber, sampleId.cpu);
            @NonNull Timestamp timestamp = this.timestampTracker.fromTimestamp(deviceNumber, sampleId, time);
            this.consumer.fork(this.userData, timestamp.clockSource, timestamp.timestamp, deviceNumber, new TaskId(ppid, ptid), new TaskId(pid, tid));
            return null;
        }

        @Override
        public Void itraceStart(@NonNull EventHeader header, @NonNull RecordBlob.SampleId sampleId, int pid, int tid, Void ignored) throws IOException {
            int deviceNumber = PerfDataBufferPassProcessorRecordBlobVisitor.selectDeviceNumber(this.protocolDeviceNumber, sampleId.cpu);
            @NonNull Timestamp timestamp = this.timestampTracker.fromSampleId(deviceNumber, sampleId);
            this.consumer.itraceStart(this.userData, timestamp.clockSource, timestamp.timestamp, deviceNumber, sampleId.getAttributeId(), new TaskId(pid, tid));
            return null;
        }

        @Override
        public Void lost(@NonNull EventHeader header, @NonNull RecordBlob.SampleId sampleId, long id, long lost, Void ignored) throws IOException {
            int deviceNumber = PerfDataBufferPassProcessorRecordBlobVisitor.selectDeviceNumber(this.protocolDeviceNumber, sampleId.cpu);
            @NonNull Timestamp timestamp = this.timestampTracker.fromSampleId(deviceNumber, sampleId);
            this.consumer.lost(this.userData, timestamp.clockSource, timestamp.timestamp, deviceNumber, id, lost);
            return null;
        }

        @Override
        public Void lostSamples(@NonNull EventHeader header, @NonNull RecordBlob.SampleId sampleId, long lost, Void ignored) throws IOException {
            int deviceNumber = PerfDataBufferPassProcessorRecordBlobVisitor.selectDeviceNumber(this.protocolDeviceNumber, sampleId.cpu);
            @NonNull Timestamp timestamp = this.timestampTracker.fromSampleId(deviceNumber, sampleId);
            this.consumer.lostSamples(this.userData, timestamp.clockSource, timestamp.timestamp, deviceNumber, lost);
            return null;
        }

        @Override
        public Void mmap(@NonNull EventHeader header, @NonNull RecordBlob.SampleId sampleId, int pid, int tid, long addr, long len, long pgOff, @NonNull String filename, Void ignored) throws IOException {
            int deviceNumber = PerfDataBufferPassProcessorRecordBlobVisitor.selectDeviceNumber(this.protocolDeviceNumber, sampleId.cpu);
            @NonNull Timestamp timestamp = this.timestampTracker.fromSampleId(deviceNumber, sampleId);
            boolean data = (header.getMisc() & 0x2000) != 0;
            this.consumer.mmap(this.userData, timestamp.clockSource, timestamp.timestamp, deviceNumber, new TaskId(pid, tid), addr, len, pgOff, filename, data);
            return null;
        }

        @Override
        public Void mmap2(@NonNull EventHeader header, @NonNull RecordBlob.SampleId sampleId, int pid, int tid, long addr, long len, long pgOff, int maj, int min, long ino, long ino_generation, int prot, int flags, @NonNull String filename, Void ignored) throws IOException {
            int deviceNumber = PerfDataBufferPassProcessorRecordBlobVisitor.selectDeviceNumber(this.protocolDeviceNumber, sampleId.cpu);
            @NonNull Timestamp timestamp = this.timestampTracker.fromSampleId(deviceNumber, sampleId);
            boolean data = (header.getMisc() & 0x2000) != 0;
            this.consumer.mmap(this.userData, timestamp.clockSource, timestamp.timestamp, deviceNumber, new TaskId(pid, tid), addr, len, pgOff, filename, data);
            return null;
        }

        @Override
        public Void other(@NonNull EventHeader header, @NonNull RecordBlob.SampleId sampleId, @NonNull ByteBuffer buffer, Void ignored) throws IOException {
            int deviceNumber = PerfDataBufferPassProcessorRecordBlobVisitor.selectDeviceNumber(this.protocolDeviceNumber, sampleId.cpu);
            @NonNull Timestamp timestamp = this.timestampTracker.fromSampleId(deviceNumber, sampleId);
            this.consumer.other(this.userData, timestamp.clockSource, timestamp.timestamp, header, sampleId, deviceNumber, buffer);
            return null;
        }

        @Override
        public Void read(@NonNull EventHeader header, @NonNull RecordBlob.SampleId sampleId, int pid, int tid, @NonNull ReadFormat readFormat, Void ignored) throws IOException {
            int deviceNumber = PerfDataBufferPassProcessorRecordBlobVisitor.selectDeviceNumber(this.protocolDeviceNumber, sampleId.cpu);
            @NonNull Timestamp timestamp = this.timestampTracker.fromSampleId(deviceNumber, sampleId);
            this.consumer.read(this.userData, timestamp.clockSource, timestamp.timestamp, deviceNumber, new TaskId(pid, tid), readFormat);
            return null;
        }

        @Override
        public Void sample(@NonNull EventHeader header, @NonNull RecordBlob.SampleRecord sampleRecord, @Nullable ReadFormat readFormat, long @Nullable [] callchain, byte @Nullable [] raw, boolean registersHostIs64bit, @NonNull RecordBlob.IRecordBlobVisitor.Abi registersAbi, @Nullable RegisterValues registers, Void ignored) throws IOException {
            int deviceNumber = PerfDataBufferPassProcessorRecordBlobVisitor.selectDeviceNumber(this.protocolDeviceNumber, sampleRecord.cpu);
            @NonNull Timestamp timestamp = this.timestampTracker.fromSampleId(deviceNumber, sampleRecord);
            this.consumer.sample(this.userData, timestamp.clockSource, timestamp.timestamp, header, sampleRecord, deviceNumber, readFormat, callchain, raw, registersHostIs64bit, registersAbi, registers);
            return null;
        }

        @Override
        public Void simplePerfCallchain(@NonNull EventHeader header, @NonNull RecordBlob.SampleId sampleId, int pid, int tid, long chainType, long time, long[] ips, long[] sps, Void data) throws IOException {
            int deviceNumber = PerfDataBufferPassProcessorRecordBlobVisitor.selectDeviceNumber(this.protocolDeviceNumber, sampleId.cpu);
            @NonNull Timestamp timestamp = this.timestampTracker.fromTimestamp(deviceNumber, sampleId, time);
            this.consumer.simplePerfCallchain(this.userData, timestamp.clockSource, timestamp.timestamp, deviceNumber, new TaskId(pid, tid), chainType, time, ips, sps);
            return null;
        }

        @Override
        public Void simplePerfKAllSyms(@NonNull EventHeader header, @NonNull RecordBlob.SampleId sampleId, @NonNull String kallsyms, Void data) throws IOException {
            int deviceNumber = PerfDataBufferPassProcessorRecordBlobVisitor.selectDeviceNumber(this.protocolDeviceNumber, sampleId.cpu);
            @NonNull Timestamp timestamp = this.timestampTracker.fromSampleId(deviceNumber, sampleId);
            this.consumer.simplePerfKAllSyms(this.userData, timestamp.clockSource, timestamp.timestamp, deviceNumber, kallsyms);
            return null;
        }

        @Override
        public Void swtch(@NonNull EventHeader header, @NonNull RecordBlob.SampleId sampleId, Void ignored) throws IOException {
            int deviceNumber = PerfDataBufferPassProcessorRecordBlobVisitor.selectDeviceNumber(this.protocolDeviceNumber, sampleId.cpu);
            @NonNull Timestamp timestamp = this.timestampTracker.fromSampleId(deviceNumber, sampleId);
            boolean out = (header.getMisc() & 0x2000) != 0;
            @Nullable TaskId taskId = PerfDataBufferPassProcessorRecordBlobVisitor.getTaskId(sampleId);
            this.consumer.swtch(this.userData, timestamp.clockSource, timestamp.timestamp, deviceNumber, sampleId.getAttributeId(), taskId, out);
            return null;
        }

        @Override
        public Void swtchCpuWide(@NonNull EventHeader header, @NonNull RecordBlob.SampleId sampleId, int pid, int tid, Void ignored) throws IOException {
            boolean out;
            int deviceNumber = PerfDataBufferPassProcessorRecordBlobVisitor.selectDeviceNumber(this.protocolDeviceNumber, sampleId.cpu);
            @NonNull Timestamp timestamp = this.timestampTracker.fromSampleId(deviceNumber, sampleId);
            boolean bl = out = (header.getMisc() & 0x2000) != 0;
            @NonNull TaskId prevNextTaskId = pid < 0 || tid < 0 ? new TaskId(0, 0) : new TaskId(pid, tid != 0 ? tid : pid);
            @Nullable TaskId sampleTaskId = PerfDataBufferPassProcessorRecordBlobVisitor.getTaskId(sampleId);
            this.consumer.swtchCpuWide(this.userData, timestamp.clockSource, timestamp.timestamp, deviceNumber, sampleId.getAttributeId(), sampleTaskId, out, prevNextTaskId);
            return null;
        }

        @Override
        public Void throttle(@NonNull EventHeader header, @NonNull RecordBlob.SampleId sampleId, long time, long id, long streamId, Void ignored) throws IOException {
            int deviceNumber = PerfDataBufferPassProcessorRecordBlobVisitor.selectDeviceNumber(this.protocolDeviceNumber, sampleId.cpu);
            @NonNull Timestamp timestamp = this.timestampTracker.fromTimestamp(deviceNumber, sampleId, time);
            this.consumer.throttle(this.userData, timestamp.clockSource, timestamp.timestamp, deviceNumber, time, id, streamId);
            return null;
        }

        @Override
        public Void unthrottle(@NonNull EventHeader header, @NonNull RecordBlob.SampleId sampleId, long time, long id, long streamId, Void ignored) throws IOException {
            int deviceNumber = PerfDataBufferPassProcessorRecordBlobVisitor.selectDeviceNumber(this.protocolDeviceNumber, sampleId.cpu);
            @NonNull Timestamp timestamp = this.timestampTracker.fromTimestamp(deviceNumber, sampleId, time);
            this.consumer.unthrottle(this.userData, timestamp.clockSource, timestamp.timestamp, deviceNumber, time, id, streamId);
            return null;
        }
    }
}

