/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.capture.apc.protocol.perf;

import com.arm.streamline.protocol.capture.apc.protocol.perf.IPerfAuxDataBufferReader;
import com.arm.streamline.protocol.capture.apc.protocol.perf.IPerfAuxDataBufferTracker;
import com.arm.streamline.protocol.capture.apc.protocol.perf.IPerfAuxDataBufferWriter;
import com.arm.streamline.protocol.capture.apc.protocol.perf.PerfAuxDataBuffer;
import com.arm.utils.MapUtils;
import com.arm.utils.function.Throwing;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;

public final class PerfAuxDataBufferTracker
implements IPerfAuxDataBufferTracker {
    private final @NonNull Map<@NonNull Key, @NonNull PerfAuxDataBuffer> buffers = new HashMap<Key, PerfAuxDataBuffer>();
    private final @NonNull File outputDirectory;

    public PerfAuxDataBufferTracker(@NonNull File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    @Override
    public void close() throws IOException {
        Throwing.closeAll((Iterable[])new Iterable[]{this.buffers.values()});
    }

    @Override
    public @NonNull IPerfAuxDataBufferReader getPerfAuxBufferReader(long vmUID, int cpu) throws IOException {
        return this.getBuffer(vmUID, cpu);
    }

    @Override
    public @NonNull IPerfAuxDataBufferWriter getPerfAuxBufferWriter(long vmUID, int cpu) throws IOException {
        return this.getBuffer(vmUID, cpu);
    }

    private @NonNull PerfAuxDataBuffer createBuffer(@NonNull Key key) throws IOException {
        File parentDir = new File(this.outputDirectory, String.valueOf(key.vmUID));
        File dataFile = new File(parentDir, String.format("%d.dat", key.cpu));
        if (!parentDir.mkdirs() && !parentDir.isDirectory()) {
            throw new FileNotFoundException(parentDir.getAbsolutePath());
        }
        return new PerfAuxDataBuffer(dataFile);
    }

    private @NonNull PerfAuxDataBuffer getBuffer(long vmUID, int cpu) throws IOException {
        Key key = new Key(vmUID, cpu);
        return (PerfAuxDataBuffer)MapUtils.computeIfAbsentThrows(this.buffers, (Object)key, this::createBuffer);
    }

    private static final class Key {
        public final int cpu;
        public final long vmUID;

        public Key(long vmUID, int cpu) {
            this.vmUID = vmUID;
            this.cpu = cpu;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof Key) {
                Key that = (Key)obj;
                return this.vmUID == that.vmUID && this.cpu == that.cpu;
            }
            return false;
        }

        public int hashCode() {
            return Long.hashCode(this.vmUID) * 31 + Integer.hashCode(this.cpu);
        }
    }
}

