/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.capture.apc.protocol.external.tl;

import com.arm.streamline.protocol.capture.apc.protocol.external.tl.OpenClContext;
import com.arm.streamline.protocol.capture.apc.protocol.external.tl.OpenClQueue;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import org.eclipse.jdt.annotation.NonNull;

public class OpenClDevice {
    private final @NonNull OpenClContext context;
    private final @NonNull String deviceName;
    private final @NonNull TObjectIntMap<OpenClQueue> deviceQueues = new TObjectIntHashMap(10, 0.5f, 0);
    private final int trackUID;

    public OpenClDevice(@NonNull OpenClContext context, @NonNull String deviceName, int trackUID) {
        this.context = context;
        this.deviceName = deviceName;
        this.trackUID = trackUID;
    }

    public @NonNull OpenClContext getContext() {
        return this.context;
    }

    public @NonNull String getName() {
        return this.deviceName;
    }

    public int getQueueNumber(@NonNull OpenClQueue queueObject) {
        return this.deviceQueues.adjustOrPutValue((Object)queueObject, 0, this.deviceQueues.size());
    }

    public int getTrackUID() {
        return this.trackUID;
    }

    public String toString() {
        return this.deviceName;
    }
}

