/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.capture.apc.protocol.external.mipe;

import com.arm.streamline.protocol.ProtocolException;
import com.arm.streamline.protocol.capture.apc.protocol.external.mipe.MipeHeader;
import com.arm.streamline.protocol.capture.apc.protocol.external.mipe.MipeVersion;
import com.arm.utils.NullChecking;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class MipePacket_Control_SharedParameter {
    public static final int MALI_MAGIC = 1835101289;
    public final @Nullable String ddkVersion;
    public final @Nullable String gpuVersion;
    public final @NonNull MipeHeader header;
    public final @Nullable String info;
    public final int maxDataLen;
    public final @NonNull MipeVersion mipeHwcPacketEncodingVersion;
    public final @NonNull MipeVersion mipePacketEncodingVersion;
    public final int pid;
    public final @Nullable String processName;
    public final int protocolVersion;

    public static @Nullable MipePacket_Control_SharedParameter create(@NonNull MipeHeader originalHeader, byte @NonNull [] data) throws ProtocolException {
        if (originalHeader.getPacketFamily() != 0 || originalHeader.getPacketId() != 0) {
            throw new IllegalArgumentException();
        }
        if (originalHeader.getLengthWord() == 0) {
            return null;
        }
        @NonNull ByteOrder byteOrder = MipePacket_Control_SharedParameter.peakByteIsBigEndian(data[0]) ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
        @NonNull MipeHeader header = originalHeader.getByteOrder() == byteOrder ? originalHeader : originalHeader.swapEndian();
        int dataLength = header.getDataLength();
        if (dataLength > data.length) {
            throw new IllegalArgumentException();
        }
        if (dataLength < 12) {
            throw new ProtocolException(ProtocolException.Reason.INVALID_MALI_ENCAPSULATED_DATA);
        }
        if (header.isSequenceNumbered()) {
            throw new AssertionError();
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(data, 0, dataLength);
        byteBuffer.order(byteOrder);
        int maliMagic = byteBuffer.getInt();
        if (maliMagic != 1835101289) {
            throw new ProtocolException(ProtocolException.Reason.INVALID_MALI_ENCAPSULATED_DATA);
        }
        int maxDataLen = byteBuffer.getInt();
        if ((maxDataLen & 0xFF000000) != 0) {
            throw new ProtocolException(ProtocolException.Reason.INVALID_MALI_ENCAPSULATED_DATA);
        }
        int pid = byteBuffer.getInt();
        String info = null;
        String gpuVersion = null;
        String ddkVersion = null;
        String processName = null;
        int protocolVersion = 0;
        MipeVersion mipePacketEncodingVersion = null;
        MipeVersion mipeHwcPacketEncodingVersion = null;
        int index = 0;
        while (byteBuffer.remaining() >= 4) {
            int offset = byteBuffer.getInt();
            if (offset == 0) break;
            switch (index) {
                case 0: {
                    info = MipePacket_Control_SharedParameter.readString(byteBuffer, offset);
                    break;
                }
                case 1: {
                    gpuVersion = MipePacket_Control_SharedParameter.readString(byteBuffer, offset);
                    break;
                }
                case 2: {
                    ddkVersion = MipePacket_Control_SharedParameter.readString(byteBuffer, offset);
                    break;
                }
                case 3: {
                    protocolVersion = byteBuffer.getInt(offset);
                    break;
                }
                case 4: {
                    processName = MipePacket_Control_SharedParameter.readString(byteBuffer, offset);
                    break;
                }
                case 5: {
                    int mipePacketEncodingVersionNumber = byteBuffer.getInt(offset);
                    mipePacketEncodingVersion = MipeVersion.fromVersionInt(mipePacketEncodingVersionNumber);
                    break;
                }
                case 6: {
                    int mipeHwcPacketEncodingVersionNumber = byteBuffer.getInt(offset);
                    mipeHwcPacketEncodingVersion = MipeVersion.fromVersionInt(mipeHwcPacketEncodingVersionNumber);
                    break;
                }
            }
            ++index;
        }
        return new MipePacket_Control_SharedParameter(header, maxDataLen, pid, protocolVersion, info, gpuVersion, ddkVersion, processName, (MipeVersion)NullChecking.neverNullOr(mipePacketEncodingVersion, (Object)MipeVersion.ONE), (MipeVersion)NullChecking.neverNullOr((Object)mipeHwcPacketEncodingVersion, (Object)MipeVersion.ONE));
    }

    public static boolean peakByteIsBigEndian(byte b) {
        return b == 109;
    }

    private static @NonNull String readString(@NonNull ByteBuffer byteBuffer, int offset) {
        int index = offset;
        while (index < byteBuffer.limit() && byteBuffer.get(index) != 0) {
            ++index;
        }
        int length = index - offset;
        byte[] bytes = new byte[length];
        System.arraycopy(byteBuffer.array(), offset, bytes, 0, length);
        return new String(bytes, StandardCharsets.US_ASCII);
    }

    protected MipePacket_Control_SharedParameter(@NonNull MipeHeader header, int maxDataLen, int pid, int protocolVersion, @Nullable String info, @Nullable String gpuVersion, @Nullable String ddkVersion, @Nullable String processName, @NonNull MipeVersion mipePacketEncodingVersion, @NonNull MipeVersion mipeHwcPacketEncodingVersion) {
        this.header = header;
        this.maxDataLen = maxDataLen;
        this.pid = pid;
        this.protocolVersion = protocolVersion;
        this.info = info;
        this.gpuVersion = gpuVersion;
        this.ddkVersion = ddkVersion;
        this.processName = processName;
        this.mipePacketEncodingVersion = mipePacketEncodingVersion;
        this.mipeHwcPacketEncodingVersion = mipeHwcPacketEncodingVersion;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof MipePacket_Control_SharedParameter) {
            MipePacket_Control_SharedParameter that = (MipePacket_Control_SharedParameter)obj;
            return this.header.equals(that.header) && this.maxDataLen == that.maxDataLen && this.pid == that.pid && this.protocolVersion == that.protocolVersion && NullChecking.equalsNullable((Object)this.info, (Object)that.info) && NullChecking.equalsNullable((Object)this.gpuVersion, (Object)that.gpuVersion) && NullChecking.equalsNullable((Object)this.ddkVersion, (Object)that.ddkVersion) && NullChecking.equalsNullable((Object)this.processName, (Object)that.processName) && this.mipePacketEncodingVersion.equals(that.mipePacketEncodingVersion) && this.mipeHwcPacketEncodingVersion.equals(that.mipeHwcPacketEncodingVersion);
        }
        return false;
    }

    public int hashCode() {
        return ((this.maxDataLen * 31 + Integer.hashCode(this.protocolVersion)) * 31 + this.pid) * 31 + this.header.hashCode();
    }

    public String toString() {
        return String.format("MipePacket_Control_SharedParameter [header=%s, maxDataLen=%s, pid=%s, protocolVersion=%s, info=%s, gpuVersion=%s, ddkVersion=%s, processName=%s, mipePacketEncodingVersion=%s, mipeHwcPacketEncodingVersion=%s]", this.header, this.maxDataLen, this.pid, this.protocolVersion, this.info, this.gpuVersion, this.ddkVersion, this.processName, this.mipePacketEncodingVersion, this.mipeHwcPacketEncodingVersion);
    }
}

