/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.capture.apc.protocol.external.mipe;

import com.arm.streamline.analysis.model.ICounterSeriesKey;
import com.arm.streamline.analysis.model.StaticCounterSeriesKey;
import com.arm.streamline.common.model.topology.ProcessingElementReference;
import com.arm.streamline.common.model.topology.ProcessingElementReferenceSet;
import com.arm.streamline.protocol.capture.apc.pass_two.warnings.WarningsFactory;
import com.arm.streamline.protocol.capture.apc.protocol.external.IExternalProtocolEventStream;
import com.arm.streamline.protocol.capture.apc.protocol.external.IMaliProtocolDecoder;
import com.arm.streamline.protocol.capture.apc.protocol.external.IMidgardActivityParser;
import com.arm.streamline.protocol.capture.apc.protocol.external.mipe.IMipePacketVisitor;
import com.arm.streamline.protocol.capture.apc.protocol.external.mipe.MipeHeader;
import com.arm.streamline.protocol.capture.apc.protocol.external.mipe.MipePacket_Control_HW_Counter_Directory;
import com.arm.streamline.protocol.capture.apc.protocol.external.mipe.MipePacket_Control_SharedParameter;
import com.arm.streamline.protocol.capture.apc.protocol.external.mipe.MipePacket_HW_Counter_Values;
import com.arm.streamline.protocol.capture.apc.protocol.external.mipe.MipePacket_Huge_WinDump;
import com.arm.streamline.protocol.capture.apc.protocol.external.mipe.MipeVersion;
import com.arm.streamline.protocol.capture.apc.time.ClockSource;
import com.arm.streamline.protocol.misc.TaskId;
import com.arm.utils.MapUtils;
import com.arm.utils.function.IThrowingBiFunction;
import gnu.trove.iterator.TIntIntIterator;
import gnu.trove.iterator.TIntObjectIterator;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.IntFunction;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class MipePacketVisitor
implements IMipePacketVisitor {
    public static final @NonNull String ATTRIBUTE_MALI_DDK_VERSION = "Mali DDK version";
    public static final @NonNull String ATTRIBUTE_MALI_GPU_VERSION = "Mali GPU version";
    public static final @NonNull String ATTRIBUTE_MALI_INFO = "Mali info";
    public static final @NonNull String ATTRIBUTE_MALI_PROCESS_NAME = "Mali process name";
    public static final @NonNull String ATTRIBUTE_MALI_TIEBREAK = "Mali compatibility tiebreak";
    private static final byte[] GPU1_HEADER;
    private static final @NonNull String MALI_COUNTER_PREFIX = "ARM_Mali-";
    private static final @NonNull MipeVersion MAX_MIPE_PACKET_ENCODING;
    private static final @NonNull MipeVersion MAX_NEW_FORMAT_TIEBREAK;
    private static final int MAX_OLD_FORMAT_TIEBREAK = 4;
    private static final @NonNull MipeVersion MIN_MIPE_PACKET_ENCODING;
    private static final @NonNull MipeVersion MIN_NEW_FORMAT_TIEBREAK;
    private static final int MIN_OLD_FORMAT_TIEBREAK = 0;
    private static final int STREAM_ID_COUNT = 2;
    private static final int STREAM_NUM_CLASSES = 2;
    private @NonNull ByteOrder byteOrder = ByteOrder.LITTLE_ENDIAN;
    private final @NonNull TIntSet counterIndexesZeroed = new TIntHashSet(10, 0.5f, -1);
    private final @NonNull TIntObjectMap<CounterSeriesAndPE> counterSerieses = new TIntObjectHashMap(10, 0.5f, -1);
    private int currentPid;
    private boolean invalidProtocolVersionDetected = false;
    private final @NonNull Map<@NonNull String, @NonNull StaticCounterSeriesKey> maliCountersByName;
    private final @NonNull IThrowingBiFunction<@NonNull IMidgardActivityParser, @Nullable MipeVersion, ? extends @NonNull IMaliProtocolDecoder, IOException> maliSWTraceSupplier;
    private @Nullable IMidgardActivityParser midgardActivityParser;
    private final @NonNull IntFunction<@NonNull IMidgardActivityParser> midgardActivitySupplier;
    private @Nullable MipeVersion mipeHwcPacketEncodingVersion;
    private @Nullable MipeVersion mipePacketEncodingVersion;
    private final @NonNull IExternalProtocolEventStream outputStream;
    private final @NonNull ProcessingElementReferenceSet peReferenceSet;
    private @Nullable MipeVersion protocolVersion;
    private final @Nullable IMaliProtocolDecoder @NonNull [] streamImplementations = new IMaliProtocolDecoder[4];
    private final long vmUID;

    static {
        byte[] byArray = new byte[8];
        byArray[0] = 71;
        byArray[1] = 80;
        byArray[2] = 85;
        byArray[3] = 49;
        byArray[4] = 24;
        GPU1_HEADER = byArray;
        MAX_MIPE_PACKET_ENCODING = MipeVersion.maxForMajor(1);
        MAX_NEW_FORMAT_TIEBREAK = MipeVersion.maxForMajor(5);
        MIN_MIPE_PACKET_ENCODING = MipeVersion.minForMajor(1);
        MIN_NEW_FORMAT_TIEBREAK = MipeVersion.minForMajor(5);
    }

    public static @NonNull Map<@NonNull String, @NonNull StaticCounterSeriesKey> createMaliCountersByName(@NonNull Collection<@NonNull StaticCounterSeriesKey> allStaticCounterSeries) {
        @NonNull HashMap<@NonNull String, @NonNull StaticCounterSeriesKey> result = new HashMap<String, StaticCounterSeriesKey>();
        for (StaticCounterSeriesKey counterSeriesKey : allStaticCounterSeries) {
            String counterName = counterSeriesKey.getCounterRecord().getCounter();
            if (counterName == null || !counterName.startsWith(MALI_COUNTER_PREFIX)) continue;
            result.put(counterName, counterSeriesKey);
        }
        return result;
    }

    public MipePacketVisitor(long vmUID, @NonNull ProcessingElementReferenceSet peReferenceSet, @NonNull Collection<@NonNull StaticCounterSeriesKey> allStaticCounterSeries, @NonNull IntFunction<@NonNull IMidgardActivityParser> midgardActivitySupplier, @NonNull IThrowingBiFunction<@NonNull IMidgardActivityParser, @Nullable MipeVersion, ? extends @NonNull IMaliProtocolDecoder, IOException> maliSWTraceSupplier, @NonNull IExternalProtocolEventStream outputStream) {
        this.vmUID = vmUID;
        this.peReferenceSet = peReferenceSet;
        this.midgardActivitySupplier = midgardActivitySupplier;
        this.maliSWTraceSupplier = maliSWTraceSupplier;
        this.outputStream = outputStream;
        this.maliCountersByName = MipePacketVisitor.createMaliCountersByName(allStaticCounterSeries);
    }

    public @NonNull ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public boolean isInvalidProtocolVersionDetected() {
        return this.invalidProtocolVersionDetected;
    }

    @Override
    public void visit(@NonNull MipePacket_Control_HW_Counter_Directory packet) throws IOException {
        TIntObjectIterator it = packet.counterNames.iterator();
        while (it.hasNext()) {
            it.advance();
            int index = it.key();
            String name = (String)it.value();
            String counterName = MALI_COUNTER_PREFIX + name;
            @Nullable StaticCounterSeriesKey counterSeriesKey = this.maliCountersByName.get(counterName);
            if (counterSeriesKey == null) continue;
            this.counterSerieses.put(index, (Object)new CounterSeriesAndPE(this.vmUID, (ICounterSeriesKey)counterSeriesKey, this.peReferenceSet));
        }
    }

    @Override
    public void visit(@NonNull MipePacket_Control_SharedParameter packet) throws IOException {
        MipeVersion protocolVersionObject;
        boolean isValidNewformatTiebreak;
        this.byteOrder = packet.header.getByteOrder();
        this.currentPid = packet.pid;
        int protocolVersion = packet.protocolVersion;
        @NonNull MipeVersion mipePacketEncodingVersion = packet.mipePacketEncodingVersion;
        @NonNull MipeVersion mipeHwcPacketEncodingVersion = packet.mipeHwcPacketEncodingVersion;
        boolean isValidOldFormatTiebreak = protocolVersion >= 0 && protocolVersion <= 4;
        boolean bl = isValidNewformatTiebreak = protocolVersion >= MIN_NEW_FORMAT_TIEBREAK.toInt() && protocolVersion <= MAX_NEW_FORMAT_TIEBREAK.toInt();
        if (!isValidOldFormatTiebreak && !isValidNewformatTiebreak) {
            this.invalidProtocolVersionDetected = true;
            this.outputStream.warning(WarningsFactory.unsupportedMaliTiebreak(protocolVersion, MipePacketVisitor.MAX_NEW_FORMAT_TIEBREAK.major));
            return;
        }
        if (mipePacketEncodingVersion.compareTo(MIN_MIPE_PACKET_ENCODING) < 0 || mipePacketEncodingVersion.compareTo(MAX_MIPE_PACKET_ENCODING) > 0) {
            this.invalidProtocolVersionDetected = true;
            this.outputStream.warning(WarningsFactory.unsupportedMaliTiebreak(mipePacketEncodingVersion.major, MipePacketVisitor.MAX_MIPE_PACKET_ENCODING.major));
            return;
        }
        if (mipeHwcPacketEncodingVersion.compareTo(MIN_MIPE_PACKET_ENCODING) < 0 || mipeHwcPacketEncodingVersion.compareTo(MAX_MIPE_PACKET_ENCODING) > 0) {
            this.invalidProtocolVersionDetected = true;
            this.outputStream.warning(WarningsFactory.unsupportedMaliTiebreak(mipeHwcPacketEncodingVersion.major, MipePacketVisitor.MAX_MIPE_PACKET_ENCODING.major));
            return;
        }
        this.protocolVersion = protocolVersionObject = MipeVersion.fromTiebreak(protocolVersion);
        this.mipePacketEncodingVersion = mipePacketEncodingVersion;
        this.mipeHwcPacketEncodingVersion = mipeHwcPacketEncodingVersion;
        HashMap<@NonNull String, @NonNull String> attributes = new HashMap<String, String>();
        MapUtils.putIfValueNotNull(attributes, (Object)ATTRIBUTE_MALI_INFO, (Object)packet.info);
        MapUtils.putIfValueNotNull(attributes, (Object)ATTRIBUTE_MALI_GPU_VERSION, (Object)packet.gpuVersion);
        MapUtils.putIfValueNotNull(attributes, (Object)ATTRIBUTE_MALI_DDK_VERSION, (Object)packet.ddkVersion);
        MapUtils.putIfValueNotNull(attributes, (Object)ATTRIBUTE_MALI_PROCESS_NAME, (Object)packet.processName);
        attributes.put(ATTRIBUTE_MALI_TIEBREAK, protocolVersion <= 4 ? String.valueOf(protocolVersion) : String.format("%d.%d.%d", protocolVersionObject.major, protocolVersionObject.minor, protocolVersionObject.patch));
        this.outputStream.attributes(this.vmUID, attributes);
    }

    @Override
    public void visit(@NonNull MipePacket_Huge_WinDump packet) throws IOException {
        long timestamp = packet.timestamp;
        byte[] imageData = new byte[GPU1_HEADER.length + 24 + packet.imageData.length];
        ByteBuffer byteBuffer = ByteBuffer.wrap(imageData);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.put(GPU1_HEADER);
        byteBuffer.putShort((short)packet.width);
        byteBuffer.putShort((short)packet.height);
        byteBuffer.putInt(packet.bpp & 0xFF);
        byteBuffer.putInt(packet.maskR);
        byteBuffer.putInt(packet.maskG);
        byteBuffer.putInt(packet.maskB);
        byteBuffer.putInt(packet.maskA);
        byteBuffer.put(packet.imageData);
        this.outputStream.annotationVisual(ClockSource.MONOTONIC_RAW, timestamp, new TaskId(this.currentPid), "", imageData);
    }

    @Override
    public void visit(@NonNull MipePacket_HW_Counter_Values packet) throws IOException {
        long timestamp = packet.timestamp;
        @Nullable TaskId taskId = new TaskId(this.currentPid);
        TIntIntIterator it = packet.counterValues.iterator();
        while (it.hasNext()) {
            it.advance();
            int index = it.key();
            int value = this.counterIndexesZeroed.add(index) ? 0 : it.value();
            CounterSeriesAndPE counterKey = (CounterSeriesAndPE)this.counterSerieses.get(index);
            if (counterKey == null) continue;
            this.outputStream.counter(counterKey.seriesKey, ClockSource.MONOTONIC_RAW, timestamp, counterKey.peReference, taskId, (long)value & 0xFFFFFFFFL);
        }
    }

    @Override
    public void visitTimeline(@NonNull MipeHeader header, byte @NonNull [] payloadData) throws IOException {
        int packetClass = header.getPacketClass();
        int packetType = header.getPacketType();
        int streamId = header.getImplSpec();
        int offset = packetClass * 2 + streamId;
        if (packetClass != 0 && packetClass != 1) {
            this.outputStream.warning(WarningsFactory.unsupportedMaliStreamId());
            return;
        }
        if (packetType != 0 && packetType != 1 && packetType != 2) {
            this.outputStream.warning(WarningsFactory.unsupportedMaliStreamId());
            return;
        }
        if (streamId != 0 && streamId != 1) {
            this.outputStream.warning(WarningsFactory.unsupportedMaliStreamId());
            return;
        }
        IMaliProtocolDecoder streamImplementation = this.streamImplementations[offset];
        if (streamImplementation == null) {
            IMidgardActivityParser midgardActivityParser = this.midgardActivityParser;
            if (midgardActivityParser == null) {
                this.midgardActivityParser = midgardActivityParser = this.midgardActivitySupplier.apply(this.currentPid);
            }
            if (packetClass == 0 && streamId == 0) {
                midgardActivityParser.gotCinstr();
            } else if (packetClass == 0 && streamId == 1) {
                midgardActivityParser.gotKbase();
            }
            this.streamImplementations[offset] = streamImplementation = (IMaliProtocolDecoder)this.maliSWTraceSupplier.apply((Object)midgardActivityParser, (Object)this.protocolVersion);
        }
        streamImplementation.process(payloadData);
    }

    private static final class CounterSeriesAndPE {
        public final @NonNull ProcessingElementReference peReference;
        public final @NonNull ICounterSeriesKey seriesKey;

        public CounterSeriesAndPE(long vmUID, @NonNull ICounterSeriesKey seriesKey, @NonNull ProcessingElementReferenceSet peReferenceSet) {
            this.seriesKey = seriesKey;
            this.peReference = peReferenceSet.get(seriesKey.getDeviceTypeOrDefault(), vmUID, 0);
        }
    }
}

