/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.capture.apc.protocol.external.mipe;

import com.arm.streamline.protocol.capture.apc.protocol.external.mipe.MipeHeader;
import com.arm.streamline.protocol.capture.apc.protocol.external.mipe.MipePacket_Control_HW_Counter_Directory;
import com.arm.streamline.protocol.capture.apc.protocol.external.mipe.MipePacket_Control_SharedParameter;
import com.arm.streamline.protocol.capture.apc.protocol.external.mipe.MipePacket_HW_Counter_Values;
import com.arm.streamline.protocol.capture.apc.protocol.external.mipe.MipePacket_Huge_WinDump;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public interface IMipePacketVisitor {
    public static void accept(@NonNull IMipePacketVisitor visitor, @NonNull MipeHeader header, byte @NonNull [] payloadData) throws IOException {
        if (header.getReserved0() != 0 || header.getReserved1() != 0) {
            return;
        }
        switch (header.getPacketFamily()) {
            case 0: {
                switch (header.getPacketId()) {
                    case 0: {
                        @Nullable MipePacket_Control_SharedParameter packet = MipePacket_Control_SharedParameter.create(header, payloadData);
                        if (packet != null) {
                            visitor.visit(packet);
                        }
                        return;
                    }
                    case 2: {
                        @NonNull MipePacket_Control_HW_Counter_Directory packet = MipePacket_Control_HW_Counter_Directory.create(header, payloadData);
                        visitor.visit(packet);
                        return;
                    }
                }
                return;
            }
            case 1: {
                visitor.visitTimeline(header, payloadData);
                return;
            }
            case 2: {
                if (header.getPacketClass() == 0 && header.getPacketType() == 0) {
                    if (header.getImplSpec() != 0) {
                        return;
                    }
                    @Nullable MipePacket_Huge_WinDump packet = MipePacket_Huge_WinDump.create(header, payloadData);
                    if (packet != null) {
                        visitor.visit(packet);
                    }
                    return;
                }
                return;
            }
            case 3: {
                if (header.getPacketClass() == 0 && header.getPacketType() == 0) {
                    if (header.getImplSpec() != 0) {
                        return;
                    }
                    @Nullable MipePacket_HW_Counter_Values packet = MipePacket_HW_Counter_Values.create(header, payloadData);
                    if (packet != null) {
                        visitor.visit(packet);
                    }
                    return;
                }
                return;
            }
        }
    }

    public void visit(@NonNull MipePacket_Control_HW_Counter_Directory var1) throws IOException;

    public void visit(@NonNull MipePacket_Control_SharedParameter var1) throws IOException;

    public void visit(@NonNull MipePacket_Huge_WinDump var1) throws IOException;

    public void visit(@NonNull MipePacket_HW_Counter_Values var1) throws IOException;

    public void visitTimeline(@NonNull MipeHeader var1, byte @NonNull [] var2) throws IOException;
}

