/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.capture.apc.protocol.external.armnn;

import com.arm.armnn.timeline.TimelineDecoderException;
import com.arm.streamline.protocol.capture.apc.protocol.external.armnn.Entity;
import com.arm.streamline.protocol.capture.apc.protocol.external.armnn.INetworkable;
import com.arm.streamline.protocol.capture.apc.protocol.external.armnn.ITrack;
import com.arm.streamline.protocol.capture.apc.protocol.external.armnn.ITrackable;
import com.arm.streamline.protocol.capture.apc.protocol.external.armnn.Network;
import com.arm.streamline.protocol.capture.apc.protocol.external.armnn.Track;
import com.arm.utils.NullChecking;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class Workload
extends Entity
implements INetworkable,
ITrackable {
    private @NonNull String backendId;
    private @Nullable Network network;

    public Workload(long guid, int trackId) {
        super(guid, trackId);
        this.trackId = trackId;
        this.backendId = "unknown";
        this.setName(String.format("workload:%s", this.backendId));
    }

    public void setBackendID(@NonNull String backendId) {
        this.backendId = backendId;
        this.setName(String.format("workload:%s", backendId));
    }

    @Override
    public @Nullable Network getNetwork() {
        return this.network;
    }

    @Override
    public void setNetwork(@NonNull Network network) {
        this.network = network;
    }

    @Override
    public @NonNull ITrack toTrack() {
        if (this.network == null) {
            throw new TimelineDecoderException(String.format("Workload(%d) must belong to a network before creating an ITrack", this.guid));
        }
        if (this.parent == null) {
            throw new TimelineDecoderException(String.format("Workload(%d) must have a parent before creating an ITrack", this.guid));
        }
        return new Track(((Network)NullChecking.neverNull((Object)this.network)).getTimestamp(), ((Network)NullChecking.neverNull((Object)this.network)).getTaskId(), ((Entity)NullChecking.neverNull((Object)this.parent)).getTrackId(), this.trackId, this.getName());
    }
}

