/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.capture.apc.protocol.external.armnn;

import com.arm.armnn.timeline.ITimelineConsumer;
import com.arm.armnn.timeline.TimelineDecoderException;
import com.arm.streamline.protocol.capture.apc.protocol.external.IExternalProtocolEventStream;
import com.arm.streamline.protocol.capture.apc.protocol.external.armnn.ArmNNCamViewBuilder;
import com.arm.streamline.protocol.capture.apc.protocol.external.armnn.CAMJobEntity;
import com.arm.streamline.protocol.capture.apc.protocol.external.armnn.Entity;
import com.arm.streamline.protocol.capture.apc.protocol.external.armnn.EntityType;
import com.arm.streamline.protocol.capture.apc.protocol.external.armnn.Event;
import com.arm.streamline.protocol.capture.apc.protocol.external.armnn.IExecutionEntity;
import com.arm.streamline.protocol.capture.apc.protocol.external.armnn.INetworkable;
import com.arm.streamline.protocol.capture.apc.protocol.external.armnn.ITrack;
import com.arm.streamline.protocol.capture.apc.protocol.external.armnn.ITrackable;
import com.arm.streamline.protocol.capture.apc.protocol.external.armnn.Inference;
import com.arm.streamline.protocol.capture.apc.protocol.external.armnn.JobStart;
import com.arm.streamline.protocol.capture.apc.protocol.external.armnn.Layer;
import com.arm.streamline.protocol.capture.apc.protocol.external.armnn.LayerJob;
import com.arm.streamline.protocol.capture.apc.protocol.external.armnn.Network;
import com.arm.streamline.protocol.capture.apc.protocol.external.armnn.Workload;
import com.arm.streamline.protocol.capture.apc.protocol.external.armnn.WorkloadExecution;
import com.arm.streamline.protocol.misc.TaskId;
import com.arm.utils.NullChecking;
import com.arm.utils.collections.Pair;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.TLongObjectMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class TimelineConsumer
implements ITimelineConsumer {
    private static final @NonNull String START_OF_LIFE = "start_of_life";
    private static final @NonNull String END_OF_LIFE = "end_of_life";
    private static final @NonNull String NAME = "name";
    private static final @NonNull String TYPE = "type";
    private static final @NonNull String BACKEND_ID = "backendId";
    private static final String PROCESS_ID = "processId";
    private static final @NonNull String CHILD = "child";
    private static final @NonNull String EXECUTION_OF = "execution_of";
    private static final @NonNull String CONNECTION = "connection";
    private static final boolean DEBUG = false;
    private final @NonNull TLongObjectMap<String> eventClasses = new TLongObjectHashMap();
    private final @NonNull TLongObjectMap<Event> events = new TLongObjectHashMap();
    private final @NonNull TLongObjectMap<String> labels = new TLongObjectHashMap();
    private final @NonNull ArmNNCamViewBuilder camViewBuilder;
    private static final AtomicInteger ID_GENERATOR = new AtomicInteger(10000);
    private static final int VIEW_UID = 9999;
    private final @NonNull TLongObjectHashMap<String> namesSentBeforeType = new TLongObjectHashMap();
    private final @NonNull TLongObjectMap<EntityType> entityTypes = new TLongObjectHashMap();
    private final @NonNull TLongObjectMap<Network> networks = new TLongObjectHashMap();
    private final @NonNull TLongObjectMap<Inference> inferences = new TLongObjectHashMap();
    private final @NonNull TLongObjectMap<Layer> layers = new TLongObjectHashMap();
    private final @NonNull TLongObjectMap<Workload> workloads = new TLongObjectHashMap();
    private final @NonNull TLongObjectMap<WorkloadExecution> workloadExecutions = new TLongObjectHashMap();

    public TimelineConsumer(@NonNull IExternalProtocolEventStream output) {
        this.camViewBuilder = new ArmNNCamViewBuilder(output, 9999);
    }

    public void createEntity(long guid) {
        this.entityTypes.put(guid, (Object)EntityType.UNKNOWN);
    }

    public void createEvent(long guid, long timestamp, long threadID) {
        this.events.put(guid, (Object)new Event(guid, timestamp, threadID));
    }

    public void createEventClass(long guid, long nameGuid) {
        String label = (String)this.labels.get(nameGuid);
        if (label == null) {
            throw new TimelineDecoderException("Missing label " + nameGuid);
        }
        this.eventClasses.put(guid, (Object)label);
    }

    public void createLabel(long guid, byte[] nameAsBytes) {
        String name = new String(nameAsBytes, StandardCharsets.UTF_8);
        this.labels.put(guid, (Object)name);
    }

    public void createRelationship(int relType, long guid, long headGuid, long tailGuid, long attributeGuid) {
        block0 : switch (Math.toIntExact(relType)) {
            case 2: {
                break;
            }
            case 1: {
                String eventClass;
                CAMJobEntity entity = this.getCamJobEntityFromAppropriateMap(headGuid);
                Event event = this.requireEvent(tailGuid);
                switch (eventClass = this.requireEventClass(attributeGuid)) {
                    case "start_of_life": {
                        if (entity != null) {
                            entity.setStartEvent(event);
                            this.camViewBuilder.drawJobStart(entity.toJobStart());
                            break;
                        }
                        @Nullable Network network = (Network)this.networks.get(headGuid);
                        if (network == null) break block0;
                        network.setStartEvent(event);
                        break;
                    }
                    case "end_of_life": {
                        if (entity != null) {
                            entity.setEndEvent(event);
                            this.camViewBuilder.drawJobStop(entity.toJobEnd());
                            Inference inference = (Inference)this.inferences.get(headGuid);
                            if (inference == null) break block0;
                            this.drawLayerJobsFor(inference);
                            break;
                        }
                        @Nullable Network network = (Network)this.networks.get(headGuid);
                        if (network == null) break block0;
                        this.removeNetworkEntitiesFromAppropriateMaps(network);
                        break;
                    }
                }
                break;
            }
            case 3: {
                String attribute;
                String label = this.requireLabel(tailGuid);
                switch (attribute = this.requireLabel(attributeGuid)) {
                    case "type": {
                        EntityType type = EntityType.getEntityType(label);
                        this.entityTypes.put(headGuid, (Object)type);
                        this.createEntityAndPutIntoMap(headGuid, type);
                        break;
                    }
                    case "name": {
                        this.assignNameToEntityIfItExists(headGuid, label);
                        break;
                    }
                    case "backendId": {
                        Workload workload = (Workload)this.workloads.get(headGuid);
                        if (workload == null) break block0;
                        workload.setBackendID(label);
                        break;
                    }
                    case "processId": {
                        Network network = (Network)this.networks.get(headGuid);
                        if (network == null) break block0;
                        int pid = Integer.parseInt(label);
                        network.setTaskId(new TaskId(pid, pid));
                        ITrack track = network.toTrack();
                        this.camViewBuilder.drawView(track.getTimestamp(), track.getTaskID());
                        this.camViewBuilder.drawTrack(track);
                        break;
                    }
                }
                break;
            }
            case 0: {
                String attribute;
                Entity entity = this.getEntityFromAppropriateMap(headGuid);
                Entity target = this.getEntityFromAppropriateMap(tailGuid);
                switch (attribute = this.requireLabel(attributeGuid)) {
                    case "child": {
                        if (entity == null || target == null) break block0;
                        entity.addChild(target);
                        target.setParent(entity);
                        this.realiseAndSetNetwork(headGuid, tailGuid);
                        ITrackable trackableTarget = this.getITrackableFromAppropriateMaps(tailGuid);
                        if (trackableTarget == null) break block0;
                        this.camViewBuilder.drawTrack(trackableTarget.toTrack());
                        break;
                    }
                    case "connection": {
                        this.handleConnection(headGuid, tailGuid);
                        break;
                    }
                    case "execution_of": {
                        if (entity == null || target == null) break block0;
                        IExecutionEntity executionOfEntity = this.getIExecutionEntityFromAppropriateMaps(tailGuid);
                        if (executionOfEntity != null) {
                            executionOfEntity.executionOf(entity);
                            executionOfEntity.updateTrackId(entity.getTrackId());
                        }
                        this.realiseAndSetNetwork(headGuid, tailGuid);
                        break;
                    }
                }
                break;
            }
            default: {
                throw new TimelineDecoderException(String.format("Unknown relationship type: %d", relType));
            }
        }
    }

    private void handleConnection(long headGuid, long tailGuid) {
        @Nullable Layer outputLayer = (Layer)this.layers.get(headGuid);
        if (outputLayer == null) {
            throw new TimelineDecoderException("Could not find a Layer object with headGuid " + headGuid + " while handling a connection relationship");
        }
        @Nullable Layer inputLayer = (Layer)this.layers.get(tailGuid);
        if (inputLayer == null) {
            throw new TimelineDecoderException("Could not find a Layer object with tailGuid " + tailGuid + " while handling a connection relationship");
        }
        inputLayer.addInput(outputLayer);
    }

    private void drawLayerJobsFor(@NonNull Inference inference) {
        List<Layer> layers = TimelineConsumer.findLayersForInference(inference);
        List<WorkloadExecution> executions = inference.workloadExecutions();
        ArrayList<Pair<Layer, Optional<LayerJob>>> layerPairs = TimelineConsumer.layerJobsToBeDrawn(inference, layers, executions);
        for (Pair pair : layerPairs) {
            if (!((Optional)pair.second).isPresent()) continue;
            TIntArrayList deps = TimelineConsumer.findDependenciesFor((Layer)pair.first, layerPairs);
            deps.add(inference.getJobID());
            this.camViewBuilder.drawLayerJob((LayerJob)((Optional)pair.second).get(), (int[])NullChecking.neverNull((Object)deps.toArray()));
            this.drawWorkloadExecutionDependencies((LayerJob)((Optional)pair.second).get());
        }
    }

    private void drawWorkloadExecutionDependencies(@NonNull LayerJob layerJob) {
        for (WorkloadExecution wexec : layerJob.getWorkloadExecutions()) {
            JobStart start = wexec.toJobStart();
            this.camViewBuilder.drawJobDependencies(start.getTaskID(), start.getTimestamp(), start.getJobID(), new int[]{layerJob.getJobID()});
        }
    }

    private static ArrayList<Pair<Layer, Optional<LayerJob>>> layerJobsToBeDrawn(Inference inference, List<Layer> layers, List<WorkloadExecution> executions) {
        ArrayList<Pair<Layer, Optional<LayerJob>>> layerPairs = new ArrayList<Pair<Layer, Optional<LayerJob>>>();
        for (Layer layer : layers) {
            List<Workload> workloads = layer.workloads();
            List<WorkloadExecution> wexecs = executions.stream().filter(e -> TimelineConsumer.isExecutionOfAtLeastOneWorkload(e, workloads)).collect(Collectors.toList());
            if (wexecs.size() > 0) {
                long startTime = TimelineConsumer.minStartTime(wexecs);
                long endTime = TimelineConsumer.maxEndTime(wexecs);
                Network network = inference.getNetwork();
                if (network == null) {
                    throw new TimelineDecoderException("network is not defined for inference " + String.valueOf(inference));
                }
                LayerJob job = new LayerJob(network.getTaskId(), layer.getTrackId(), ID_GENERATOR.getAndIncrement(), startTime, endTime, layer.getName(), wexecs);
                layerPairs.add((Pair<Layer, Optional<LayerJob>>)new Pair((Object)layer, Optional.of(job)));
                continue;
            }
            layerPairs.add((Pair<Layer, Optional<LayerJob>>)new Pair((Object)layer, Optional.empty()));
        }
        return layerPairs;
    }

    private static @NonNull TIntArrayList findDependenciesFor(Layer layer, List<Pair<Layer, Optional<LayerJob>>> layerPairs) {
        List<@NonNull Layer> inputs = layer.getInputs();
        TIntArrayList depJobIDs = new TIntArrayList();
        for (Layer input : inputs) {
            int jobID = TimelineConsumer.findJobIDFor(input.getGuid(), layerPairs);
            if (jobID < 0) continue;
            depJobIDs.add(jobID);
        }
        return depJobIDs;
    }

    private static int findJobIDFor(long layerGuid, List<Pair<Layer, Optional<LayerJob>>> layerPairs) {
        for (Pair<Layer, Optional<LayerJob>> pair : layerPairs) {
            if (((Layer)pair.first).getGuid() != layerGuid || !((Optional)pair.second).isPresent()) continue;
            return ((LayerJob)((Optional)pair.second).get()).getJobID();
        }
        return -1;
    }

    private static boolean isExecutionOfAtLeastOneWorkload(@NonNull WorkloadExecution e, @NonNull List<Workload> workloads) {
        return workloads.stream().anyMatch(w -> TimelineConsumer.isExecutionOfWorkload(e, w));
    }

    private static boolean isExecutionOfWorkload(@NonNull WorkloadExecution exec, @NonNull Workload workload) {
        Entity entity = exec.getExecutionOfEntity();
        if (entity instanceof Workload) {
            Workload w = (Workload)entity;
            return workload.getGuid() == w.getGuid();
        }
        return false;
    }

    private static @NonNull List<Layer> findLayersForInference(@NonNull Inference entity) {
        Network network = entity.getNetwork();
        if (network == null) {
            throw new TimelineDecoderException("unexpected null network for inference " + entity.getGuid());
        }
        return network.layers();
    }

    private static long minStartTime(@NonNull List<WorkloadExecution> executions) {
        long min = Long.MAX_VALUE;
        for (WorkloadExecution w : executions) {
            Event start = w.getStartEvent();
            if (start == null) {
                throw new TimelineDecoderException("workload execution " + String.valueOf(w) + " has no start event");
            }
            if (start.timestamp >= min) continue;
            min = start.timestamp;
        }
        return min;
    }

    private static long maxEndTime(@NonNull List<WorkloadExecution> executions) {
        long max = Long.MIN_VALUE;
        for (WorkloadExecution w : executions) {
            Event end = w.getEndEvent();
            if (end == null) {
                throw new TimelineDecoderException("workload execution " + String.valueOf(w) + " has no end event");
            }
            if (end.timestamp <= max) continue;
            max = end.timestamp;
        }
        return max;
    }

    private void removeNetworkEntitiesFromAppropriateMaps(Network network) {
        this.networks.remove(network.getGuid());
        this.entityTypes.remove(network.getGuid());
        this.removeNetworkFromMap(network, this.inferences);
        this.removeNetworkFromMap(network, this.layers);
        this.removeNetworkFromMap(network, this.workloads);
        this.removeNetworkFromMap(network, this.workloadExecutions);
    }

    private <T extends INetworkable> void removeNetworkFromMap(Network network, @NonNull TLongObjectMap<T> map) {
        HashSet setOfGuidsThatCorrespondWithNetwork = new HashSet();
        map.forEachEntry((key, value) -> {
            Network net = value.getNetwork();
            if (net != null && net.equals(network)) {
                setOfGuidsThatCorrespondWithNetwork.add(key);
            }
            return true;
        });
        setOfGuidsThatCorrespondWithNetwork.forEach(guid -> {
            map.remove(guid.longValue());
            this.entityTypes.remove(guid.longValue());
        });
    }

    private void realiseAndSetNetwork(long headGuid, long tailGuid) {
        INetworkable networkableEntity = this.getINetworkableFromAppropriateMaps(tailGuid);
        if (networkableEntity != null) {
            Network headNetwork = (Network)this.networks.get(headGuid);
            if (headNetwork != null) {
                networkableEntity.setNetwork(headNetwork);
            } else {
                Network parentOrExecutionNetwork;
                INetworkable networkableParentOrExecutionEntity = this.getINetworkableFromAppropriateMaps(headGuid);
                if (networkableParentOrExecutionEntity != null && (parentOrExecutionNetwork = networkableParentOrExecutionEntity.getNetwork()) != null) {
                    networkableEntity.setNetwork(parentOrExecutionNetwork);
                }
            }
        }
    }

    private @Nullable INetworkable getINetworkableFromAppropriateMaps(long guid) {
        EntityType type = (EntityType)((Object)this.entityTypes.get(guid));
        if (type == null) {
            return null;
        }
        switch (type) {
            case INFERENCE: {
                return (INetworkable)this.inferences.get(guid);
            }
            case LAYER: {
                return (INetworkable)this.layers.get(guid);
            }
            case WORKLOAD: {
                return (INetworkable)this.workloads.get(guid);
            }
            case WORKLOAD_EXECUTION: {
                return (INetworkable)this.workloadExecutions.get(guid);
            }
        }
        return null;
    }

    private @Nullable IExecutionEntity getIExecutionEntityFromAppropriateMaps(long guid) {
        EntityType type = (EntityType)((Object)this.entityTypes.get(guid));
        if (type == null) {
            return null;
        }
        switch (type) {
            case INFERENCE: {
                return (IExecutionEntity)this.inferences.get(guid);
            }
            case WORKLOAD_EXECUTION: {
                return (IExecutionEntity)this.workloadExecutions.get(guid);
            }
        }
        return null;
    }

    private @Nullable ITrackable getITrackableFromAppropriateMaps(long guid) {
        EntityType type = (EntityType)((Object)this.entityTypes.get(guid));
        if (type == null) {
            return null;
        }
        switch (type) {
            case NETWORK: {
                return (ITrackable)this.networks.get(guid);
            }
            case LAYER: {
                return (ITrackable)this.layers.get(guid);
            }
            case WORKLOAD: {
                return (ITrackable)this.workloads.get(guid);
            }
        }
        return null;
    }

    private @Nullable CAMJobEntity getCamJobEntityFromAppropriateMap(long guid) {
        EntityType type = (EntityType)((Object)this.entityTypes.get(guid));
        if (type == null) {
            return null;
        }
        switch (type) {
            case INFERENCE: {
                return (CAMJobEntity)this.inferences.get(guid);
            }
            case WORKLOAD_EXECUTION: {
                return (CAMJobEntity)this.workloadExecutions.get(guid);
            }
        }
        return null;
    }

    private @Nullable Entity getEntityFromAppropriateMap(long guid) {
        EntityType type = (EntityType)((Object)this.entityTypes.get(guid));
        if (type == null) {
            return null;
        }
        switch (type) {
            case NETWORK: {
                return (Entity)this.networks.get(guid);
            }
            case INFERENCE: {
                return (Entity)this.inferences.get(guid);
            }
            case LAYER: {
                return (Entity)this.layers.get(guid);
            }
            case WORKLOAD: {
                return (Entity)this.workloads.get(guid);
            }
            case WORKLOAD_EXECUTION: {
                return (Entity)this.workloadExecutions.get(guid);
            }
        }
        return null;
    }

    private void assignNameToEntityIfItExists(long headGuid, @NonNull String label) {
        Entity entity = this.getEntityFromAppropriateMap(headGuid);
        if (entity == null) {
            this.namesSentBeforeType.put(headGuid, (Object)label);
        } else {
            entity.setName(label);
        }
    }

    private void createEntityAndPutIntoMap(long headGuid, EntityType type) {
        @Nullable String potentialName = (String)this.namesSentBeforeType.remove(headGuid);
        switch (type) {
            case NETWORK: {
                Network network = new Network(headGuid, ID_GENERATOR.getAndIncrement());
                if (potentialName != null) {
                    network.setName(potentialName);
                }
                this.networks.put(headGuid, (Object)network);
                break;
            }
            case INFERENCE: {
                Inference inference = new Inference(headGuid, ID_GENERATOR.getAndIncrement());
                if (potentialName != null) {
                    inference.setName(potentialName);
                }
                this.inferences.put(headGuid, (Object)inference);
                break;
            }
            case LAYER: {
                Layer layer = new Layer(headGuid, ID_GENERATOR.getAndIncrement());
                if (potentialName != null) {
                    layer.setName(potentialName);
                }
                this.layers.put(headGuid, (Object)layer);
                break;
            }
            case WORKLOAD: {
                Workload workload = new Workload(headGuid, ID_GENERATOR.getAndIncrement());
                if (potentialName != null) {
                    workload.setName(potentialName);
                }
                this.workloads.put(headGuid, (Object)workload);
                break;
            }
            case WORKLOAD_EXECUTION: {
                WorkloadExecution workloadExe = new WorkloadExecution(headGuid, ID_GENERATOR.getAndIncrement());
                if (potentialName != null) {
                    workloadExe.setName(potentialName);
                }
                this.workloadExecutions.put(headGuid, (Object)workloadExe);
                break;
            }
        }
    }

    private @NonNull String requireLabel(long guid) {
        return TimelineConsumer.require(this.labels, guid, "Label");
    }

    private @NonNull String requireEventClass(long guid) {
        return TimelineConsumer.require(this.eventClasses, guid, "Eventclass");
    }

    private @NonNull Event requireEvent(long guid) {
        return TimelineConsumer.require(this.events, guid, "Event");
    }

    private static <T> @NonNull T require(@NonNull TLongObjectMap<T> map, long guid, @NonNull String label) {
        Object result = map.get(guid);
        if (result == null) {
            throw new TimelineDecoderException(String.format("Missing %s with GUID %d", label, guid));
        }
        return (T)result;
    }
}

