/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.capture.apc.protocol.external.armnn;

import com.arm.armnn.timeline.TimelineDecoderException;
import com.arm.streamline.protocol.capture.apc.protocol.external.armnn.Entity;
import com.arm.streamline.protocol.capture.apc.protocol.external.armnn.Event;
import com.arm.streamline.protocol.capture.apc.protocol.external.armnn.INetworkable;
import com.arm.streamline.protocol.capture.apc.protocol.external.armnn.IStartableEndable;
import com.arm.streamline.protocol.capture.apc.protocol.external.armnn.JobEnd;
import com.arm.streamline.protocol.capture.apc.protocol.external.armnn.JobStart;
import com.arm.streamline.protocol.capture.apc.protocol.external.armnn.Network;
import com.arm.utils.NullChecking;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class CAMJobEntity
extends Entity
implements IStartableEndable,
INetworkable {
    private @Nullable Event startEvent;
    private @Nullable Event endEvent;
    private final int jobId;
    private @Nullable Network network;

    public CAMJobEntity(long guid, int trackId, int jobId) {
        super(guid, trackId);
        this.jobId = jobId;
    }

    public int getJobID() {
        return this.jobId;
    }

    public @NonNull JobStart toJobStart() {
        if (this.network == null) {
            throw new TimelineDecoderException(String.format("CAMJobEntity(%d) must belong to a Network before starting a job", this.guid));
        }
        if (this.startEvent == null) {
            throw new TimelineDecoderException(String.format("CAMJobEntity(%d) must have a start Event before starting a job", this.guid));
        }
        return new JobStart(((Event)NullChecking.neverNull((Object)this.startEvent)).timestamp, ((Network)NullChecking.neverNull((Object)this.network)).getTaskId(), this.trackId, this.jobId, this.getName());
    }

    public @NonNull JobEnd toJobEnd() {
        if (this.network == null) {
            throw new TimelineDecoderException(String.format("CAMJobEntity(%d) must belong to a Network before ending a job", this.guid));
        }
        if (this.endEvent == null) {
            throw new TimelineDecoderException(String.format("CAMJobEntity(%d) must have an end Event before ending a job", this.guid));
        }
        return new JobEnd(((Event)NullChecking.neverNull((Object)this.endEvent)).timestamp, ((Network)NullChecking.neverNull((Object)this.network)).getTaskId(), this.jobId);
    }

    @Override
    public void setStartEvent(@NonNull Event event) {
        this.startEvent = event;
    }

    @Override
    public void setEndEvent(@NonNull Event event) {
        this.endEvent = event;
    }

    @Override
    public @Nullable Event getStartEvent() {
        return this.startEvent;
    }

    @Override
    public @Nullable Event getEndEvent() {
        return this.endEvent;
    }

    @Override
    public @Nullable Network getNetwork() {
        return this.network;
    }

    @Override
    public void setNetwork(@NonNull Network network) {
        this.network = network;
    }
}

