/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.capture.apc.protocol.external;

import com.arm.streamline.analysis.model.ICounterSeriesKey;
import com.arm.streamline.common.model.topology.DeviceType;
import com.arm.streamline.common.model.topology.ProcessingElementReference;
import com.arm.streamline.common.model.topology.ProcessingElementReferenceSet;
import com.arm.streamline.protocol.capture.apc.pass_two.IExternalProtocolPassTwoEventStream;
import com.arm.streamline.protocol.capture.apc.pass_two.IGatorPassTwoEventStream;
import com.arm.streamline.protocol.capture.apc.protocol.external.IExternalProtocolEventStream;
import com.arm.streamline.protocol.capture.apc.protocol.external.IExternalProtocolPassTwoState;
import com.arm.streamline.protocol.capture.apc.time.ClockSource;
import com.arm.streamline.protocol.misc.TaskId;
import com.arm.utils.function.IObjIntBiFunction;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class FTraceCommon {
    public static final long CPU_FREQ_STATE_MULTIPLIER = 1000L;
    public static final @NonNull String ARG_CPU_ID = "cpu_id";
    public static final @NonNull String ARG_STATE = "state";
    public static final @NonNull String FORMAT_CPU_FREQUENCY = "cpu_frequency";
    public static final @NonNull String POWER__CPU_FREQUENCY = "power/cpu_frequency";
    private final @NonNull IFtraceCommonEventStream outputStream;
    private final @NonNull IObjIntBiFunction<@NonNull DeviceType, @NonNull ProcessingElementReference> mapPeReference;

    public FTraceCommon(@NonNull IExternalProtocolPassTwoState passTwoState, @NonNull IExternalProtocolEventStream outputStream) {
        this((IObjIntBiFunction<DeviceType, ProcessingElementReference>)((IObjIntBiFunction)passTwoState::mapPeReference), IFtraceCommonEventStream.wrap(outputStream));
    }

    public FTraceCommon(long vmUID, @NonNull ProcessingElementReferenceSet processingElements, @NonNull IGatorPassTwoEventStream outputStream) {
        this((IObjIntBiFunction<DeviceType, ProcessingElementReference>)((IObjIntBiFunction)(t, n) -> processingElements.get(t, vmUID, n)), IFtraceCommonEventStream.wrap(outputStream));
    }

    public FTraceCommon(@NonNull IObjIntBiFunction<@NonNull DeviceType, @NonNull ProcessingElementReference> mapPeReference, @NonNull IFtraceCommonEventStream outputStream) {
        this.mapPeReference = mapPeReference;
        this.outputStream = outputStream;
    }

    public void onCpuFrequency(@NonNull ICounterSeriesKey counterSeriesKey, long time, int cpuId, int state) throws IOException {
        this.outputStream.counter(counterSeriesKey, time, (ProcessingElementReference)this.mapPeReference.apply((Object)counterSeriesKey.getDeviceTypeOrDefault(), cpuId), null, (long)state * 1000L);
    }

    public static interface IFtraceCommonEventStream {
        public void counter(@NonNull ICounterSeriesKey var1, long var2, @NonNull ProcessingElementReference var4, @Nullable TaskId var5, long var6) throws IOException;

        public static @NonNull IFtraceCommonEventStream wrap(final @NonNull IExternalProtocolEventStream outputStream) {
            return new IFtraceCommonEventStream(){

                @Override
                public void counter(@NonNull ICounterSeriesKey counterKey, long timestamp, @NonNull ProcessingElementReference peReference, @Nullable TaskId taskId, long value) throws IOException {
                    outputStream.counter(counterKey, ClockSource.MONOTONIC_RAW, timestamp, peReference, taskId, value);
                }
            };
        }

        public static @NonNull IFtraceCommonEventStream wrap(final @NonNull IExternalProtocolPassTwoEventStream outputStream) {
            return new IFtraceCommonEventStream(){

                @Override
                public void counter(@NonNull ICounterSeriesKey counterKey, long timestamp, @NonNull ProcessingElementReference peReference, @Nullable TaskId taskId, long value) throws IOException {
                    outputStream.counter(counterKey, timestamp, peReference, taskId, value);
                }
            };
        }
    }
}

