/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.capture.apc.protocol.external;

import com.arm.armnn.timeline.TimelineDecoder;
import com.arm.streamline.common.CommonPlugin;
import com.arm.streamline.protocol.capture.apc.pass_two.warnings.WarningsFactory;
import com.arm.streamline.protocol.capture.apc.protocol.external.EStateAnnotateV1;
import com.arm.streamline.protocol.capture.apc.protocol.external.EStateArmNNV1;
import com.arm.streamline.protocol.capture.apc.protocol.external.EStateFtraceV1;
import com.arm.streamline.protocol.capture.apc.protocol.external.EStateFtraceV2;
import com.arm.streamline.protocol.capture.apc.protocol.external.EStateMali;
import com.arm.streamline.protocol.capture.apc.protocol.external.EStateMaliEncapsulated;
import com.arm.streamline.protocol.capture.apc.protocol.external.EStateMaliSWTrace;
import com.arm.streamline.protocol.capture.apc.protocol.external.ExternalProtocolChannel;
import com.arm.streamline.protocol.capture.apc.protocol.external.IExternalProtocolDecoder;
import com.arm.streamline.protocol.capture.apc.protocol.external.IExternalProtocolEventStream;
import com.arm.streamline.protocol.capture.apc.protocol.external.IExternalProtocolPassTwoState;
import com.arm.streamline.protocol.capture.apc.protocol.external.IMaliProtocolDecoder;
import com.arm.streamline.protocol.capture.apc.protocol.external.IMidgardActivityParser;
import com.arm.streamline.protocol.capture.apc.protocol.external.MidgardActivityParser;
import com.arm.streamline.protocol.capture.apc.protocol.external.mipe.MipeVersion;
import com.arm.utils.function.IThrowingBiFunction;
import com.arm.utils.function.IThrowingLongFunction;
import java.io.IOException;
import java.util.function.IntFunction;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ExternalProtocols {
    public static @Nullable IExternalProtocolDecoder get(@NonNull ExternalProtocolChannel channel, @NonNull IThrowingLongFunction<@NonNull IExternalProtocolPassTwoState, IOException> stateProvider, @NonNull IThrowingLongFunction<@NonNull IExternalProtocolEventStream, IOException> outputProvider, boolean liveMode, boolean isAtraceEnabled) throws IOException {
        @NonNull IExternalProtocolPassTwoState vmState = (IExternalProtocolPassTwoState)stateProvider.apply(channel.vmUID);
        @NonNull IExternalProtocolEventStream outputStream = (IExternalProtocolEventStream)outputProvider.apply(channel.vmUID);
        @NonNull String PERFETTO_PROTOCOL = "PERFETTO";
        @NonNull String GPU_TIMELINE_PROTOCOL = "MALI_GPU_TIMELINE";
        switch (channel.channelName) {
            case "MALI_GRAPHICS 1": {
                return new EStateMali(channel, new EStateMaliImplementationFactory(), vmState, outputStream);
            }
            case "ANNOTATE 1": 
            case "ANNOTATE 2": 
            case "ANNOTATE 3": 
            case "ANNOTATE 4": 
            case "ANNOTATE 5": {
                return new EStateAnnotateV1(channel, vmState, outputStream);
            }
            case "ARMNN_V1": {
                if (liveMode) {
                    return null;
                }
                if (!TimelineDecoder.INITIALIZED_LIBRARY) {
                    CommonPlugin.warning((String)"A problem occurred loading the ArmNN decoder JNI library.");
                    return null;
                }
                return new EStateArmNNV1(vmState, outputStream);
            }
            case "FTRACE 1": {
                return new EStateFtraceV1(channel, vmState, outputStream, isAtraceEnabled);
            }
            case "FTRACE 2": {
                if (liveMode) {
                    return null;
                }
                return new EStateFtraceV2(channel, vmState, outputStream, isAtraceEnabled);
            }
            case "MALI_GPU_TIMELINE": 
            case "PERFETTO": {
                return null;
            }
        }
        outputStream.warning(WarningsFactory.unsupportedExternalProtocol(channel.channelName));
        return null;
    }

    private static final class EStateMaliImplementationFactory
    implements EStateMali.IEStateMaliImplementationFactory {
        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Override
        public @NonNull IMaliProtocolDecoder createMaliEncapsulatedProtocol(@NonNull ExternalProtocolChannel channel, @NonNull IExternalProtocolPassTwoState passTwoState, @NonNull IExternalProtocolEventStream outputStream) {
            @NonNull IntFunction<@NonNull IMidgardActivityParser> midgardActivitySupplier = pid -> new MidgardActivityParser(externalProtocolChannel.vmUID, pid, passTwoState, outputStream);
            @NonNull @NonNull @Nullable @NonNull IThrowingBiFunction maliSWTraceSupplier = (midgardActivityParser, protocolVersion) -> new EStateMaliSWTrace(outputStream, (MipeVersion)protocolVersion, (IMidgardActivityParser)midgardActivityParser, passTwoState.getOrCreateMaliOpenClCAMGenerator(outputStream));
            return new EStateMaliEncapsulated(channel, passTwoState, outputStream, midgardActivitySupplier, (IThrowingBiFunction<IMidgardActivityParser, MipeVersion, EStateMaliSWTrace, IOException>)maliSWTraceSupplier);
        }

        @Override
        public @NonNull IMaliProtocolDecoder createMaliSWTraceProtocol(@NonNull ExternalProtocolChannel channel, @NonNull IExternalProtocolPassTwoState passTwoState, @NonNull IExternalProtocolEventStream outputStream) throws IOException {
            return new EStateMaliSWTrace(outputStream, null, new NullMidgardActivityParser(), passTwoState.getOrCreateMaliOpenClCAMGenerator(outputStream));
        }

        private static final class NullMidgardActivityParser
        implements IMidgardActivityParser {
            @Override
            public void cinstrContextAddNr(long timestamp, long ctx, long ctxNr) throws IOException {
                assert (false);
            }

            @Override
            public void cinstrDeleteAtom(long timestamp, long atom) throws IOException {
                assert (false);
            }

            @Override
            public void cinstrDeleteContext(long timestamp, long ctx) throws IOException {
                assert (false);
            }

            @Override
            public void cinstrNewAtom(long timestamp, long atom, long atomNr) throws IOException {
                assert (false);
            }

            @Override
            public void cinstrNewContext(long timestamp, long ctx) throws IOException {
                assert (false);
            }

            @Override
            public void cinstrRetainAtomContext(long timestamp, long atom, long ctx) throws IOException {
                assert (false);
            }

            @Override
            public void cinstrUnretainAtomContext(long timestamp, long atom, long ctx) throws IOException {
                assert (false);
            }

            @Override
            public void gotCinstr() {
                assert (false);
            }

            @Override
            public void gotKbase() {
                assert (false);
            }

            @Override
            public void kbaseDeleteAtom(long timestamp, long atom) throws IOException {
                assert (false);
            }

            @Override
            public void kbaseDeleteContext(long timestamp, long ctx) throws IOException {
                assert (false);
            }

            @Override
            public void kbaseNewAtom(long timestamp, long atom, long atomNr) throws IOException {
                assert (false);
            }

            @Override
            public void kbaseNewContext(long timestamp, long ctx, long ctxNr) throws IOException {
                assert (false);
            }

            @Override
            public void kbaseNewJobSlot(long timestamp, long lpu, long lpuNr, long lpuFn) throws IOException {
                assert (false);
            }

            @Override
            public void kbaseRetainAtomContext(long timestamp, long atom, long ctx) throws IOException {
                assert (false);
            }

            @Override
            public void kbaseRetainAtomJobSlot(long timestamp, long atom, long lpu, String attribMatchList) throws IOException {
                assert (false);
            }

            @Override
            public void kbaseUnretainAtomContext(long timestamp, long atom, long ctx) throws IOException {
                assert (false);
            }

            @Override
            public void kbaseUnretainAtomJobSlot(long timestamp, long atom, long lpu) throws IOException {
                assert (false);
            }
        }
    }
}

