/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.capture.apc.protocol.external;

import com.arm.streamline.protocol.capture.apc.protocol.external.EStateMaliSWTrace;
import com.arm.streamline.protocol.capture.apc.protocol.external.ExternalProtocolChannel;
import com.arm.streamline.protocol.capture.apc.protocol.external.IExternalProtocolEventStream;
import com.arm.streamline.protocol.capture.apc.protocol.external.IExternalProtocolPassTwoState;
import com.arm.streamline.protocol.capture.apc.protocol.external.IMaliProtocolDecoder;
import com.arm.streamline.protocol.capture.apc.protocol.external.IMidgardActivityParser;
import com.arm.streamline.protocol.capture.apc.protocol.external.mipe.IMipePacketVisitor;
import com.arm.streamline.protocol.capture.apc.protocol.external.mipe.MipeHeader;
import com.arm.streamline.protocol.capture.apc.protocol.external.mipe.MipePacketBuffer;
import com.arm.streamline.protocol.capture.apc.protocol.external.mipe.MipePacketVisitor;
import com.arm.streamline.protocol.capture.apc.protocol.external.mipe.MipeVersion;
import com.arm.utils.function.IThrowingBiFunction;
import java.io.IOException;
import java.util.function.IntFunction;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class EStateMaliEncapsulated
implements IMaliProtocolDecoder {
    private final @NonNull MipePacketBuffer buffer = new MipePacketBuffer();
    private final @NonNull MipePacketVisitor packetVisitor;

    public EStateMaliEncapsulated(@NonNull ExternalProtocolChannel channel, @NonNull IExternalProtocolPassTwoState passTwoState, @NonNull IExternalProtocolEventStream outputStream, @NonNull IntFunction<@NonNull IMidgardActivityParser> midgardActivitySupplier, @NonNull IThrowingBiFunction<@NonNull IMidgardActivityParser, @Nullable MipeVersion, @NonNull EStateMaliSWTrace, IOException> maliSWTraceSupplier) {
        this.packetVisitor = new MipePacketVisitor(channel.vmUID, passTwoState.getPeReferenceSet(), passTwoState.getStaticCounterSeries().getAllStaticCounterSeries(), midgardActivitySupplier, maliSWTraceSupplier, outputStream);
    }

    @Override
    public void process(byte @NonNull [] data) throws IOException {
        if (!this.packetVisitor.isInvalidProtocolVersionDetected()) {
            this.buffer.mergeBuffers(data);
            while (!this.packetVisitor.isInvalidProtocolVersionDetected()) {
                int payloadSize;
                int headerSize;
                byte[] payloadData;
                @Nullable MipeHeader header = MipeHeader.create(this.packetVisitor.getByteOrder(), this.buffer.data());
                if (header == null || (payloadData = this.buffer.removePacket(headerSize = header.size(), payloadSize = header.getDataLength())) == null) break;
                IMipePacketVisitor.accept(this.packetVisitor, header, payloadData);
            }
        }
    }
}

