/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.capture.apc.protocol.external;

import com.arm.streamline.protocol.capture.apc.pass_two.warnings.WarningsFactory;
import com.arm.streamline.protocol.capture.apc.protocol.external.ExternalProtocolChannel;
import com.arm.streamline.protocol.capture.apc.protocol.external.IExternalProtocolDecoder;
import com.arm.streamline.protocol.capture.apc.protocol.external.IExternalProtocolEventStream;
import com.arm.streamline.protocol.capture.apc.protocol.external.IExternalProtocolPassTwoState;
import com.arm.streamline.protocol.capture.apc.protocol.external.IMaliProtocolDecoder;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class EStateMali
implements IExternalProtocolDecoder {
    public static final String PROTOCOL = "MALI_GRAPHICS 1";
    private final @NonNull ExternalProtocolChannel channel;
    private final @NonNull IEStateMaliImplementationFactory factory;
    private @Nullable IMaliProtocolDecoder implementation;
    private final @NonNull IExternalProtocolEventStream outputStream;
    private final @NonNull IExternalProtocolPassTwoState passTwoState;

    public EStateMali(@NonNull ExternalProtocolChannel channel, @NonNull IEStateMaliImplementationFactory factory, @NonNull IExternalProtocolPassTwoState passTwoState, @NonNull IExternalProtocolEventStream outputStream) {
        this.channel = channel;
        this.factory = factory;
        this.passTwoState = passTwoState;
        this.outputStream = outputStream;
    }

    @Override
    public void process(byte @NonNull [] data) throws IOException {
        IMaliProtocolDecoder implementation = this.implementation;
        if (implementation == null && data.length > 0) {
            int version = data[0] & 0xFF;
            switch (version) {
                case 0: {
                    this.implementation = implementation = this.factory.createMaliEncapsulatedProtocol(this.channel, this.passTwoState, this.outputStream);
                    break;
                }
                case 3: {
                    this.implementation = implementation = this.factory.createMaliSWTraceProtocol(this.channel, this.passTwoState, this.outputStream);
                    break;
                }
                default: {
                    this.implementation = implementation = d -> {};
                    this.outputStream.warning(WarningsFactory.unsupportedMaliProtocol(version));
                }
            }
        }
        if (implementation != null) {
            implementation.process(data);
        }
    }

    @Override
    public boolean reorderable() {
        return false;
    }

    @Override
    public void close() throws IOException {
    }

    public static interface IEStateMaliImplementationFactory {
        public @NonNull IMaliProtocolDecoder createMaliEncapsulatedProtocol(@NonNull ExternalProtocolChannel var1, @NonNull IExternalProtocolPassTwoState var2, @NonNull IExternalProtocolEventStream var3);

        public @NonNull IMaliProtocolDecoder createMaliSWTraceProtocol(@NonNull ExternalProtocolChannel var1, @NonNull IExternalProtocolPassTwoState var2, @NonNull IExternalProtocolEventStream var3) throws IOException;
    }
}

