/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.capture.apc.pass_two.event_queue;

import com.arm.streamline.protocol.capture.apc.pass_two.IGatorPassTwoEventStream;
import com.arm.streamline.protocol.capture.apc.pass_two.event_queue.APCEventQueue;
import com.arm.streamline.protocol.capture.apc.pass_two.event_queue.GatorPassTwoQueueingEventStream;
import com.arm.streamline.protocol.capture.apc.time.ITimestampMapper;
import com.arm.streamline.protocol.misc.event_queue.IFlushableEventQueue;
import com.arm.utils.function.IThrowingLongFunction;
import gnu.trove.map.TLongObjectMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.LongSupplier;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class APCEventQueues
implements IFlushableEventQueue {
    private final @NonNull List<@NonNull IFlushableEventQueue> allFlushables = new ArrayList<IFlushableEventQueue>();
    private final @NonNull LongSupplier ordinalSupplier;
    private final @NonNull IThrowingLongFunction<@NonNull IGatorPassTwoEventStream, IOException> outputStreamSupplier;
    private final @NonNull TLongObjectMap<GatorPassTwoQueueingEventStream> perVmQueueStreams = new TLongObjectHashMap();
    private final @Nullable IFlushableEventQueue finalQueue;

    public APCEventQueues(@Nullable IFlushableEventQueue finalQueue, @NonNull IThrowingLongFunction<@NonNull IGatorPassTwoEventStream, IOException> outputStreamSupplier) {
        this.finalQueue = finalQueue;
        this.outputStreamSupplier = outputStreamSupplier;
        this.ordinalSupplier = new LongSupplier(){
            private long o;

            @Override
            public long getAsLong() {
                return this.o++;
            }
        };
    }

    @Override
    public void flushAll() throws IOException {
        @Nullable IFlushableEventQueue finalQueue = this.finalQueue;
        for (IFlushableEventQueue eventQueue : this.allFlushables) {
            eventQueue.flushAll();
        }
        if (finalQueue != null) {
            finalQueue.flushAll();
        }
    }

    @Override
    public long flushUpTo(long timestamp) throws IOException {
        @Nullable IFlushableEventQueue finalQueue = this.finalQueue;
        long lastFlushedTimestamp = timestamp;
        for (IFlushableEventQueue eventQueue : this.allFlushables) {
            long result = eventQueue.flushUpTo(timestamp);
            lastFlushedTimestamp = ITimestampMapper.min(lastFlushedTimestamp, result);
        }
        if (finalQueue != null) {
            return finalQueue.flushUpTo(lastFlushedTimestamp);
        }
        return lastFlushedTimestamp;
    }

    public @NonNull IGatorPassTwoEventStream getQueueingEventStreamFor(long vmUID) throws IOException {
        return this.getPerVmQueueStream(vmUID);
    }

    private @NonNull GatorPassTwoQueueingEventStream getPerVmQueueStream(long vmUID) throws IOException {
        GatorPassTwoQueueingEventStream result = (GatorPassTwoQueueingEventStream)this.perVmQueueStreams.get(vmUID);
        if (result == null) {
            @NonNull IGatorPassTwoEventStream outputStream = (IGatorPassTwoEventStream)this.outputStreamSupplier.apply(vmUID);
            @NonNull APCEventQueue eventQueue = new APCEventQueue(outputStream);
            result = new GatorPassTwoQueueingEventStream(outputStream, eventQueue, this.ordinalSupplier);
            this.perVmQueueStreams.put(vmUID, (Object)result);
            this.allFlushables.add(eventQueue);
        }
        return result;
    }
}

