/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.capture.apc.pass_two.cam;

import com.arm.streamline.analysis.model.threads.IUniqueThread;
import com.arm.streamline.protocol.capture.apc.pass_two.cam.ICAMViewUIDMapper;
import com.arm.utils.NullChecking;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class CAMViewUIDMapper
implements ICAMViewUIDMapper {
    private final @NonNull TObjectIntMap<Key> mappedValues = new TObjectIntHashMap(10, 0.5f, -1);

    private static @Nullable IUniqueThread getProcessThread(@NonNull IUniqueThread uniqueThread) {
        @Nullable IUniqueThread processThread = uniqueThread.getProcessThread();
        return (IUniqueThread)NullChecking.neverNullOr((Object)processThread, (Object)uniqueThread);
    }

    @Override
    public int map(int viewUID) {
        return this.map(new Key(viewUID, null));
    }

    @Override
    public int map(@NonNull IUniqueThread uniqueThread, int viewUID) {
        return this.map(new Key(viewUID, CAMViewUIDMapper.getProcessThread(uniqueThread)));
    }

    private int map(@NonNull Key key) {
        return this.mappedValues.adjustOrPutValue((Object)key, 0, this.mappedValues.size() + 1);
    }

    private static final class Key {
        public final @Nullable IUniqueThread processThread;
        public final int viewUID;

        public Key(int viewUID, @Nullable IUniqueThread processThread) {
            this.viewUID = viewUID;
            this.processThread = processThread;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return false;
            }
            if (obj instanceof Key) {
                Key that = (Key)obj;
                return this.viewUID == that.viewUID && NullChecking.equalsNullable((Object)this.processThread, (Object)that.processThread);
            }
            return false;
        }

        public int hashCode() {
            return this.viewUID + NullChecking.hashNullable((Object)this.processThread) * 31;
        }
    }
}

