/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.capture.apc.pass_two;

import com.arm.streamline.analysis.model.threads.ExecutablePathMapping;
import com.arm.streamline.analysis.model.threads.IExecutablePath;
import com.arm.streamline.protocol.capture.apc.pass_two.IUniqueThreadTracker;
import com.arm.utils.NullChecking;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.ToIntFunction;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class LinuxThreadTrackerUniqueThread
implements IUniqueThreadTracker.ITrackedUniqueThread {
    private static final int COMM_LENGTH = 15;
    private static final @NonNull String PRE_INITIALIZED = "<pre-initialized>";
    private @Nullable Long endTimestamp;
    private @Nullable IExecutablePath executablePath;
    private final long firstSeen;
    private long lastSeen;
    private final @NonNull List<@NonNull ExecutablePathMapping> mmaps = new ArrayList<ExecutablePathMapping>(0);
    private boolean mmapsSinceComm;
    private @Nullable String name;
    private @Nullable LinuxThreadTrackerUniqueThread processThread;
    private @Nullable Long startTimestamp;
    private final int tid;
    private boolean tracked;
    private final int uid;
    private final long vmUID;

    public LinuxThreadTrackerUniqueThread(long vmUID, long timestamp, @NonNull ToIntFunction<@NonNull IUniqueThreadTracker.ITrackedUniqueThread> uidSupplier, int tid) {
        assert (tid >= 0);
        this.vmUID = vmUID;
        this.uid = uidSupplier.applyAsInt(this);
        this.firstSeen = timestamp;
        this.lastSeen = timestamp;
        this.tracked = false;
        this.mmapsSinceComm = true;
        this.tid = tid;
        if (tid == 0) {
            this.setProcess(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof LinuxThreadTrackerUniqueThread) {
            LinuxThreadTrackerUniqueThread that = (LinuxThreadTrackerUniqueThread)obj;
            return this.uid == that.uid && this.tid == that.tid && this.tracked == that.tracked && this.lastSeen == that.lastSeen && this.firstSeen == that.firstSeen && NullChecking.equalsNullable((Object)this.startTimestamp, (Object)that.startTimestamp) && NullChecking.equalsNullable((Object)this.endTimestamp, (Object)that.endTimestamp) && NullChecking.equalsNullable((Object)this.processThread, (Object)that.processThread) && NullChecking.equalsNullable((Object)this.name, (Object)that.name) && NullChecking.equalsNullable((Object)this.executablePath, (Object)that.executablePath);
        }
        return false;
    }

    public @Nullable ExecutablePathMapping findMMapping(long address) {
        @Nullable LinuxThreadTrackerUniqueThread processThread = this.getProcessThread();
        @NonNull List<@NonNull ExecutablePathMapping> mmaps = processThread != null ? processThread.mmaps : this.mmaps;
        return ExecutablePathMapping.findMMapping(mmaps, (long)address);
    }

    public long getEarliestSeenTimestamp() {
        return this.firstSeen;
    }

    public @Nullable Long getEndTimestamp() {
        return this.endTimestamp;
    }

    public @Nullable IExecutablePath getExecutablePath() {
        @Nullable LinuxThreadTrackerUniqueThread processThread = this.processThread;
        if (processThread == null) {
            return null;
        }
        if (this == processThread) {
            return this.isKernel() ? IExecutablePath.KERNEL : this.executablePath;
        }
        return processThread.getExecutablePath();
    }

    public long getLastSeenTimestamp() {
        return this.lastSeen;
    }

    public @NonNull List<@NonNull ExecutablePathMapping> getMMaps() {
        return Collections.unmodifiableList(this.mmaps);
    }

    public @Nullable String getName() {
        @Nullable String name = this.name;
        if (name != null) {
            return name;
        }
        @Nullable IExecutablePath executablePath = this.getExecutablePath();
        if (this.isProcessThread() && executablePath != null) {
            return executablePath.getBaseName();
        }
        return null;
    }

    public int getOriginalID() {
        return this.tid;
    }

    @Override
    public @Nullable LinuxThreadTrackerUniqueThread getProcessThread() {
        return this.processThread;
    }

    public @Nullable Long getStartTimestamp() {
        return this.startTimestamp;
    }

    public int getUID() {
        return this.uid;
    }

    public long getVmUID() {
        return this.vmUID;
    }

    public int hashCode() {
        return this.uid;
    }

    public boolean isIdle() {
        return this.tid == 0;
    }

    public boolean isIgnored() {
        return !this.tracked;
    }

    public boolean isKernel() {
        @Nullable LinuxThreadTrackerUniqueThread processThread = this.processThread;
        if (this.tid == 0) {
            assert (this == processThread || processThread == null);
            return true;
        }
        if (this == processThread || processThread == null) {
            return false;
        }
        return processThread.isKernel();
    }

    public boolean isProcessThread() {
        return this == this.processThread;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void mmap(long fileOffset, long mapAddress, long length, @NonNull IExecutablePath executablePath) {
        if (!LinuxThreadTrackerUniqueThread.$assertionsDisabled && !this.isProcessThread()) {
            throw new AssertionError();
        }
        if (length == 0L) {
            return;
        }
        name = this.name;
        if (!this.mmapsSinceComm && name != null && executablePath.getBaseName().startsWith(this.name)) {
            this.mmaps.clear();
            this.setExecutablePath(executablePath);
        }
        this.mmapsSinceComm = true;
        endAddress = mapAddress + length - 1L;
        newMapping = new ExecutablePathMapping(executablePath, fileOffset, mapAddress, length);
        index = 0;
        ** GOTO lbl70
        {
            mapping = this.mmaps.get(index);
            if (mapping.mapAddress == mapAddress && mapping.length == length) {
                this.mmaps.set(index, newMapping);
                return;
            }
            containsStart = mapping.contains(mapAddress);
            containsEnd = mapping.contains(endAddress);
            if (containsEnd < 0) {
                this.mmaps.add(index, newMapping);
                return;
            }
            if (containsStart > 0) ** GOTO lbl69
            if (containsStart < 0 && containsEnd > 0) {
                this.mmaps.remove(index);
            } else if (containsStart == 0) {
                if (containsEnd == 0) {
                    endAddressOffset = endAddress - mapping.mapAddress + 1L;
                    headLength = mapAddress - mapping.mapAddress;
                    tailLength = mapping.length - endAddressOffset;
                    tailOffset = endAddressOffset + mapping.fileOffset;
                    this.mmaps.remove(index);
                    if (headLength != 0L) {
                        this.mmaps.add(index, new ExecutablePathMapping(mapping.executablePath, mapping.fileOffset, mapping.mapAddress, headLength));
                        ++index;
                    }
                    this.mmaps.add(index, newMapping);
                    ++index;
                    if (tailLength != 0L) {
                        this.mmaps.add(index, new ExecutablePathMapping(mapping.executablePath, tailOffset, endAddress + 1L, tailLength));
                    }
                    return;
                }
                if (!LinuxThreadTrackerUniqueThread.$assertionsDisabled && containsEnd <= 0) {
                    throw new AssertionError();
                }
                headLength = mapAddress - mapping.mapAddress;
                if (headLength != 0L) {
                    this.mmaps.set(index, new ExecutablePathMapping(mapping.executablePath, mapping.fileOffset, mapping.mapAddress, headLength));
                } else {
                    this.mmaps.remove(index);
                }
            } else {
                if (containsEnd == 0) {
                    if (!LinuxThreadTrackerUniqueThread.$assertionsDisabled && containsStart >= 0) {
                        throw new AssertionError();
                    }
                    endAddressOffset = endAddress - mapping.mapAddress + 1L;
                    tailLength = mapping.length - endAddressOffset;
                    tailOffset = endAddressOffset + mapping.fileOffset;
                    this.mmaps.set(index, newMapping);
                    if (tailLength != 0L) {
                        this.mmaps.add(index + 1, new ExecutablePathMapping(mapping.executablePath, tailOffset, endAddress + 1L, tailLength));
                    }
                    return;
                }
                throw new AssertionError();
            }
            do {
                if (index < this.mmaps.size()) continue block0;
lbl69:
                // 2 sources

                ++index;
lbl70:
                // 2 sources

            } while (index < this.mmaps.size());
        }
        this.mmaps.add(newMapping);
    }

    public String toString() {
        @Nullable LinuxThreadTrackerUniqueThread processThread = this.processThread;
        return String.format("UniqueThread [uid=%s.%s, tid=%s.%s, name=%s, tracked=%s, firstSeen=%s, lastSeen=%s, startTimestamp=%s, endTimestamp=%s, executablePath=%s]", processThread != null ? Integer.valueOf(processThread.uid) : "?", this.uid, processThread != null ? Integer.valueOf(processThread.tid) : "?", this.tid, this.getName(), this.tracked, this.firstSeen, this.lastSeen, this.startTimestamp, this.endTimestamp, this.executablePath);
    }

    protected void fork(long timestamp, @Nullable LinuxThreadTrackerUniqueThread parentThread) {
        this.startTimestamp = timestamp;
        if (parentThread != null) {
            if (this.name == null) {
                this.name = parentThread.getName();
            }
            if (this.isProcessThread()) {
                @NonNull LinuxThreadTrackerUniqueThread parentProcessThread = (LinuxThreadTrackerUniqueThread)NullChecking.neverNullOr((Object)parentThread.getProcessThread(), (Object)parentThread);
                this.setExecutablePath(parentProcessThread.executablePath);
                this.mmaps.clear();
                this.mmaps.addAll(parentProcessThread.mmaps);
            }
        }
    }

    protected boolean isFreed(long timestamp) {
        @Nullable Long endTimestamp = this.endTimestamp;
        if (endTimestamp == null) {
            return false;
        }
        long endTimestampValue = endTimestamp;
        if (endTimestampValue <= -1L && timestamp > -1L) {
            return true;
        }
        if (endTimestampValue <= -1L && timestamp <= -1L) {
            return false;
        }
        long delta = timestamp - endTimestampValue;
        return timestamp > endTimestampValue && delta >= 1000000000L;
    }

    protected void setExecutablePath(@Nullable IExecutablePath executablePath) {
        assert (!this.isKernel());
        assert (this.isProcessThread());
        if (executablePath != null) {
            String pkg = executablePath.extractAndroidPackageName();
            String baseName = executablePath.getBaseName();
            if (pkg != null && (baseName.contentEquals(PRE_INITIALIZED) || pkg.contentEquals(baseName))) {
                executablePath = IExecutablePath.createFromPath((String)pkg);
            }
        }
        this.executablePath = executablePath;
        @Nullable String name = this.name;
        if (name != null && executablePath != null && (executablePath.isAbstractPath() || name.length() >= 15) && (executablePath.getBaseName().endsWith(name) || PRE_INITIALIZED.endsWith(name))) {
            this.name = executablePath.getBaseName();
            this.mmapsSinceComm = false;
        }
    }

    protected void setFree(long timestamp) {
        assert (timestamp >= this.lastSeen);
        this.endTimestamp = timestamp;
    }

    protected void setName(@NonNull String name, boolean exec) {
        boolean executablePathIsFullName;
        IExecutablePath executablePath = this.getExecutablePath();
        boolean bl = executablePathIsFullName = executablePath != null && (executablePath.isAbstractPath() || name.length() >= 15) && executablePath.getBaseName().endsWith(name);
        if (!executablePathIsFullName && this.name != null && this.name.endsWith("re-initialized>")) {
            this.executablePath = IExecutablePath.createFromPath((String)name);
        }
        if (executablePathIsFullName) {
            assert (executablePath != null);
            this.name = executablePath.getBaseName();
        } else {
            this.name = name;
        }
        if (exec) {
            assert (this.isProcessThread());
            this.mmaps.clear();
            this.executablePath = null;
        }
        this.mmapsSinceComm = false;
    }

    protected void setProcess(@NonNull LinuxThreadTrackerUniqueThread processThread) {
        assert (processThread.isProcessThread() || processThread == this || processThread.isKernel());
        this.processThread = processThread.isProcessThread() || processThread == this ? processThread : processThread.getProcessThread();
    }

    protected void setTracked() {
        this.tracked = true;
    }

    protected void updateSeen(long timestamp) {
        this.lastSeen = timestamp;
    }
}

