/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.capture.apc.pass_two;

import com.arm.streamline.analysis.database.api.profiling.IBacktraceSource;
import com.arm.streamline.analysis.model.ICounterSeriesKey;
import com.arm.streamline.common.model.topology.DeviceType;
import com.arm.streamline.common.model.topology.ProcessingElementReference;
import com.arm.streamline.common.model.topology.ProcessingElementReferenceSet;
import com.arm.streamline.ftrace.TracepointFormat;
import com.arm.streamline.perf.records.EventAttribute;
import com.arm.streamline.protocol.capture.apc.io.APCFrameAddress;
import com.arm.streamline.protocol.capture.apc.pass_two.IGatorPassTwoEventStream;
import com.arm.streamline.protocol.capture.apc.protocol.IGatorPerVirtualMachineProtocolEventConsumer;
import com.arm.streamline.protocol.capture.apc.protocol.perf.IPerfDataBufferEventConsumer;
import com.arm.streamline.protocol.capture.apc.protocol.perf.IPerfDataBufferPassProcessor;
import com.arm.streamline.protocol.capture.apc.protocol.perf.IPerfProtocolState;
import com.arm.streamline.protocol.capture.apc.time.ClockSource;
import com.arm.streamline.protocol.capture.apc.time.ITimestampMapper;
import com.arm.streamline.protocol.misc.TaskId;
import com.arm.streamline.report.model.pe.ProcessingElementTopology;
import java.io.IOException;
import java.util.Map;
import java.util.function.IntFunction;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class GatorPassTwoPerVirtualMachineProtocolEventConsumer
implements IGatorPerVirtualMachineProtocolEventConsumer {
    protected final @NonNull IntFunction<@Nullable ICounterSeriesKey> counterSeriesFunction;
    protected final @NonNull IGatorPassTwoEventStream output;
    protected final @NonNull ProcessingElementReferenceSet peReferenceSet;
    protected final @NonNull IPerfProtocolState perfAttributesState;
    protected final @NonNull IPerfDataBufferPassProcessor perfDataBufferPassProcessor;
    protected final @NonNull IPerfDataBufferEventConsumer<@NonNull APCFrameAddress> perfDataBufferPassTwoEventConsumer;
    protected final @NonNull ITimestampMapper timestampMapper;
    protected final long vmUID;

    public GatorPassTwoPerVirtualMachineProtocolEventConsumer(long vmUID, @NonNull ProcessingElementReferenceSet peReferenceSet, @NonNull IntFunction<@Nullable ICounterSeriesKey> counterSeriesFunction, @NonNull ITimestampMapper timestampMapper, @NonNull IPerfProtocolState perfAttributesState, @NonNull IPerfDataBufferPassProcessor perfDataBufferPassProcessor, @NonNull IPerfDataBufferEventConsumer<@NonNull APCFrameAddress> perfDataBufferPassTwoEventConsumer, @NonNull IGatorPassTwoEventStream output) {
        this.vmUID = vmUID;
        this.peReferenceSet = peReferenceSet;
        this.counterSeriesFunction = counterSeriesFunction;
        this.timestampMapper = timestampMapper;
        this.perfAttributesState = perfAttributesState;
        this.perfDataBufferPassProcessor = perfDataBufferPassProcessor;
        this.perfDataBufferPassTwoEventConsumer = perfDataBufferPassTwoEventConsumer;
        this.output = output;
    }

    @Override
    public void absoluteBacktrace(@NonNull APCFrameAddress address, @NonNull ClockSource clockSource, long rawTimestamp, IBacktraceSource backtraceSource, int deviceNumber, @NonNull TaskId taskId, long @NonNull [] addresses) throws IOException {
        long mappedTimestamp = this.timestampMapper.mapTimestamp(clockSource, rawTimestamp);
        this.output.absoluteBacktrace(mappedTimestamp, backtraceSource, this.mapDeviceNumberAndType(DeviceType.CPU, deviceNumber), taskId, addresses);
    }

    @Override
    public void activityStop(@NonNull APCFrameAddress address, @NonNull ClockSource clockSource, long rawTimestamp, int deviceNumber, int key, @Nullable TaskId taskId, int activity) throws IOException {
        @Nullable ICounterSeriesKey counterSeriesKey = this.counterSeriesFunction.apply(key);
        if (counterSeriesKey != null) {
            long mappedTimestamp = this.timestampMapper.mapTimestamp(clockSource, rawTimestamp);
            @NonNull ProcessingElementReference peReference = this.mapDeviceNumberAndType(counterSeriesKey.getDeviceTypeOrDefault(), deviceNumber);
            this.output.activityStop(counterSeriesKey, mappedTimestamp, peReference, taskId, activity);
        }
    }

    @Override
    public void activitySwitch(@NonNull APCFrameAddress address, @NonNull ClockSource clockSource, long rawTimestamp, int deviceNumber, int key, @Nullable TaskId taskId, int activity, int userStateValue) throws IOException {
        @Nullable ICounterSeriesKey counterSeriesKey = this.counterSeriesFunction.apply(key);
        if (counterSeriesKey != null) {
            long mappedTimestamp = this.timestampMapper.mapTimestamp(clockSource, rawTimestamp);
            @NonNull ProcessingElementReference peReference = this.mapDeviceNumberAndType(counterSeriesKey.getDeviceTypeOrDefault(), deviceNumber);
            this.output.activitySwitch(counterSeriesKey, mappedTimestamp, peReference, taskId, activity, userStateValue);
        }
    }

    @Override
    public void addPerfEventAttributeByKey(int key, @NonNull EventAttribute attribute) throws IOException {
    }

    @Override
    public void addPerfEventAttributeIdToKeyMapping(long id, int key) throws IOException {
    }

    @Override
    public void captureProperties(long wallClockTime, long bootTime, long monotonicTime, boolean nosync, @NonNull Map<@NonNull String, @NonNull String> attributes) throws IOException {
    }

    @Override
    public void cookie(@NonNull APCFrameAddress address, int cookieUID, @NonNull String value) throws IOException {
    }

    @Override
    public void counter(@NonNull APCFrameAddress address, @NonNull ClockSource clockSource, long rawTimestamp, @Nullable Integer deviceNumber, @Nullable TaskId taskId, int key, long value) throws IOException {
        @Nullable ICounterSeriesKey counterSeriesKey = this.counterSeriesFunction.apply(key);
        if (counterSeriesKey != null) {
            long mappedTimestamp = this.timestampMapper.mapTimestamp(clockSource, rawTimestamp);
            @NonNull ProcessingElementReference peReference = this.mapCounterSeriesDeviceNumberAndType(deviceNumber, counterSeriesKey);
            this.output.counter(counterSeriesKey, mappedTimestamp, peReference, taskId, value);
        }
    }

    @Override
    public void externalClosed(int fd) throws IOException {
        assert (false);
    }

    @Override
    public void externalData(@NonNull APCFrameAddress address, int fd, int loadOffset, byte @NonNull [] data) throws IOException {
        assert (false);
    }

    @Override
    public void externalFrame(@NonNull APCFrameAddress address, long uid, int fd, @NonNull String channelName, int offset, byte @NonNull [] data) throws IOException {
        assert (false);
    }

    @Override
    public @Nullable EventAttribute getPerfEventAttributeByKey(int key) {
        return this.perfAttributesState.getPerfEventAttributeByKey(key);
    }

    @Override
    public void idle(@NonNull APCFrameAddress address, @NonNull ClockSource clockSource, long rawTimestamp, int deviceNumber, boolean online) throws IOException {
        long mappedTimestamp = this.timestampMapper.mapTimestamp(clockSource, rawTimestamp);
        this.output.idle(mappedTimestamp, this.mapDeviceNumberAndType(DeviceType.CPU, deviceNumber), online);
    }

    @Override
    public void kAllSyms(@NonNull String kallsyms) throws IOException {
    }

    @Override
    public void metadata(@NonNull APCFrameAddress address, int key, @NonNull String value) throws IOException {
    }

    @Override
    public void perfAuxBuffer(@NonNull APCFrameAddress address, int cpu, long offset, byte @NonNull [] data) throws IOException {
    }

    @Override
    public void perfDataBuffer(@NonNull APCFrameAddress address, int deviceNumber, byte @NonNull [] data) throws IOException {
        this.perfDataBufferPassProcessor.processRecords(address, deviceNumber, data, this.perfDataBufferPassTwoEventConsumer);
    }

    @Override
    public void perfSpeSyncEvent(int deviceNumber, long monotonicRaw, long archClockCount, long archClockFreq) throws IOException {
    }

    @Override
    public void processingElementProperties(int deviceNumber, int identifierCode, @NonNull String name, @Nullable ProcessingElementTopology processingElementTopology) throws IOException {
    }

    @Override
    public void schedSwitch(@NonNull APCFrameAddress address, @NonNull ClockSource clockSource, long rawTimestamp, int deviceNumber, @NonNull TaskId nextTaskId, @NonNull IGatorPerVirtualMachineProtocolEventConsumer.SchedulerSwitchReason reason) throws IOException {
        long mappedTimestamp = this.timestampMapper.mapTimestamp(clockSource, rawTimestamp);
        this.output.schedSwitch(mappedTimestamp, this.mapDeviceNumberAndType(DeviceType.CPU, deviceNumber), nextTaskId, reason);
    }

    @Override
    public void threadExec(@NonNull APCFrameAddress address, @NonNull ClockSource clockSource, long rawTimestamp, @Nullable TaskId oldTaskId, @NonNull TaskId taskId, int cookieUID) throws IOException {
        long mappedTimestamp = this.timestampMapper.mapTimestamp(clockSource, rawTimestamp);
        this.output.threadExec(mappedTimestamp, oldTaskId, taskId, cookieUID);
    }

    @Override
    public void threadExit(@NonNull APCFrameAddress address, @NonNull ClockSource clockSource, long rawTimestamp, @NonNull TaskId taskId) throws IOException {
        long mappedTimestamp = this.timestampMapper.mapTimestamp(clockSource, rawTimestamp);
        this.output.threadExit(mappedTimestamp, taskId);
    }

    @Override
    public void threadFork(@NonNull APCFrameAddress address, @NonNull ClockSource clockSource, long rawTimestamp, @Nullable TaskId parentTaskId, @NonNull TaskId taskId) throws IOException {
        long mappedTimestamp = this.timestampMapper.mapTimestamp(clockSource, rawTimestamp);
        this.output.threadFork(mappedTimestamp, parentTaskId, taskId);
    }

    @Override
    public void threadLinkCookie(@NonNull APCFrameAddress address, @NonNull ClockSource clockSource, long rawTimestamp, @NonNull TaskId taskId, int cookieUID) throws IOException {
        long mappedTimestamp = this.timestampMapper.mapTimestamp(clockSource, rawTimestamp);
        this.output.threadLinkCookie(mappedTimestamp, taskId, cookieUID);
    }

    @Override
    public void threadMaps(@NonNull APCFrameAddress address, @NonNull ClockSource clockSource, long rawTimestamp, @NonNull TaskId taskId, @NonNull String maps) throws IOException {
        long mappedTimestamp = this.timestampMapper.mapTimestamp(clockSource, rawTimestamp);
        this.output.threadMaps(mappedTimestamp, taskId, maps);
    }

    @Override
    public void threadMMap(@NonNull APCFrameAddress address, @NonNull ClockSource clockSource, long rawTimestamp, @NonNull TaskId taskId, long fileOffset, long mapAddress, long length, @NonNull String filename) throws IOException {
        long mappedTimestamp = this.timestampMapper.mapTimestamp(clockSource, rawTimestamp);
        this.output.threadMMap(mappedTimestamp, taskId, fileOffset, mapAddress, length, filename);
    }

    @Override
    public void threadProperties(@NonNull APCFrameAddress address, @NonNull ClockSource clockSource, long rawTimestamp, @Nullable TaskId parentTaskId, @NonNull TaskId taskId, @NonNull String name, @NonNull String exePath, @Nullable String linuxProcMapsContents) throws IOException {
        long mappedTimestamp = this.timestampMapper.mapTimestamp(clockSource, rawTimestamp);
        this.output.threadProperties(mappedTimestamp, parentTaskId, taskId, name, exePath, linuxProcMapsContents);
    }

    @Override
    public void threadRename(@NonNull APCFrameAddress address, @NonNull ClockSource clockSource, long rawTimestamp, @NonNull TaskId taskId, @NonNull String name, boolean exec) throws IOException {
        long mappedTimestamp = this.timestampMapper.mapTimestamp(clockSource, rawTimestamp);
        this.output.threadRename(mappedTimestamp, taskId, name, exec);
    }

    @Override
    public void timesyncEvent(long monotonicDelta, long localClock) {
    }

    @Override
    public void tracepointFormat(@NonNull TracepointFormat tracepointFormat) throws IOException {
    }

    @Override
    public void warning(long timestamp, @NonNull TaskId taskId, @NonNull String text) throws IOException {
        this.output.annotationMarker(timestamp, taskId, text);
    }

    private @NonNull ProcessingElementReference mapCounterSeriesDeviceNumberAndType(@Nullable Integer deviceNumber, @NonNull ICounterSeriesKey counterSeriesKey) {
        @NonNull DeviceType counterDeviceType = counterSeriesKey.getDeviceTypeOrDefault();
        if (deviceNumber != null) {
            return this.mapDeviceNumberAndType(counterDeviceType, deviceNumber);
        }
        assert (!counterDeviceType.supportsMultipleCores());
        return this.mapDeviceNumberAndType(counterDeviceType, 0);
    }

    private final @NonNull ProcessingElementReference mapDeviceNumberAndType(@NonNull DeviceType deviceType, int deviceNumber) {
        return this.peReferenceSet.get(deviceType, this.vmUID, deviceNumber);
    }
}

