/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.capture.apc.pass_two;

import com.arm.streamline.common.analysis.model.AnnotationColour;
import com.arm.streamline.common.model.topology.DeviceType;
import com.arm.streamline.common.model.topology.ProcessingElementReference;
import com.arm.streamline.common.model.topology.ProcessingElementReferenceSet;
import com.arm.streamline.ftrace.TracepointFormat;
import com.arm.streamline.protocol.capture.apc.protocol.external.IExternalProtocolEventStream;
import com.arm.streamline.protocol.capture.apc.protocol.external.IExternalProtocolPassTwoState;
import com.arm.streamline.protocol.capture.apc.protocol.external.IMaliOpenCLCAMGenerator;
import com.arm.streamline.protocol.capture.apc.protocol.external.MaliOpenCLCAMGenerator;
import com.arm.streamline.protocol.capture.apc.protocol.perf.IPerfProtocolState;
import com.arm.streamline.protocol.capture.apc.time.ITimestampMapper;
import com.arm.streamline.protocol.misc.StaticCounterSerieses;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class ExternalProtocolPassTwoState
implements IExternalProtocolPassTwoState {
    private @Nullable IMaliOpenCLCAMGenerator maliOpenCLCAMGenerator;
    private final @NonNull ProcessingElementReferenceSet peReferenceSet;
    private final @NonNull IPerfProtocolState perfProtocolStateTracker;
    private final @NonNull StaticCounterSerieses staticCounterSerieses;
    private final @NonNull TIntObjectMap<AnnotationColour> textColours = new TIntObjectHashMap(10, 0.5f, 0);
    private final @NonNull ITimestampMapper timestampMapper;
    private final long vmUID;

    public ExternalProtocolPassTwoState(@NonNull ExternalProtocolPassTwoState that) {
        this.vmUID = that.vmUID;
        this.timestampMapper = that.timestampMapper;
        this.perfProtocolStateTracker = that.perfProtocolStateTracker;
        this.peReferenceSet = that.peReferenceSet;
        this.staticCounterSerieses = that.staticCounterSerieses;
    }

    public ExternalProtocolPassTwoState(long vmUID, @NonNull ITimestampMapper timestampMapper, @NonNull IPerfProtocolState perfProtocolStateTracker, @NonNull ProcessingElementReferenceSet peReferenceSet, @NonNull StaticCounterSerieses staticCounterSerieses) {
        this.vmUID = vmUID;
        this.timestampMapper = timestampMapper;
        this.perfProtocolStateTracker = perfProtocolStateTracker;
        this.peReferenceSet = peReferenceSet;
        this.staticCounterSerieses = staticCounterSerieses;
    }

    public void close() throws IOException {
        @Nullable IMaliOpenCLCAMGenerator maliOpenCLCAMGenerator = this.maliOpenCLCAMGenerator;
        if (maliOpenCLCAMGenerator != null) {
            maliOpenCLCAMGenerator.close();
        }
    }

    @Override
    public @Nullable IMaliOpenCLCAMGenerator getMaliOpenClCAMGenerator() {
        return this.maliOpenCLCAMGenerator;
    }

    @Override
    public @NonNull IMaliOpenCLCAMGenerator getOrCreateMaliOpenClCAMGenerator(@NonNull IExternalProtocolEventStream outputStream) throws IOException {
        IMaliOpenCLCAMGenerator maliOpenCLCAMGenerator = this.maliOpenCLCAMGenerator;
        if (maliOpenCLCAMGenerator == null) {
            this.maliOpenCLCAMGenerator = maliOpenCLCAMGenerator = new MaliOpenCLCAMGenerator(outputStream);
        }
        return maliOpenCLCAMGenerator;
    }

    @Override
    public @NonNull ProcessingElementReferenceSet getPeReferenceSet() {
        return this.peReferenceSet;
    }

    @Override
    public @NonNull StaticCounterSerieses getStaticCounterSeries() {
        return this.staticCounterSerieses;
    }

    @Override
    public @NonNull ProcessingElementReference getSystemWideProcessingElementReference() {
        return this.peReferenceSet.get(DeviceType.SYSTEM_WIDE, this.vmUID, 0);
    }

    @Override
    public @NonNull ITimestampMapper getTimestampMapper() {
        return this.timestampMapper;
    }

    @Override
    public @Nullable TracepointFormat getTracepointFormat(int id) {
        return this.perfProtocolStateTracker.getTracepointFormat(id);
    }

    @Override
    public @NonNull ProcessingElementReference mapPeReference(@NonNull DeviceType deviceType, int cpuNumber) {
        return this.peReferenceSet.get(deviceType, this.vmUID, cpuNumber);
    }

    @Override
    public @NonNull AnnotationColour mapTextToAnnotationColour(@NonNull String text) {
        int hashCode = text.hashCode();
        AnnotationColour color = (AnnotationColour)this.textColours.get(hashCode);
        if (color == null) {
            color = new AnnotationColour(0xFF000000 | AnnotationColour.DARK_COLOR_PALETTE[this.textColours.size() % AnnotationColour.DARK_COLOR_PALETTE.length]);
            this.textColours.put(hashCode, (Object)color);
        }
        return color;
    }
}

