/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.capture.apc.pass_two;

import com.arm.streamline.protocol.capture.apc.index.APCFrameAddressWithVmUIDAndTimestamp;
import com.arm.streamline.protocol.capture.apc.io.APCFrameAddress;
import com.arm.streamline.protocol.capture.apc.pass_two.ExternalAPCFrameAddress;
import com.arm.streamline.protocol.capture.apc.pass_two.IExternalProtocolFrameConsumer;
import com.arm.streamline.protocol.capture.apc.protocol.external.ExternalProtocolChannel;
import com.arm.streamline.protocol.capture.apc.protocol.external.IExternalProtocolDecoder;
import com.arm.streamline.protocol.capture.apc.time.ITimestampMapper;
import com.arm.streamline.protocol.misc.event_queue.IFlushableEventQueue;
import com.arm.utils.function.IThrowingConsumer;
import com.arm.utils.function.IThrowingFunction;
import com.arm.utils.function.Throwing;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class APCFrameRecordReloader {
    protected final @NonNull IExternalProtocolFrameConsumer externalConsumer;
    protected final @NonNull IThrowingConsumer<@NonNull APCFrameAddress, IOException> frameConsumer;
    private final @NonNull SortedMap<@NonNull ExternalProtocolChannel, @NonNull ExternalAPCFrameAddress @NonNull []> externalFrames;
    private final @NonNull IThrowingFunction<@NonNull ExternalProtocolChannel, @Nullable IExternalProtocolDecoder, IOException> externalProtocolProvider;
    private final @NonNull IFlushableEventQueue flushable;
    private final @NonNull List<@NonNull APCFrameAddressWithVmUIDAndTimestamp> normalIndex;

    public APCFrameRecordReloader(@NonNull IThrowingConsumer<@NonNull APCFrameAddress, IOException> frameConsumer, @NonNull IThrowingFunction<@NonNull ExternalProtocolChannel, @Nullable IExternalProtocolDecoder, IOException> externalProtocolProvider, @NonNull IExternalProtocolFrameConsumer externalConsumer, @NonNull List<@NonNull APCFrameAddressWithVmUIDAndTimestamp> normalIndex, @NonNull SortedMap<@NonNull ExternalProtocolChannel, @NonNull ExternalAPCFrameAddress @NonNull []> externalFrames, @NonNull IFlushableEventQueue flushable) {
        this.frameConsumer = frameConsumer;
        this.externalProtocolProvider = externalProtocolProvider;
        this.externalConsumer = externalConsumer;
        this.normalIndex = normalIndex;
        this.externalFrames = externalFrames;
        this.flushable = flushable;
    }

    public void run() throws IOException {
        Throwing.closeAlways(closer -> {
            ArrayList<@NonNull IChannelProcessor> channelLoaders = new ArrayList<IChannelProcessor>();
            channelLoaders.add(new PrimaryChannelProcessor(this.normalIndex));
            for (Map.Entry<ExternalProtocolChannel, ExternalAPCFrameAddress[]> entry : this.externalFrames.entrySet()) {
                @NonNull ExternalProtocolChannel channel = entry.getKey();
                @NonNull List<@NonNull ExternalAPCFrameAddress> list = Arrays.asList(entry.getValue());
                @Nullable IExternalProtocolDecoder externalProtocol = (IExternalProtocolDecoder)closer.trackIfNotNull((Closeable)((IExternalProtocolDecoder)this.externalProtocolProvider.apply((Object)channel)));
                if (externalProtocol == null) continue;
                channelLoaders.add(new ExternalProtocolChannelProcessor(channel, externalProtocol, list));
            }
            long lastFlushTimestamp = -1L;
            while (!channelLoaders.isEmpty()) {
                long earliestLastTimestamp = Long.MAX_VALUE;
                IChannelProcessor earliestChannelLoader = null;
                for (IChannelProcessor channelLoader : channelLoaders) {
                    long channelTimestamp = channelLoader.getLastFlushableTimestamp();
                    if (earliestChannelLoader != null && ITimestampMapper.compare(earliestLastTimestamp, channelTimestamp) <= 0) continue;
                    earliestLastTimestamp = channelTimestamp;
                    earliestChannelLoader = channelLoader;
                }
                assert (earliestChannelLoader != null);
                if (!earliestChannelLoader.flushNext()) {
                    channelLoaders.remove(earliestChannelLoader);
                }
                lastFlushTimestamp = ITimestampMapper.max(lastFlushTimestamp, earliestLastTimestamp);
                this.flushable.flushUpTo(lastFlushTimestamp);
            }
            this.flushable.flushAll();
            return null;
        });
    }

    private final class ExternalProtocolChannelProcessor
    implements IChannelProcessor {
        private final @NonNull ExternalProtocolChannel channel;
        private final @NonNull IExternalProtocolDecoder decoder;
        private final @NonNull Iterator<@NonNull ExternalAPCFrameAddress> iterator;
        private ExternalAPCFrameAddress nextItem = null;

        public ExternalProtocolChannelProcessor(@NonNull ExternalProtocolChannel channel, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @NonNull @NonNull IExternalProtocolDecoder decoder, List<ExternalAPCFrameAddress> frameList) {
            this.channel = channel;
            this.decoder = decoder;
            this.iterator = frameList.iterator();
            this.next();
        }

        private void next() {
            this.nextItem = this.iterator.hasNext() ? this.iterator.next() : null;
        }

        @Override
        public boolean flushNext() throws IOException {
            if (this.nextItem != null) {
                @NonNull ExternalAPCFrameAddress externalFrameAddress = this.nextItem;
                long lastTimestamp = externalFrameAddress.earliestTimestamp;
                APCFrameRecordReloader.this.externalConsumer.process(externalFrameAddress.address, this.decoder);
                assert (ITimestampMapper.compare(lastTimestamp, externalFrameAddress.latestTimestamp) <= 0) : String.valueOf(this.channel) + ", " + externalFrameAddress.latestTimestamp + " vs " + lastTimestamp;
                this.next();
            }
            return this.nextItem != null;
        }

        @Override
        public long getLastFlushableTimestamp() {
            return this.nextItem != null ? this.nextItem.earliestTimestamp : Long.MAX_VALUE;
        }

        public String toString() {
            return this.channel.toString();
        }
    }

    private static interface IChannelProcessor {
        public boolean flushNext() throws IOException;

        public long getLastFlushableTimestamp();
    }

    private final class PrimaryChannelProcessor
    implements IChannelProcessor {
        private @Nullable APCFrameAddressWithVmUIDAndTimestamp currentAddress;
        private final @NonNull Iterator<@NonNull APCFrameAddressWithVmUIDAndTimestamp> iterator;
        private long lastFlushableTimestamp;

        public PrimaryChannelProcessor(List<APCFrameAddressWithVmUIDAndTimestamp> frameList) {
            this.iterator = frameList.iterator();
            this.next();
        }

        @Override
        public boolean flushNext() throws IOException {
            @Nullable APCFrameAddressWithVmUIDAndTimestamp address = this.currentAddress;
            if (address != null) {
                APCFrameRecordReloader.this.frameConsumer.accept((Object)address.address);
                this.next();
            }
            return this.currentAddress != null;
        }

        @Override
        public long getLastFlushableTimestamp() {
            return this.lastFlushableTimestamp;
        }

        public String toString() {
            return "primary-protocol";
        }

        private void next() {
            APCFrameAddressWithVmUIDAndTimestamp address;
            this.currentAddress = address = this.iterator.hasNext() ? this.iterator.next() : null;
            this.lastFlushableTimestamp = address != null ? address.timestamp : Long.MAX_VALUE;
        }
    }
}

