/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.capture.apc.pass_one;

import com.arm.streamline.protocol.capture.apc.pass_one.IExternalProtocolChannelPassOneTracker;
import com.arm.streamline.protocol.capture.apc.protocol.external.ExternalProtocolChannel;
import com.arm.streamline.protocol.capture.apc.protocol.external.ExternalProtocolMessageProperties;
import gnu.trove.map.TIntLongMap;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntLongHashMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class ExternalProtocolChannelPassOneTracker
implements IExternalProtocolChannelPassOneTracker {
    private final @NonNull TIntObjectMap<String> channelNames = new TIntObjectHashMap();
    private final @NonNull Map<@NonNull ExternalProtocolChannel, @NonNull ExternalProtocolChannel> channels = new HashMap<ExternalProtocolChannel, ExternalProtocolChannel>();
    private long externalChannelUIDCounter = 0L;
    private final @NonNull TIntObjectMap<StringBuilder> nameBuilders = new TIntObjectHashMap();
    private final @NonNull TIntLongMap uids = new TIntLongHashMap();
    private final long vmUID;

    public ExternalProtocolChannelPassOneTracker(long vmUID) {
        this.vmUID = vmUID;
    }

    @Override
    public @Nullable ExternalProtocolChannel close(int fd) {
        this.nameBuilders.remove(fd);
        long uid = this.uids.remove(fd);
        @Nullable String name = (String)this.channelNames.remove(fd);
        if (name == null) {
            return null;
        }
        return this.getChannel(false, uid, fd, name);
    }

    @Override
    public @Nullable ExternalProtocolMessageProperties data(int fd, int offset, byte @NonNull [] data) {
        @Nullable String channelName = (String)this.channelNames.get(fd);
        if (channelName != null) {
            if (data.length > 0) {
                return new ExternalProtocolMessageProperties(this.getChannel(false, this.uids.get(fd), fd, channelName), offset, data.length);
            }
        } else {
            StringBuilder builder = (StringBuilder)this.nameBuilders.get(fd);
            if (builder == null) {
                builder = new StringBuilder();
                this.nameBuilders.put(fd, (Object)builder);
            }
            int index = 0;
            while (index < data.length) {
                char c = (char)(data[index] & 0xFF);
                if (c == '\n') {
                    String newChannelName = builder.toString();
                    long uid = this.externalChannelUIDCounter++;
                    this.nameBuilders.remove(fd);
                    this.channelNames.put(fd, (Object)newChannelName);
                    this.uids.put(fd, uid);
                    int remaining = data.length - (index + 1);
                    if (remaining <= 0) break;
                    return new ExternalProtocolMessageProperties(this.getChannel(false, uid, fd, newChannelName), offset + index + 1, remaining);
                }
                builder.append(c);
                ++index;
            }
        }
        return null;
    }

    @Override
    public @NonNull ExternalProtocolChannel getCompactChannel(long uid, int fd, @NonNull String channelName) {
        return this.getChannel(true, uid, fd, channelName);
    }

    private @NonNull ExternalProtocolChannel getChannel(boolean compact, long uid, int fd, @NonNull String channelName) {
        return this.channels.computeIfAbsent(new ExternalProtocolChannel(this.vmUID, compact, uid, fd, channelName), k -> k);
    }
}

