/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.capture.apc.pass_one;

import com.arm.streamline.protocol.capture.apc.io.APCFrame;
import com.arm.streamline.protocol.capture.apc.protocol.DelayProcessingException;
import com.arm.utils.collections.DynamicArrayRingBuffer;
import com.arm.utils.function.IThrowingConsumer;
import java.io.IOException;
import java.io.UncheckedIOException;
import org.eclipse.jdt.annotation.NonNull;

public final class DelayableFrameConsumerQueue {
    private final @NonNull DynamicArrayRingBuffer<@NonNull APCFrame> delayQueue = new DynamicArrayRingBuffer();
    private final @NonNull IThrowingConsumer<@NonNull APCFrame, IOException> frameConsumer;

    public DelayableFrameConsumerQueue(@NonNull IThrowingConsumer<@NonNull APCFrame, IOException> frameConsumer) {
        this.frameConsumer = frameConsumer;
    }

    public void consumeNextFrame(@NonNull APCFrame frame) throws IOException {
        try {
            this.callFrameConsumer(frame);
            this.flushDelayedFrames();
        }
        catch (DelayProcessingException e) {
            this.delayQueue.append((Object)frame);
        }
    }

    public void flushDelayedFrames() throws IOException {
        int count = this.delayQueue.size();
        int i = 0;
        while (i < count) {
            APCFrame delayedFrame = (APCFrame)this.delayQueue.removeHead();
            try {
                this.callFrameConsumer(delayedFrame);
            }
            catch (DelayProcessingException e) {
                this.delayQueue.prepend((Object)delayedFrame);
                break;
            }
            ++i;
        }
    }

    private void callFrameConsumer(@NonNull APCFrame frame) throws IOException {
        try {
            this.frameConsumer.accept((Object)frame);
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }
}

