/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.capture.apc.live;

import com.arm.streamline.protocol.capture.apc.protocol.DelayProcessingException;
import com.arm.streamline.protocol.capture.apc.protocol.external.ExternalProtocolChannel;
import com.arm.streamline.protocol.capture.apc.protocol.external.IExternalProtocolDecoder;
import com.arm.streamline.protocol.capture.apc.protocol.external.IExternalProtocolEventStream;
import com.arm.streamline.protocol.capture.apc.protocol.external.IExternalProtocolPassTwoState;
import com.arm.streamline.protocol.capture.apc.protocol.external.IExternalProtocolProvider;
import com.arm.utils.collections.DynamicArrayRingBuffer;
import com.arm.utils.function.IThrowingLongFunction;
import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class LiveExternalProtocolChannelFrameDataQueue
implements Closeable {
    private final @NonNull DynamicArrayRingBuffer<byte @NonNull []> buffer = new DynamicArrayRingBuffer(true, 1);
    private boolean closed;
    private final @Nullable IExternalProtocolDecoder decoder;

    private static void process(@NonNull IExternalProtocolDecoder decoder, byte @NonNull [] data) throws IOException {
        try {
            decoder.process(data);
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    public LiveExternalProtocolChannelFrameDataQueue(@NonNull ExternalProtocolChannel channel, @NonNull IExternalProtocolProvider provider, @NonNull IThrowingLongFunction<@NonNull IExternalProtocolPassTwoState, IOException> stateProvider, @NonNull IThrowingLongFunction<@NonNull IExternalProtocolEventStream, IOException> outputProvider, boolean isAtraceEnabled) throws IOException {
        this.decoder = provider.get(channel, stateProvider, outputProvider, true, isAtraceEnabled);
    }

    public void append(byte @NonNull [] messageData) {
        if (this.decoder != null) {
            this.buffer.append((Object)messageData);
        }
    }

    public boolean isComplete() {
        return this.closed && this.buffer.isEmpty();
    }

    public void processExternalFrameQueue() throws IOException {
        @Nullable IExternalProtocolDecoder decoder = this.decoder;
        int count = this.buffer.size();
        int i = 0;
        while (i < count) {
            byte @NonNull [] data = (byte[])this.buffer.removeHead();
            try {
                assert (decoder != null);
                LiveExternalProtocolChannelFrameDataQueue.process(decoder, data);
            }
            catch (DelayProcessingException e) {
                this.buffer.prepend((Object)data);
                break;
            }
            ++i;
        }
    }

    public void setClosed() {
        this.closed = true;
    }

    @Override
    public void close() throws IOException {
        @Nullable IExternalProtocolDecoder decoder = this.decoder;
        if (decoder != null) {
            decoder.close();
        }
    }
}

