/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.capture.apc.live;

import com.arm.streamline.protocol.capture.apc.pass_two.IGatorPassTwoEventStream;
import com.arm.streamline.protocol.misc.event_queue.AbstractEventQueue;
import com.arm.streamline.protocol.misc.event_queue.AbstractEventQueueItem;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;

public final class LiveAPCEventQueue
extends AbstractEventQueue<AbstractEventQueueItem> {
    private static final long WINDOW_SIZE_NS = 100000000L;
    private static final long INITIAL_WINDOW_DELAY = 5L;
    private long lastFlushedWindowIndex = -1L;
    private long lastEventTimestamp = -1L;
    private long lastFlushedTimestamp = -1L;
    private final @NonNull IGatorPassTwoEventStream stream;

    public LiveAPCEventQueue(@NonNull IGatorPassTwoEventStream stream) {
        super(0);
        this.stream = stream;
    }

    @Override
    public long clampTimestamp(long timestamp) {
        return Math.max(timestamp, this.lastFlushedTimestamp);
    }

    @Override
    public boolean enqueue(@NonNull AbstractEventQueueItem event) throws IOException {
        this.flushWindow(event.timestamp);
        return super.enqueue(event);
    }

    @Override
    protected void consume(@NonNull AbstractEventQueueItem event) throws IOException {
        event.flushToOutputStream(this.stream);
    }

    private void flushWindow(long timestamp) throws IOException {
        if (timestamp > this.lastEventTimestamp) {
            this.lastEventTimestamp = timestamp;
            long flushIndex = timestamp / 100000000L;
            if (flushIndex >= 5L && flushIndex > this.lastFlushedWindowIndex) {
                this.lastFlushedTimestamp = this.flushUpTo((flushIndex - 5L) * 100000000L);
                this.lastFlushedWindowIndex = flushIndex - 5L;
            }
        }
    }
}

