/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.capture.apc.io;

import com.arm.streamline.protocol.capture.apc.APCFile;
import com.arm.streamline.protocol.capture.apc.io.APCFrameAddress;
import com.arm.utils.function.Throwing;
import com.arm.utils.io.ByteChannelUtils;
import java.io.Closeable;
import java.io.IOException;
import java.nio.channels.ByteChannel;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.StandardOpenOption;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;

public class APCFrameLoader
implements Closeable {
    private final @NonNull Map<@NonNull APCFile, @NonNull SeekableByteChannel> channels = new HashMap<APCFile, SeekableByteChannel>();

    @Override
    public void close() throws IOException {
        Throwing.closeAll((Iterable[])new Iterable[]{this.channels.values()});
    }

    public byte @NonNull [] load(@NonNull APCFile file, long offset, int length) throws IOException {
        @NonNull SeekableByteChannel channel = this.getChannel(file);
        if (offset < 0L || length < 0 || channel.size() < offset + (long)length) {
            throw new IllegalArgumentException();
        }
        channel.position(offset);
        return ByteChannelUtils.readNbytes((ByteChannel)channel, (int)length);
    }

    public byte @NonNull [] load(@NonNull APCFrameAddress address) throws IOException {
        return this.load(address.sourceFile, address.sourceOffset, address.length);
    }

    private @NonNull SeekableByteChannel getChannel(@NonNull APCFile file) throws IOException {
        SeekableByteChannel result = this.channels.get(file);
        if (result == null) {
            result = FileChannel.open(file.file.toPath(), StandardOpenOption.READ);
            this.channels.put(file, result);
        }
        return result;
    }
}

