/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.capture.apc.io;

import com.arm.streamline.protocol.capture.apc.APCDirectory;
import com.arm.streamline.protocol.capture.apc.io.APCCaptureFileFrameStream;
import com.arm.streamline.protocol.capture.apc.io.APCFrame;
import com.arm.streamline.protocol.capture.apc.io.IAPCCaptureFrameStream;
import java.io.EOFException;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class APCCaptureFrameStream
implements IAPCCaptureFrameStream {
    private int currentFileIndex;
    private @Nullable APCCaptureFileFrameStream currentInputStream;
    private final @NonNull APCDirectory directory;

    public APCCaptureFrameStream(@NonNull APCDirectory directory) throws IOException {
        this.directory = directory;
        this.currentFileIndex = 0;
        this.currentInputStream = new APCCaptureFileFrameStream(directory.get(this.currentFileIndex));
    }

    @Override
    public void close() throws IOException {
        @Nullable APCCaptureFileFrameStream currentInputStream = this.currentInputStream;
        if (currentInputStream != null) {
            currentInputStream.close();
            this.currentInputStream = null;
        }
    }

    @Override
    public @NonNull APCFrame nextFrame() throws IOException {
        while (this.currentFileIndex < this.directory.count()) {
            @Nullable APCCaptureFileFrameStream currentInputStream = this.currentInputStream;
            if (currentInputStream == null) {
                this.currentFileIndex = this.directory.count();
                throw new AssertionError((Object)"APCCaptureFileFrameStream is null");
            }
            try {
                return currentInputStream.nextFrame();
            }
            catch (EOFException e) {
                try {
                    try {
                        currentInputStream.close();
                    }
                    catch (Throwable t) {
                        this.currentFileIndex = this.directory.count();
                        throw t;
                    }
                }
                finally {
                    this.currentInputStream = null;
                }
                ++this.currentFileIndex;
                if (this.currentFileIndex >= this.directory.count()) continue;
                try {
                    this.currentInputStream = new APCCaptureFileFrameStream(this.directory.get(this.currentFileIndex));
                }
                catch (Throwable t) {
                    this.currentFileIndex = this.directory.count();
                    throw t;
                }
            }
            catch (Throwable t) {
                this.currentFileIndex = this.directory.count();
                this.safeClose();
                throw t;
            }
        }
        throw new EOFException();
    }

    private void safeClose() {
        try {
            this.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

