/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.protocol.capture.apc.index;

import com.arm.streamline.protocol.capture.apc.io.APCFrameAddress;
import org.eclipse.jdt.annotation.NonNull;

public class APCFrameAddressWithVmUIDAndTimestamp
implements Comparable<APCFrameAddressWithVmUIDAndTimestamp> {
    public final @NonNull APCFrameAddress address;
    public final long timestamp;
    public final long vmUID;

    public APCFrameAddressWithVmUIDAndTimestamp(@NonNull APCFrameAddress address, long vmUID, long timestamp) {
        this.address = address;
        this.vmUID = vmUID;
        this.timestamp = timestamp;
    }

    @Override
    public int compareTo(APCFrameAddressWithVmUIDAndTimestamp o) {
        int timestampResult = Long.compare(this.timestamp, o.timestamp);
        if (timestampResult != 0) {
            return timestampResult;
        }
        return this.address.compareTo(o.address);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof APCFrameAddressWithVmUIDAndTimestamp) {
            APCFrameAddressWithVmUIDAndTimestamp that = (APCFrameAddressWithVmUIDAndTimestamp)obj;
            return this.timestamp == that.timestamp && this.vmUID == that.vmUID && this.address.equals(that.address);
        }
        return false;
    }

    public int hashCode() {
        return (Long.hashCode(this.vmUID) * 31 + this.address.hashCode()) * 31 + Long.hashCode(this.timestamp);
    }

    public String toString() {
        if (this.timestamp > -1L) {
            return String.format("%6d.%09d: 0x%016x: %s", this.timestamp / 1000000000L, this.timestamp % 1000000000L, this.vmUID, this.address);
        }
        return String.format(" <BEFORE START> : 0x%016x: %s", this.vmUID, this.address);
    }
}

