/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.perf.records;

import com.arm.streamline.perf.InvalidPerfDataException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class EventHeader {
    private static final int SIZE_OF = 8;
    private final @Nullable EventAuxHeader auxHeader;
    private final short misc;
    private final int size;
    private final int type;

    public static @NonNull EventHeader fromByteBuffer(@NonNull ByteBuffer input) throws IOException {
        try {
            int type = input.getInt();
            short misc = input.getShort();
            short size = input.getShort();
            if (!EventHeader.validType(type, size)) {
                throw new InvalidPerfDataException(InvalidPerfDataException.Reason.INVALID_RECORD_TYPE);
            }
            EventAuxHeader auxHeader = type == 71 ? new EventAuxHeader(input) : null;
            return new EventHeader(type, misc, size, auxHeader);
        }
        catch (BufferUnderflowException e) {
            throw new IOException(e);
        }
    }

    public static @NonNull EventHeader fromDataInput(@NonNull DataInput input) throws IOException {
        int type = input.readInt();
        short misc = input.readShort();
        short size = input.readShort();
        if (!EventHeader.validType(type, size)) {
            throw new InvalidPerfDataException(InvalidPerfDataException.Reason.INVALID_RECORD_TYPE);
        }
        return new EventHeader(type, misc, size, switch (type) {
            case 71 -> new EventAuxHeader(input);
            case 81 -> throw new InvalidPerfDataException(InvalidPerfDataException.Reason.INVALID_COMPRESSED_RECORD);
            default -> null;
        });
    }

    private static boolean validType(int type, int size) {
        if (type >= 32768) {
            return true;
        }
        if (size >= 0 && size < 8) {
            return false;
        }
        switch (type) {
            case 66: {
                return false;
            }
        }
        return type < 64 || type >= 64 && type < 84;
    }

    public EventHeader(int type, short miscOrSizeUpper, short sizeLower, @Nullable EventAuxHeader auxHeader) {
        this.type = type;
        this.auxHeader = auxHeader;
        if (type > 32768) {
            assert (auxHeader == null);
            this.misc = 0;
            this.size = (sizeLower & 0xFFFF) + (miscOrSizeUpper << 16);
        } else {
            this.misc = miscOrSizeUpper;
            this.size = sizeLower & 0xFFFF;
        }
        assert (this.size >= 8);
    }

    public boolean equals(Object obj) {
        if (obj instanceof EventHeader) {
            EventHeader that = (EventHeader)obj;
            return this.type == that.type && this.misc == that.misc && this.size == that.size;
        }
        return false;
    }

    public @Nullable EventAuxHeader getAuxHeader() {
        return this.auxHeader;
    }

    public int getHeaderSize() {
        @Nullable EventAuxHeader auxHeader = this.auxHeader;
        if (auxHeader != null) {
            return this.size;
        }
        return 8;
    }

    public short getMisc() {
        return this.misc;
    }

    public long getPayloadSize() {
        @Nullable EventAuxHeader auxHeader = this.auxHeader;
        if (auxHeader != null) {
            return auxHeader.size;
        }
        return this.size - 8;
    }

    public int getPayloadSizeAsInt() {
        long result = this.getPayloadSize();
        if (result < 0L || result >= Integer.MAX_VALUE) {
            throw new OutOfMemoryError("Payload too large for perf record");
        }
        return (int)result;
    }

    public long getTotalSize() {
        @Nullable EventAuxHeader auxHeader = this.auxHeader;
        return (long)this.size + (auxHeader != null ? auxHeader.size : 0L);
    }

    public int getType() {
        return this.type;
    }

    public int hashCode() {
        @Nullable EventAuxHeader auxHeader = this.auxHeader;
        int prime = 31;
        int result = 1;
        result = 31 * result + this.type;
        result = 31 * result + this.misc;
        result = 31 * result + this.size;
        result = 31 * result + (auxHeader != null ? auxHeader.hashCode() : 0);
        return result;
    }

    public String toString() {
        return String.format("EventHeader [type=0x%s, misc=0x%s, size=%s, auxHeader=%s]", Integer.toHexString(this.type), Integer.toHexString(this.misc & 0xFFFF), this.size & 0xFFFF, this.auxHeader);
    }

    public void write(@NonNull DataOutput output) throws IOException {
        @Nullable EventAuxHeader auxHeader = this.auxHeader;
        output.writeInt(this.type);
        output.writeShort(this.misc);
        output.writeShort(this.size);
        if (auxHeader != null) {
            auxHeader.write(output);
        }
    }

    public static final class EventAuxHeader {
        public final int cpu;
        public final int idx;
        public final long offset;
        public final long reference;
        public final long size;
        public final int tid;

        public EventAuxHeader(@NonNull ByteBuffer input) throws IOException {
            try {
                this.size = input.getLong();
                this.offset = input.getLong();
                this.reference = input.getLong();
                this.idx = input.getInt();
                this.tid = input.getInt();
                this.cpu = input.getInt();
                input.getInt();
            }
            catch (BufferUnderflowException e) {
                throw new IOException(e);
            }
        }

        public EventAuxHeader(@NonNull DataInput input) throws IOException {
            this.size = input.readLong();
            this.offset = input.readLong();
            this.reference = input.readLong();
            this.idx = input.readInt();
            this.tid = input.readInt();
            this.cpu = input.readInt();
            input.readInt();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof EventAuxHeader) {
                EventAuxHeader that = (EventAuxHeader)obj;
                return this.cpu == that.cpu && this.idx == that.idx && this.offset == that.offset && this.reference == that.reference && this.size == that.size && this.tid == that.tid;
            }
            return false;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.cpu;
            result = 31 * result + this.idx;
            result = 31 * result + (int)(this.offset ^ this.offset >>> 32);
            result = 31 * result + (int)(this.reference ^ this.reference >>> 32);
            result = 31 * result + (int)(this.size ^ this.size >>> 32);
            result = 31 * result + this.tid;
            return result;
        }

        public String toString() {
            return String.format("EventAuxHeader [size=%s, offset=%s, reference=%s, idx=%s, tid=%s, cpu=%s]", this.size, this.offset, this.reference, this.idx, this.tid, this.cpu);
        }

        public void write(@NonNull DataOutput output) throws IOException {
            output.writeLong(this.size);
            output.writeLong(this.offset);
            output.writeLong(this.reference);
            output.writeInt(this.idx);
            output.writeInt(this.tid);
            output.writeInt(this.cpu);
            output.writeInt(0);
        }
    }
}

