/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.log;

import com.arm.streamline.log.IAPCGatorLogWriter;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class APCGatorLogWriter
implements IAPCGatorLogWriter {
    private @NonNull File logFile;
    private @Nullable OutputStream outputStream;

    public APCGatorLogWriter(@NonNull File apcDirectory) throws IOException {
        File parentFile;
        this.logFile = new File(apcDirectory, "gator-log.txt");
        if (this.logFile.exists()) {
            this.logFile.delete();
        }
        if ((parentFile = this.logFile.getParentFile()) != null && !parentFile.exists()) {
            parentFile.mkdirs();
        }
        this.logFile.createNewFile();
        this.outputStream = new BufferedOutputStream(new FileOutputStream(this.logFile));
    }

    @Override
    public void close() {
        try {
            if (this.outputStream != null) {
                this.closeCurrentFile(this.outputStream);
            }
            if (this.logFile.exists() && this.logFile.length() == 0L) {
                this.logFile.delete();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void closeCurrentFile(@NonNull OutputStream outputStream) throws IOException {
        outputStream.flush();
        outputStream.close();
        this.outputStream = null;
    }

    @Override
    public void writeLog(byte @NonNull [] data) throws IOException {
        @Nullable OutputStream outputStream = this.outputStream;
        assert (outputStream != null);
        assert (data.length > 0);
        outputStream.write(data);
    }
}

