/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.ftrace;

import com.arm.streamline.common.utility.io.BufferUtils;
import com.arm.streamline.common.utility.io.XMLGenerator;
import com.arm.streamline.common.utility.io.XMLParser;
import com.arm.utils.NullChecking;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;

public class TracepointField {
    private static final @NonNull String ATTR_NAME = "name";
    private static final @NonNull String ATTR_OFFSET = "offset";
    private static final @NonNull String ATTR_SIGNED = "signed";
    private static final @NonNull String ATTR_SIZE = "size";
    private static final @NonNull String ATTR_DYNAMIC_STRING = "is_dynamic_string";
    private static final @NonNull String DYNAMIC_STRING_PREFIX = "__data_loc char";
    private static final Pattern PATTERN = Pattern.compile(" ([^ ]+);\toffset:([0-9]+);\tsize:([0-9]+);\tsigned:([0-9]+);");
    private final @NonNull String mName;
    private final int mOffset;
    private final boolean mSigned;
    private final int mSize;
    private final boolean mIsDynamicString;

    public TracepointField(String field) {
        Matcher matcher = PATTERN.matcher(field);
        matcher.find();
        this.mName = (String)NullChecking.neverNull((Object)matcher.group(1));
        this.mOffset = Integer.parseInt(matcher.group(2));
        this.mSize = Integer.parseInt(matcher.group(3));
        this.mSigned = Integer.parseInt(matcher.group(4)) != 0;
        this.mIsDynamicString = field.startsWith(DYNAMIC_STRING_PREFIX);
    }

    public TracepointField(@NonNull String name, int offset, int size, boolean signed) {
        this(name, offset, size, signed, false);
    }

    public TracepointField(@NonNull String name, int offset, int size, boolean signed, boolean isDynamicString) {
        this.mName = name;
        this.mOffset = offset;
        this.mSize = size;
        this.mSigned = signed;
        this.mIsDynamicString = isDynamicString;
    }

    public TracepointField(XMLParser xml) {
        this.mName = (String)NullChecking.neverNull((Object)xml.getAttribute(ATTR_NAME));
        this.mOffset = xml.getIntegerAttribute(ATTR_OFFSET);
        this.mSize = xml.getIntegerAttribute(ATTR_SIZE);
        this.mSigned = xml.isAttributeSet(ATTR_SIGNED);
        this.mIsDynamicString = xml.isAttributeSet(ATTR_DYNAMIC_STRING);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TracepointField) {
            TracepointField that = (TracepointField)obj;
            return this.mSigned == that.mSigned && this.mSize == that.mSize && this.mOffset == that.mOffset && this.mName.equals(that.mName);
        }
        return false;
    }

    public long getInt(byte[] raw) throws IOException {
        return this.getInt(raw, 0);
    }

    public long getInt(byte[] raw, int offset) throws IOException {
        return BufferUtils.readLEIntSize((byte[])raw, (int)(offset + this.mOffset), (int)this.mSize, (boolean)this.mSigned);
    }

    public @NonNull String getName() {
        return this.mName;
    }

    public int getOffset() {
        return this.mOffset;
    }

    public int getSize() {
        return this.mSize;
    }

    public @NonNull String getString(byte[] raw, int offset) {
        int maxLen = this.mSize == 0 ? raw.length - offset - this.mOffset : this.mSize;
        int len = 0;
        while (len < maxLen) {
            if (raw[offset + this.mOffset + len] == 0) break;
            ++len;
        }
        return new String(raw, offset + this.mOffset, len, StandardCharsets.US_ASCII);
    }

    public boolean isDynamicString() {
        return this.mIsDynamicString;
    }

    public int hashCode() {
        return ((this.mName.hashCode() * 31 + this.mOffset) * 31 + this.mSize) * 31 + Boolean.hashCode(this.mSigned);
    }

    public void print(byte[] raw) {
        System.out.print(this.mName + ": ");
        try {
            System.out.println(this.getInt(raw));
        }
        catch (IOException e) {
            System.out.println("?");
        }
    }

    public String toString() {
        return String.format("TracepointField [mName=%s, mOffset=%s, mSize=%s, mSigned=%s]", this.mName, this.mOffset, this.mSize, this.mSigned);
    }

    public void write(XMLGenerator xml) throws IOException {
        xml.addAttribute(ATTR_NAME, this.mName);
        xml.addAttribute(ATTR_OFFSET, this.mOffset);
        xml.addAttribute(ATTR_SIZE, this.mSize);
        xml.addAttribute(ATTR_SIGNED, this.mSigned);
        xml.addAttribute(ATTR_DYNAMIC_STRING, this.mIsDynamicString);
    }
}

