/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.common.xml.spe;

import com.arm.streamline.common.xml.counters.IConfiguredEvent;
import com.arm.streamline.common.xml.spe.SpeFilterEventProperties;
import com.arm.streamline.common.xml.spe.SpeTargetDescription;
import com.arm.streamline.common.xml.spe.SpeVersion;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;

public class SpeFilterConfiguration
implements IConfiguredEvent {
    private final @NonNull Set<@NonNull SpeFilterEventProperties> events = new HashSet<SpeFilterEventProperties>();
    private final @NonNull SpeTargetDescription spe;
    private @NonNull Set<@NonNull OpType> opTypes = new HashSet<OpType>();
    private int minLatency = 0;
    private boolean isInvertEventFilter = false;
    public static final int MIN_LATENCY_MAX = 4095;
    public static final int MIN_LATENCY_MIN = 0;
    private final boolean supportsSpev1p2;

    public SpeFilterConfiguration(@NonNull SpeTargetDescription spe) {
        this.spe = spe;
        this.supportsSpev1p2 = this.supportsSpev1p2();
    }

    public @NonNull Set<@NonNull SpeFilterEventProperties> getEvents() {
        return Collections.unmodifiableSet(this.events);
    }

    public void addEvents(@NonNull Collection<@NonNull SpeFilterEventProperties> events) {
        this.events.addAll(events);
    }

    public void addEvent(@NonNull SpeFilterEventProperties events) {
        this.events.add(events);
    }

    public void removeEvents(@NonNull Collection<@NonNull SpeFilterEventProperties> events) {
        this.events.removeAll(events);
    }

    public void removeEvent(@NonNull SpeFilterEventProperties event) {
        this.events.remove(event);
    }

    public void removeAllEvents() {
        this.events.clear();
    }

    public @NonNull String getName() {
        return this.spe.getName();
    }

    public @NonNull String getId() {
        return this.spe.getId();
    }

    public @NonNull Collection<@NonNull OpType> getOpType() {
        return this.opTypes;
    }

    public void setOpType(@NonNull Set<@NonNull OpType> opType) {
        this.opTypes = opType;
    }

    public void addOpType(@NonNull OpType type) {
        this.opTypes.add(type);
    }

    public void removeOpType(@NonNull OpType type) {
        this.opTypes.remove((Object)type);
    }

    public void removeAllOpTypes() {
        this.opTypes.clear();
    }

    public int getMinLatency() {
        return this.minLatency;
    }

    public void setMinLatency(int minLatency) {
        boolean isClipped = false;
        if (minLatency < 0) {
            minLatency = 0;
            isClipped = true;
        } else if (minLatency > 4095) {
            minLatency = 4095;
            isClipped = true;
        }
        this.minLatency = minLatency;
        if (isClipped) {
            throw new IllegalArgumentException("Minimum Latency is clipped as it is not in range [0-4095]");
        }
    }

    private boolean supportsSpev1p2() {
        SpeVersion speVersion = this.spe.getSpeVersion();
        if (speVersion == null) {
            return false;
        }
        SpeVersion speVersionv1p2 = new SpeVersion(1, 2);
        return speVersion.compareTo(speVersionv1p2) >= 0;
    }

    public boolean getSupportsSpev1p2() {
        return this.supportsSpev1p2;
    }

    public boolean getIsInvertEventFilter() {
        return this.getSupportsSpev1p2() && this.isInvertEventFilter;
    }

    public void setIsInvertEventFilter(boolean isInvertEventFilter) {
        this.isInvertEventFilter = isInvertEventFilter;
    }

    public @NonNull Set<@NonNull SpeFilterEventProperties> getAllSpeFilterEvents() {
        return Collections.unmodifiableSet(this.spe.getAllValidSpeFilterEvents());
    }

    public final @NonNull SpeTargetDescription getTargetDescription() {
        return this.spe;
    }

    @Override
    public SpeTargetDescription getDerivedFrom() {
        return this.spe;
    }

    public String toString() {
        return "SpeFilterConfiguration [getId()=" + this.getId() + "]";
    }

    public static enum OpType {
        Load,
        Store,
        Branch;

    }
}

