/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.common.xml.pmus;

import com.arm.streamline.common.CommonPlugin;
import com.arm.streamline.common.utility.io.StdLog;
import com.arm.streamline.common.utility.io.XMLParser;
import com.arm.utils.NullChecking;
import com.arm.utils.text.BasicNumberUtils;
import com.arm.utils.text.BasicStringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ProcessorPmuEventDescription {
    public static final @NonNull Integer CYCLE_COUNTER_KEY = -1;
    private static final String ATTRIBUTE_COUNTER = "counter";
    private static final String ATTRIBUTE_COUNTER_SET = "counter_set";
    private static final String ATTRIBUTE_DESCRIPTION = "description";
    private static final String ATTRIBUTE_EVENT = "event";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_PER_CPU = "per_cpu";
    private static final String ATTRIBUTE_TITLE = "title";
    private static final String TAG_CATEGORY = "category";
    private static final String TAG_EVENT = "event";
    private static final String TAG_EVENTS = "events";
    private final @NonNull String cpuName;
    private final @Nullable String description;
    private final int eventID;
    private final @NonNull String eventName;
    private final @NonNull String groupName;

    /*
     * Unable to fully structure code
     */
    public static @NonNull Map<@NonNull String, @NonNull Map<@NonNull Integer, @NonNull ProcessorPmuEventDescription>> loadEventsXml(@NonNull InputStream inputStream) throws IOException {
        result = new HashMap<String, Map<Integer, ProcessorPmuEventDescription>>();
        var2_2 = null;
        var3_4 = null;
        try {
            xml = new XMLParser(inputStream);
lbl6:
            // 2 sources

            try {
                while ((tag = xml.nextTag()) != null) {
                    block25: {
                        if (!"events".equals(tag)) break block25;
                        marker = xml.getMarker();
                        while ((tag = xml.nextTag(marker)) != null) {
                            if ("category".equals(tag)) {
                                innerMarker = xml.getMarker();
                                categoryName = xml.getAttribute("name");
                                categoryCounterSet = xml.getAttribute("counter_set");
                                categoryIsPerCpu = xml.getAttribute("per_cpu", "false");
                                if (BasicNumberUtils.getBoolean((String)categoryIsPerCpu) && categoryCounterSet != null && categoryCounterSet.endsWith("_cnt") && categoryName != null) {
                                    pmuName = categoryCounterSet.replaceAll("_cnt$", "").toLowerCase();
                                    cycleCounterName = categoryCounterSet.replaceAll("_cnt$", "_ccnt");
                                    if (result.containsKey(pmuName)) {
                                        throw new AssertionError((Object)("Duplicate: " + categoryCounterSet));
                                    }
                                    childMap = new TreeMap<Integer, ProcessorPmuEventDescription>();
                                    result.put(pmuName, childMap);
                                    while ((tag = xml.nextTag(innerMarker)) != null) {
                                        if ("event".equals(tag)) {
                                            eventCounter = xml.getAttribute("counter");
                                            eventGroup = xml.getAttribute("title");
                                            eventName = xml.getAttribute("name");
                                            eventDescription = xml.getAttribute("description");
                                            eventID = xml.getIntegerAttribute("event");
                                            isEventCounter = eventCounter == null && xml.hasAttribute("event") != false;
                                            v0 = isCycleCounter = eventCounter != null && eventCounter.equals(cycleCounterName) != false;
                                            if ((isEventCounter || isCycleCounter) && eventGroup != null && eventName != null) {
                                                if (isCycleCounter) {
                                                    if (childMap.containsKey(ProcessorPmuEventDescription.CYCLE_COUNTER_KEY)) {
                                                        StdLog.warning(CommonPlugin.getInstance(), "Duplicate cycle counter in " + categoryCounterSet, null);
                                                    } else {
                                                        childMap.put(ProcessorPmuEventDescription.CYCLE_COUNTER_KEY, new ProcessorPmuEventDescription(ProcessorPmuEventDescription.CYCLE_COUNTER_KEY, categoryName, eventGroup, eventName, eventDescription));
                                                    }
                                                } else if (isEventCounter || eventID != 0) {
                                                    key = eventID;
                                                    if (childMap.containsKey(key)) {
                                                        StdLog.warning(CommonPlugin.getInstance(), "Duplicate event id " + categoryCounterSet + " : " + eventID, null);
                                                    } else {
                                                        childMap.put(key, new ProcessorPmuEventDescription(eventID, categoryName, eventGroup, eventName, eventDescription));
                                                    }
                                                }
                                            }
                                        }
                                        xml.skip();
                                    }
                                    continue;
                                }
                                xml.skip();
                                continue;
                            }
                            xml.skip();
                        }
                        ** GOTO lbl6
                    }
                    xml.skip();
                }
            }
            finally {
                if (xml != null) {
                    xml.close();
                }
            }
        }
        catch (Throwable var3_5) {
            if (var2_2 == null) {
                var2_2 = var3_5;
            } else if (var2_2 != var3_5) {
                var2_2.addSuppressed(var3_5);
            }
            throw var2_2;
        }
        return result;
    }

    public ProcessorPmuEventDescription(int eventID, @NonNull String cpuName, @NonNull String groupName, @NonNull String eventName, @Nullable String description) {
        this.cpuName = cpuName;
        this.groupName = groupName;
        this.eventName = eventName;
        this.description = description;
        this.eventID = eventID;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ProcessorPmuEventDescription) {
            ProcessorPmuEventDescription that = (ProcessorPmuEventDescription)obj;
            return this.eventID == that.eventID && this.cpuName.equals(that.cpuName) && this.eventName.equals(that.eventName) && this.groupName.equals(that.groupName) && NullChecking.equalsNullable((Object)this.description, (Object)that.description);
        }
        return false;
    }

    public @NonNull String getComment() {
        if (this.description != null) {
            return String.format("[0x%x] %s/%s/%s - %s", this.eventID, this.cpuName, this.groupName, this.eventName, this.description);
        }
        return String.format("[0x%x] %s/%s/%s", this.eventID, this.cpuName, this.groupName, this.eventName);
    }

    public @NonNull String getConstantName() {
        return String.format("BARMAN_PMU_EVENT_%s_%s_%s", BasicStringUtils.makeIdentifier((String)this.cpuName), BasicStringUtils.makeIdentifier((String)this.groupName), BasicStringUtils.makeIdentifier((String)this.eventName)).toUpperCase();
    }

    public @NonNull String getCpuName() {
        return this.cpuName;
    }

    public @Nullable String getDescription() {
        return this.description;
    }

    public int getEventID() {
        return this.eventID;
    }

    public @NonNull String getEventName() {
        return this.eventName;
    }

    public @NonNull String getGroupName() {
        return this.groupName;
    }

    public int hashCode() {
        return 31 * (31 + this.groupName.hashCode()) + this.eventID;
    }

    public boolean isCycleCounter() {
        return this.eventID == CYCLE_COUNTER_KEY;
    }
}

