/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.common.xml.counters;

import com.arm.streamline.common.utility.io.XMLGenerator;
import com.arm.streamline.common.utility.io.XMLParser;
import com.arm.streamline.common.xml.counters.CounterSet;
import com.arm.streamline.common.xml.counters.IConfiguredEvent;
import com.arm.streamline.common.xml.counters.Option;
import com.arm.streamline.common.xml.counters.OptionSet;
import com.arm.streamline.common.xml.counters.StockCounter;
import java.io.IOException;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class TargetCounter
implements IConfiguredEvent {
    private final @NonNull String mCounterName;
    private final @NonNull StockCounter mDerivedFrom;
    private final @Nullable Long mEvent;

    public static @NonNull String computeKey(@NonNull String counterName, @Nullable Long event) {
        return event != null ? TargetCounter.computeKey(counterName, (long)event) : TargetCounter.computeKey(counterName);
    }

    public static @NonNull String computeKey(@NonNull String counterName, long event) {
        return String.format("%s:%08x", counterName, event);
    }

    public static @NonNull String computeKey(@NonNull String counterName) {
        return counterName;
    }

    public static @Nullable TargetCounter find(@NonNull Map<String, StockCounter> stockCounterMap, @NonNull String counterName, @Nullable Long event) {
        String key = TargetCounter.computeKey(counterName, event);
        @Nullable StockCounter stockCounter = stockCounterMap.get(key);
        if (stockCounter != null) {
            return new TargetCounter(stockCounter, counterName, event);
        }
        if (event != null) {
            return TargetCounter.find(stockCounterMap, counterName, null);
        }
        return null;
    }

    public static int loadEbs(XMLParser in) {
        return in.getIntegerAttribute("count", 0);
    }

    public TargetCounter(@NonNull StockCounter counter, @NonNull String counterName, @Nullable Option option) {
        this.mDerivedFrom = counter;
        this.mCounterName = counterName;
        Long baseEvent = counter.getEvent();
        this.mEvent = baseEvent != null && option != null ? Long.valueOf(option.calculateEventCode(baseEvent)) : baseEvent;
    }

    public TargetCounter(@NonNull StockCounter stockCounter, @NonNull String counterName, @Nullable Long event) {
        this.mDerivedFrom = stockCounter;
        this.mCounterName = counterName;
        this.mEvent = event;
    }

    public @NonNull String getCounterName() {
        return this.mCounterName;
    }

    @Override
    public @NonNull StockCounter getDerivedFrom() {
        return this.mDerivedFrom;
    }

    public @NonNull String getDisplayTitle() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getTitle());
        buffer.append(": ");
        buffer.append(this.getQualifiedName());
        return buffer.toString();
    }

    public @NonNull String getKey() {
        return TargetCounter.computeKey(this.mCounterName, this.mEvent);
    }

    public @NonNull StockCounter.Combination getCombo() {
        return new StockCounter.Combination(this.mDerivedFrom, this.getOption(), this.getCounterSet());
    }

    public @Nullable Option getOption() {
        OptionSet options;
        Long event = this.mEvent;
        Long derivedFromEvent = this.mDerivedFrom.getEvent();
        if (event != null && (options = this.mDerivedFrom.getOptionSet()) != null) {
            assert (derivedFromEvent != null);
            for (Option option : options.getOptions()) {
                if (option.calculateEventCode(derivedFromEvent) != event.longValue()) continue;
                return option;
            }
        }
        return null;
    }

    public @NonNull String getQualifiedName() {
        return this.mDerivedFrom.getQualifiedName(this.getOption(), this.getCounterSet());
    }

    public @NonNull String getTitle() {
        return this.mDerivedFrom.getTitle();
    }

    public void saveAsTargetConfiguration(@NonNull XMLGenerator xml, @NonNull String tag, int eventBasedSamplingCount) throws IOException {
        xml.startEmptyTag(tag);
        xml.addAttribute("counter", this.mCounterName);
        if (this.mEvent != null) {
            xml.addAttribute("event", String.format("%#x", this.mEvent));
        }
        if (eventBasedSamplingCount > 0) {
            xml.addAttribute("count", eventBasedSamplingCount);
        }
        this.mDerivedFrom.addAdditionalAttributes(xml);
    }

    public String toString() {
        return this.getKey() + " - " + this.mDerivedFrom.toString();
    }

    public @Nullable CounterSet getCounterSet() {
        return this.mDerivedFrom.getCategory().getCounterSet(this.getKey());
    }

    public @NonNull String getUniqueSourceName() {
        return this.getDerivedFrom().getUniqueSourceName(this.getOption(), this.getCounterSet(), false);
    }
}

